/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.drivers.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.embedded.request.EmbeddedRequest;
import org.neo4j.ogm.drivers.embedded.transaction.EmbeddedTransaction;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDriver
extends AbstractConfigurableDriver {
    private GraphDatabaseService graphDatabaseService;
    private final Logger logger = LoggerFactory.getLogger(EmbeddedDriver.class);

    public EmbeddedDriver() {
    }

    public EmbeddedDriver(DriverConfiguration driverConfiguration) {
        this.configure(driverConfiguration);
    }

    public EmbeddedDriver(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EmbeddedDriver.this.close();
            }
        });
    }

    @Override
    public synchronized void configure(DriverConfiguration config) {
        super.configure(config);
        this.close();
        try {
            String fileStoreUri = config.getURI();
            if (fileStoreUri == null) {
                fileStoreUri = this.createTemporaryEphemeralFileStore();
            }
            File file = new File(new URI(fileStoreUri));
            this.graphDatabaseService = new GraphDatabaseFactory().newEmbeddedDatabase(file);
            this.registerShutdownHook();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Transaction newTransaction() {
        return new EmbeddedTransaction(this.transactionManager, this.nativeTransaction());
    }

    public void close() {
        if (this.graphDatabaseService != null) {
            this.graphDatabaseService.shutdown();
            this.graphDatabaseService = null;
        }
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    public Request request() {
        return new EmbeddedRequest(this.graphDatabaseService, this.transactionManager);
    }

    private org.neo4j.graphdb.Transaction nativeTransaction() {
        org.neo4j.graphdb.Transaction nativeTransaction;
        Transaction tx = this.transactionManager.getCurrentTransaction();
        if (tx != null) {
            this.logger.debug("Using current transaction: {}", (Object)tx);
            nativeTransaction = ((EmbeddedTransaction)tx).getNativeTransaction();
        } else {
            this.logger.debug("No current transaction, starting a new one");
            nativeTransaction = this.graphDatabaseService.beginTx();
        }
        this.logger.debug("Native transaction: {}", (Object)nativeTransaction);
        return nativeTransaction;
    }

    private String createTemporaryEphemeralFileStore() {
        try {
            Path path = Files.createTempDirectory("neo4j.db", new FileAttribute[0]);
            File f = path.toFile();
            f.deleteOnExit();
            URI uri = f.toURI();
            String fileStoreUri = uri.toString();
            return fileStoreUri;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

