/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.ogm.drivers.embedded.response.JsonAdapter;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.result.ResultAdapter;

public class GraphModelAdapter
extends JsonAdapter
implements ResultAdapter<Map<String, Object>, GraphModel> {
    public GraphModel adapt(Map<String, Object> data) {
        HashSet nodeIdentities = new HashSet();
        HashSet edgeIdentities = new HashSet();
        DefaultGraphModel graphModel = new DefaultGraphModel();
        for (Map.Entry<String, Object> mapEntry : data.entrySet()) {
            if (mapEntry.getValue() instanceof Path) {
                this.buildPath((Path)mapEntry.getValue(), (GraphModel)graphModel, nodeIdentities, edgeIdentities);
                continue;
            }
            if (mapEntry.getValue() instanceof Node) {
                this.buildNode((Node)mapEntry.getValue(), (GraphModel)graphModel, nodeIdentities);
                continue;
            }
            if (mapEntry.getValue() instanceof Relationship) {
                this.buildRelationship((Relationship)mapEntry.getValue(), (GraphModel)graphModel, nodeIdentities, edgeIdentities);
                continue;
            }
            if (!(mapEntry.getValue() instanceof Iterable)) continue;
            Iterable collection = (Iterable)mapEntry.getValue();
            for (Object element : collection) {
                if (element instanceof Path) {
                    this.buildPath((Path)element, (GraphModel)graphModel, nodeIdentities, edgeIdentities);
                    continue;
                }
                if (element instanceof Node) {
                    this.buildNode((Node)element, (GraphModel)graphModel, nodeIdentities);
                    continue;
                }
                if (element instanceof Relationship) {
                    this.buildRelationship((Relationship)element, (GraphModel)graphModel, nodeIdentities, edgeIdentities);
                    continue;
                }
                throw new RuntimeException("Not handled:" + mapEntry.getValue().getClass());
            }
        }
        return graphModel;
    }

    void buildPath(Path path, GraphModel graphModel, Set nodeIdentities, Set edgeIdentities) {
        Iterator relIterator = path.relationships().iterator();
        Iterator nodeIterator = path.nodes().iterator();
        while (relIterator.hasNext()) {
            Relationship rel = (Relationship)relIterator.next();
            this.buildRelationship(rel, graphModel, nodeIdentities, edgeIdentities);
        }
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            this.buildNode(node, graphModel, nodeIdentities);
        }
    }

    void buildNode(Node node, GraphModel graphModel, Set nodeIdentities) {
        if (!nodeIdentities.contains(node.getId())) {
            nodeIdentities.add(node.getId());
            NodeModel nodeModel = new NodeModel();
            nodeModel.setId(Long.valueOf(node.getId()));
            ArrayList<String> labelNames = new ArrayList<String>();
            for (Label label : node.getLabels()) {
                labelNames.add(label.name());
            }
            nodeModel.setLabels(labelNames.toArray(new String[0]));
            nodeModel.setProperties(this.buildProperties((PropertyContainer)node));
            graphModel.getNodes().add(nodeModel);
        }
    }

    void buildRelationship(Relationship relationship, GraphModel graphModel, Set nodeIdentities, Set edgeIdentities) {
        if (!edgeIdentities.contains(relationship.getId())) {
            edgeIdentities.add(relationship.getId());
            RelationshipModel edgeModel = new RelationshipModel();
            edgeModel.setId(Long.valueOf(relationship.getId()));
            edgeModel.setType(relationship.getType().name());
            edgeModel.setStartNode(Long.valueOf(relationship.getStartNode().getId()));
            edgeModel.setEndNode(Long.valueOf(relationship.getEndNode().getId()));
            edgeModel.setProperties(this.buildProperties((PropertyContainer)relationship));
            graphModel.getRelationships().add(edgeModel);
            this.buildNode(relationship.getStartNode(), graphModel, nodeIdentities);
            this.buildNode(relationship.getEndNode(), graphModel, nodeIdentities);
        }
    }

    Map<String, Object> buildProperties(PropertyContainer container) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String k : container.getPropertyKeys()) {
            Object v = container.getProperty(k);
            if (v.getClass().isArray()) {
                properties.put(k, GraphModelAdapter.convertToIterable(v));
                continue;
            }
            properties.put(k, v);
        }
        return properties;
    }
}

