/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.result.ResultAdapter;

public class RestModelAdapter
implements ResultAdapter<Map<String, Object>, Map<String, Object>> {
    public Map<String, Object> adapt(Map<String, Object> result) {
        LinkedHashMap<String, Object> adaptedResults = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                ArrayList<Object> adaptedValues = new ArrayList<Object>();
                List values = (List)value;
                for (Object element : values) {
                    adaptedValues.add(this.processData(element));
                }
                adaptedResults.put(entry.getKey(), adaptedValues);
                continue;
            }
            adaptedResults.put(entry.getKey(), this.processData(value));
        }
        return adaptedResults;
    }

    private Object processData(Object element) {
        if (element instanceof Node) {
            return this.buildNode((Node)element);
        }
        if (element instanceof Relationship) {
            return this.buildRelationship((Relationship)element);
        }
        return element;
    }

    private NodeModel buildNode(Node node) {
        NodeModel nodeModel = new NodeModel();
        nodeModel.setId(Long.valueOf(node.getId()));
        ArrayList<String> labels = new ArrayList<String>();
        for (Label label : node.getLabels()) {
            labels.add(label.name());
        }
        nodeModel.setLabels(labels.toArray(new String[labels.size()]));
        nodeModel.setProperties(node.getAllProperties());
        return nodeModel;
    }

    private RelationshipModel buildRelationship(Relationship relationship) {
        RelationshipModel relationshipModel = new RelationshipModel();
        relationshipModel.setId(Long.valueOf(relationship.getId()));
        relationshipModel.setStartNode(Long.valueOf(relationship.getStartNode().getId()));
        relationshipModel.setEndNode(Long.valueOf(relationship.getEndNode().getId()));
        relationshipModel.setType(relationship.getType().name());
        relationshipModel.setProperties(relationship.getAllProperties());
        return relationshipModel;
    }
}

