/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.drivers.embedded.response.JsonAdapter;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.response.model.QueryStatisticsModel;
import org.neo4j.ogm.result.ResultAdapter;

public class StatisticsModelAdapter
extends JsonAdapter
implements ResultAdapter<Result, QueryStatisticsModel> {
    public QueryStatisticsModel adapt(Result response) {
        try {
            QueryStatistics statistics = response.getQueryStatistics();
            String stats = mapper.writeValueAsString((Object)statistics);
            stats = stats.replace("Deleted", "_deleted");
            stats = stats.replace("Added", "_added");
            stats = stats.replace("Updates", "_updates");
            stats = stats.replace("Created", "_created");
            stats = stats.replace("Set", "_set");
            stats = stats.replace("Removed", "_removed");
            stats = stats.replace("deletedNodes", "nodes_deleted");
            stats = stats.replace("deletedRelationships", "relationships_deleted");
            String containsUpdates = ",\"contains_updates\":" + statistics.containsUpdates();
            int closingBraceIndex = stats.lastIndexOf("}");
            stats = stats.substring(0, closingBraceIndex) + containsUpdates + "}";
            return (QueryStatisticsModel)mapper.readValue(stats, QueryStatisticsModel.class);
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not read response statistics", e);
        }
    }
}

