/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.neo4j.ogm.authentication.Credentials;
import org.neo4j.ogm.drivers.http.request.HttpAuthorization;
import org.neo4j.ogm.drivers.http.response.GraphModelResponse;
import org.neo4j.ogm.drivers.http.response.GraphRowsModelResponse;
import org.neo4j.ogm.drivers.http.response.RestModelResponse;
import org.neo4j.ogm.drivers.http.response.RowModelResponse;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.json.ObjectMapperFactory;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.RestModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.Statements;
import org.neo4j.ogm.response.EmptyResponse;
import org.neo4j.ogm.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest
implements Request {
    private static final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    private final String url;
    private final CloseableHttpClient httpClient;
    private final Credentials credentials;

    public HttpRequest(CloseableHttpClient httpClient, String url, Credentials credentials) {
        this.httpClient = httpClient;
        this.url = url;
        this.credentials = credentials;
    }

    public Response<GraphModel> execute(GraphModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        try {
            return new GraphModelResponse(this.executeRequest(cypher));
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not parse response", e);
        }
    }

    public Response<RowModel> execute(RowModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        try {
            return new RowModelResponse(this.executeRequest(cypher));
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not parse response", e);
        }
    }

    public Response<RowModel> execute(DefaultRequest query) {
        Statements statements = new Statements(query.getStatements());
        String cypher = this.cypherRequest(statements);
        try {
            return new RowModelResponse(this.executeRequest(cypher));
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not parse response", e);
        }
    }

    public Response<GraphRowListModel> execute(GraphRowListModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        try {
            return new GraphRowsModelResponse(this.executeRequest(cypher));
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not parse response", e);
        }
    }

    public Response<RestModel> execute(RestModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        try {
            return new RestModelResponse(this.executeRequest(cypher));
        }
        catch (Exception e) {
            throw new ResultProcessingException("Could not parse response", e);
        }
    }

    private String cypherRequest(Statement statement) {
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        statementList.add(statement);
        try {
            return mapper.writeValueAsString((Object)new Statements(statementList));
        }
        catch (JsonProcessingException jpe) {
            throw new ResultProcessingException("Could not create JSON due to " + jpe.getLocalizedMessage(), (Exception)((Object)jpe));
        }
    }

    private String cypherRequest(Statements statements) {
        try {
            return mapper.writeValueAsString((Object)statements);
        }
        catch (JsonProcessingException jpe) {
            throw new ResultProcessingException("Could not create JSON due to " + jpe.getLocalizedMessage(), (Exception)((Object)jpe));
        }
    }

    private CloseableHttpResponse executeRequest(String cypher) {
        String url = this.url;
        assert (url != null);
        logger.info("POST {}, request {}", (Object)url, (Object)cypher);
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)new StringEntity(cypher, "UTF-8"));
        return HttpRequest.execute(this.httpClient, (HttpRequestBase)request, this.credentials);
    }

    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase request, Credentials credentials) {
        CloseableHttpResponse response = null;
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json;charset=UTF-8"));
        request.setHeader((Header)new BasicHeader("User-Agent", "neo4j-ogm.java/2.0"));
        request.setHeader((Header)new BasicHeader("Accept", "application/json;charset=UTF-8"));
        HttpAuthorization.authorize(request, credentials);
        RetryOnExceptionStrategy retryStrategy = new RetryOnExceptionStrategy();
        while (retryStrategy.shouldRetry()) {
            try {
                response = httpClient.execute((HttpUriRequest)request);
                StatusLine statusLine = response.getStatusLine();
                HttpEntity responseEntity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    if (responseEntity != null) {
                        String responseText = EntityUtils.toString((HttpEntity)responseEntity);
                        logger.debug("Response Status: {} response: {}", (Object)statusLine.getStatusCode(), (Object)responseText);
                        EntityUtils.consume((HttpEntity)responseEntity);
                    }
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                if (responseEntity == null) {
                    throw new ClientProtocolException("Response contains no content");
                }
                logger.debug("Response is OK");
                return response;
            }
            catch (NoHttpResponseException nhre) {
                try {
                    logger.debug("No response from server.  Retrying in {} milliseconds, retries left: {}", (Object)retryStrategy.getTimeToWait(), (Object)retryStrategy.numberOfTriesLeft);
                    retryStrategy.errorOccured();
                }
                catch (Exception e) {
                    throw new ResultProcessingException("Request retry has failed", e);
                }
            }
            catch (Exception e) {
                request.releaseConnection();
                logger.warn("Caught response exception: {}", (Object)e.getLocalizedMessage());
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException ioe) {
                        throw new ResultProcessingException("Failed to close response: ", e);
                    }
                }
                throw new ResultProcessingException("Failed to execute request", e);
            }
        }
        request.releaseConnection();
        throw new RuntimeException("Fatal Exception: Should not have occurred!");
    }

    static class RetryOnExceptionStrategy {
        public static final int DEFAULT_RETRIES = 3;
        public static final long DEFAULT_WAIT_TIME_IN_MILLI = 2000L;
        private int numberOfRetries;
        private int numberOfTriesLeft;
        private long timeToWait;

        public RetryOnExceptionStrategy() {
            this(3, 2000L);
        }

        public RetryOnExceptionStrategy(int numberOfRetries, long timeToWait) {
            this.numberOfRetries = numberOfRetries;
            this.numberOfTriesLeft = numberOfRetries;
            this.timeToWait = timeToWait;
        }

        public boolean shouldRetry() {
            return this.numberOfTriesLeft > 0;
        }

        public void errorOccured() throws Exception {
            --this.numberOfTriesLeft;
            if (!this.shouldRetry()) {
                throw new Exception("Retry Failed: Total " + this.numberOfRetries + " attempts made at interval " + this.getTimeToWait() + "ms");
            }
            this.waitUntilNextTry();
        }

        public long getTimeToWait() {
            return this.timeToWait;
        }

        private void waitUntilNextTry() {
            try {
                Thread.sleep(this.getTimeToWait());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

