/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.json.ObjectMapperFactory;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.response.model.QueryStatisticsModel;

public abstract class AbstractHttpResponse<T> {
    private final InputStream results;
    private final JsonParser bufferParser;
    private final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private final TokenBuffer buffer;
    private final Class<T> resultClass;
    private String[] columns;
    private QueryStatistics queryStatistics;
    private JsonNode responseNode;

    public AbstractHttpResponse(InputStream inputStream, Class<T> resultClass) {
        this.resultClass = resultClass;
        this.results = inputStream;
        try {
            JsonParser parser = ObjectMapperFactory.jsonFactory().createParser(inputStream);
            this.buffer = new TokenBuffer(parser);
            parser.nextToken();
            this.buffer.copyCurrentStructure(parser);
            this.bufferParser = this.buffer.asParser();
            this.close();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        this.initialise();
    }

    private void initialise() {
        try {
            this.responseNode = (JsonNode)this.mapper.readTree(this.buffer.asParser());
            JsonNode errors = this.responseNode.findValue("errors");
            if (errors.elements().hasNext()) {
                throw new ResultProcessingException(((JsonNode)errors.elements().next()).asText(), null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public T nextDataRecord(String key) {
        try {
            JsonToken token;
            while ((token = this.bufferParser.nextToken()) != null) {
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !key.equals(this.bufferParser.getCurrentName())) continue;
                return (T)this.mapper.readValue(this.bufferParser, this.resultClass);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String[] columns() {
        if (this.columns == null) {
            ArrayList<String> columnsList = new ArrayList<String>();
            List columnsNodes = this.responseNode.findValues("columns");
            if (columnsNodes != null && columnsNodes.size() > 0) {
                JsonNode firstColumnsNode = (JsonNode)columnsNodes.get(0);
                for (JsonNode columnNode : firstColumnsNode) {
                    columnsList.add(columnNode.asText());
                }
                this.columns = new String[columnsList.size()];
                this.columns = columnsList.toArray(this.columns);
            }
        }
        return this.columns;
    }

    public QueryStatistics statistics() {
        if (this.queryStatistics == null) {
            List statsNodes = this.responseNode.findValues("stats");
            try {
                if (statsNodes != null && statsNodes.size() > 0) {
                    this.queryStatistics = (QueryStatistics)this.mapper.treeToValue((TreeNode)statsNodes.get(0), QueryStatisticsModel.class);
                }
            }
            catch (JsonProcessingException jsonException) {
                throw new RuntimeException(jsonException);
            }
        }
        return this.queryStatistics;
    }

    private void close() {
        try {
            this.results.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

