/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.simpleOrm;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.nosql.NoSqlSession;
import org.eclipse.jetty.nosql.NoSqlSessionManager;
import org.eclipse.jetty.server.SessionManager;
import org.neolumin.simpleOrm.SimpleOrmContext;
import org.neolumin.simpleOrm.SimpleOrmSession;
import org.neolumin.simpleOrm.model.JettySession;

public class SimpleOrmJettySessionManager
extends NoSqlSessionManager {
    public static final Class TYPE = SessionManager.class;
    private static final int CACHE_MAX_SIZE = 50;
    private static final int CACHE_EXPIRE_MINUTES = 10;
    private static final String VISIBILITY_STRING = "";
    private final SimpleOrmSession simpleOrmSession;
    private final SimpleOrmContext simpleOrmContext;
    private final LoadingCache<String, Optional<JettySession>> cache;

    public SimpleOrmJettySessionManager(SimpleOrmSession simpleOrmSession) {
        this(simpleOrmSession, simpleOrmSession.createContext(new String[0]));
    }

    public SimpleOrmJettySessionManager(SimpleOrmSession simpleOrmSession, SimpleOrmContext simpleOrmContext) {
        this.simpleOrmSession = simpleOrmSession;
        this.simpleOrmContext = simpleOrmContext;
        this.cache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<JettySession>>(){

            public Optional<JettySession> load(String clusterId) throws Exception {
                return Optional.fromNullable((Object)SimpleOrmJettySessionManager.this.getSimpleOrmSession().findById(JettySession.class, clusterId, SimpleOrmJettySessionManager.this.getSimpleOrmContext()));
            }
        });
    }

    protected NoSqlSession loadSession(String clusterId) {
        Optional row = (Optional)this.cache.getUnchecked((Object)clusterId);
        if (!row.isPresent()) {
            return null;
        }
        JettySession jettySession = (JettySession)row.get();
        NoSqlSession session = new NoSqlSession((NoSqlSessionManager)this, jettySession.getCreated(), jettySession.getAccessed(), jettySession.getClusterId(), (Object)jettySession.getVersion());
        this.setData(session, jettySession.getData());
        session.didActivate();
        return session;
    }

    protected Object save(NoSqlSession session, Object version, boolean activateAfterSave) {
        session.willPassivate();
        if (session.isValid()) {
            JettySession row;
            boolean isNew = false;
            Optional optionalRow = (Optional)this.cache.getUnchecked((Object)session.getClusterId());
            if (!optionalRow.isPresent()) {
                isNew = true;
                row = new JettySession(session.getClusterId(), session.getCreationTime());
                this.cache.put((Object)session.getClusterId(), (Object)Optional.of((Object)row));
                version = 0;
            } else {
                row = (JettySession)optionalRow.get();
                version = ((Number)version).longValue() + 1L;
            }
            row.setVersion(((Number)version).longValue());
            row.setAccessed(session.getAccessed());
            Map<String, Object> data = row.getData();
            Set attributesToSave = session.takeDirty();
            if (isNew || this.isSaveAllAttributes()) {
                attributesToSave.addAll(session.getNames());
            }
            for (String name : attributesToSave) {
                data.put(name, session.getAttribute(name));
            }
            this.simpleOrmSession.save((Object)row, VISIBILITY_STRING, this.getSimpleOrmContext());
        } else {
            this.simpleOrmSession.delete(JettySession.class, session.getClusterId(), this.getSimpleOrmContext());
            this.cache.invalidate((Object)session.getClusterId());
        }
        if (activateAfterSave) {
            session.didActivate();
        }
        return version;
    }

    protected Object refresh(NoSqlSession session, Object version) {
        Long savedVersion;
        Optional optRow = (Optional)this.cache.getUnchecked((Object)session.getClusterId());
        if (version != null && optRow.isPresent() && (savedVersion = ((JettySession)optRow.get()).getVersion()) != null && savedVersion.longValue() == ((Number)version).longValue()) {
            return version;
        }
        if (!optRow.isPresent()) {
            session.invalidate();
            return null;
        }
        JettySession row = (JettySession)optRow.get();
        session.willPassivate();
        session.clearAttributes();
        this.setData(session, row.getData());
        row.setAccessed(System.currentTimeMillis());
        this.simpleOrmSession.save((Object)row, VISIBILITY_STRING, this.getSimpleOrmContext());
        session.didActivate();
        return version;
    }

    protected boolean remove(NoSqlSession session) {
        String id = session.getClusterId();
        Optional optRow = (Optional)this.cache.getUnchecked((Object)id);
        this.simpleOrmSession.delete(JettySession.class, id, this.getSimpleOrmContext());
        this.cache.invalidate((Object)id);
        return optRow.isPresent();
    }

    protected void update(NoSqlSession session, String newClusterId, String newNodeId) throws Exception {
    }

    private void setData(NoSqlSession session, Map<String, Object> data) {
        for (Map.Entry<String, Object> col : data.entrySet()) {
            String name = col.getKey();
            Object value = col.getValue();
            session.doPutOrRemove(name, value);
            session.bindValue(name, value);
        }
    }

    public SimpleOrmSession getSimpleOrmSession() {
        return this.simpleOrmSession;
    }

    public SimpleOrmContext getSimpleOrmContext() {
        return this.simpleOrmContext;
    }
}

