/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo.blueprints;

import java.util.Map;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.blueprints.AccumuloVertexiumBlueprintsGraph;
import org.neolumin.vertexium.blueprints.AuthorizationsProvider;
import org.neolumin.vertexium.blueprints.DefaultVisibilityProvider;
import org.neolumin.vertexium.blueprints.VertexiumBlueprintsFactory;
import org.neolumin.vertexium.blueprints.VertexiumBlueprintsGraph;
import org.neolumin.vertexium.blueprints.VisibilityProvider;
import org.neolumin.vertexium.util.ConfigurationUtils;
import org.neolumin.vertexium.util.MapUtils;

public class AccumuloVertexiumBlueprintsGraphFactory
extends VertexiumBlueprintsFactory {
    public VertexiumBlueprintsGraph createGraph(Map config) {
        AccumuloGraph graph = this.createAccumuloGraph(config);
        VisibilityProvider visibilityProvider = this.createVisibilityProvider((GraphConfiguration)graph.getConfiguration());
        AuthorizationsProvider authorizationProvider = this.createAuthorizationsProvider((GraphConfiguration)graph.getConfiguration());
        return new AccumuloVertexiumBlueprintsGraph(graph, visibilityProvider, authorizationProvider);
    }

    private AccumuloGraph createAccumuloGraph(Map config) {
        try {
            Map graphConfig = MapUtils.getAllWithPrefix((Map)config, (String)"graph");
            return AccumuloGraph.create((Map)graphConfig);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not create accumulo graph", ex);
        }
    }

    private VisibilityProvider createVisibilityProvider(GraphConfiguration config) {
        try {
            return (VisibilityProvider)ConfigurationUtils.createProvider((GraphConfiguration)config, (String)"visibilityProvider", (String)DefaultVisibilityProvider.class.getName());
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not create visibility provider", ex);
        }
    }

    private AuthorizationsProvider createAuthorizationsProvider(GraphConfiguration config) {
        try {
            return (AuthorizationsProvider)ConfigurationUtils.createProvider((GraphConfiguration)config, (String)"authorizationsProvider", null);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not create authorization provider", ex);
        }
    }
}

