/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo.iterator;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.RowFilter;
import org.apache.hadoop.io.Text;

public class ElementVisibilityRowFilter
extends RowFilter {
    public static final String OPT_FILTER_VERTICES = "vertex.enabled";
    public static final String OPT_FILTER_EDGES = "edge.enabled";
    private static final Text VERTEX_CF_SIGNAL = new Text("V");
    private static final Text EDGE_CF_SIGNAL = new Text("E");
    boolean filterVertices;
    boolean filterEdges;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.filterVertices = options.get(OPT_FILTER_VERTICES) != null;
        boolean bl = this.filterEdges = options.get(OPT_FILTER_EDGES) != null;
        if (!this.filterVertices && !this.filterEdges) {
            throw new IllegalArgumentException("vertex.enabled and/or edge.enabled must be set to a non-null value.");
        }
        super.init(source, options, env);
    }

    public boolean acceptRow(SortedKeyValueIterator<Key, Value> rowIterator) throws IOException {
        while (rowIterator.hasTop()) {
            Key key = (Key)rowIterator.getTopKey();
            if (this.isVisible(key)) {
                return true;
            }
            rowIterator.next();
        }
        return false;
    }

    private boolean isVisible(Key key) {
        return this.filterVertices && key.compareColumnFamily(VERTEX_CF_SIGNAL) == 0 || this.filterEdges && key.compareColumnFamily(EDGE_CF_SIGNAL) == 0;
    }
}

