/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo.migrations;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.neolumin.vertexium.accumulo.migrations.MRMigrationBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M001MetadataToRows
extends MRMigrationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(M001MetadataToRows.class);

    public static void main(String[] args) throws Exception {
        M001MetadataToRows.run(new M001MetadataToRows(), args);
    }

    @Override
    protected Class<? extends Mapper> getMigrationMapperClass() {
        return MigrationMapper.class;
    }

    public static class MigrationMapper
    extends MRMigrationBase.MRMigrationMapperBase<Key, Value> {
        @Override
        protected void safeMap(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
            context.setStatus(key.getRow().toString());
            if (!key.getColumnFamily().toString().equals("PROPMETA")) {
                return;
            }
            if (value.getSize() == 0) {
                return;
            }
            Object propMetadataMapObj = this.getValueSerializer().valueToObject(value);
            if (!(propMetadataMapObj instanceof Map)) {
                return;
            }
            Mutation m = new Mutation(key.getRow());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("mutation: " + key.getRow());
            }
            Map propMetadataMap = (Map)propMetadataMapObj;
            for (Map.Entry mapEntry : propMetadataMap.entrySet()) {
                Text newColumnQualifier = new Text(key.getColumnQualifier().toString() + "\u001f" + (String)mapEntry.getKey());
                Value newValue = this.getValueSerializer().objectToValue(mapEntry.getValue());
                m.put(key.getColumnFamily(), newColumnQualifier, key.getColumnVisibilityParsed(), key.getTimestamp(), newValue);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("  put: " + key.getColumnFamily() + ", " + newColumnQualifier + ", " + key.getColumnVisibilityParsed() + ", " + key.getTimestamp() + ", " + newValue);
            }
            m.putDelete(key.getColumnFamily(), key.getColumnQualifier(), key.getColumnVisibilityParsed(), key.getTimestamp());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  put delete: " + key.getColumnFamily() + ", " + key.getColumnQualifier() + ", " + key.getColumnVisibilityParsed() + ", " + key.getTimestamp());
            }
            context.write((Object)this.getOutputTableNameText(), (Object)m);
        }

        private int count(String columnQualifier, String valueSeparator) {
            int fromIndex = 0;
            int count = 0;
            while ((fromIndex = columnQualifier.indexOf(valueSeparator, fromIndex)) >= 0) {
                ++fromIndex;
                ++count;
            }
            return count;
        }
    }
}

