/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo.migrations;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.mapreduce.AccumuloRowInputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.migrations.M001MetadataToRows;
import org.neolumin.vertexium.accumulo.migrations.MRMigrationBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M002AddPropertyVisibilityToMetadata
extends MRMigrationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(M001MetadataToRows.class);

    public static void main(String[] args) throws Exception {
        M002AddPropertyVisibilityToMetadata.run(new M002AddPropertyVisibilityToMetadata(), args);
    }

    @Override
    protected Class<? extends Mapper> getMigrationMapperClass() {
        return MigrationMapper.class;
    }

    @Override
    protected Class getInputFormatClass() {
        return AccumuloRowInputFormat.class;
    }

    public static class MigrationMapper
    extends MRMigrationBase.MRMigrationMapperBase<Text, PeekingIterator<Map.Entry<Key, Value>>> {
        @Override
        protected void safeMap(Text row, PeekingIterator<Map.Entry<Key, Value>> value, Mapper.Context context) throws IOException, InterruptedException {
            context.setStatus(row.toString());
            String propertyVisibility = null;
            while (value.hasNext()) {
                Map.Entry column = (Map.Entry)value.next();
                if (((Key)column.getKey()).getColumnFamily().toString().equals("PROP")) {
                    propertyVisibility = AccumuloGraph.accumuloVisibilityToVisibility((ColumnVisibility)((Key)column.getKey()).getColumnVisibilityParsed()).getVisibilityString();
                    continue;
                }
                if (!((Key)column.getKey()).getColumnFamily().toString().equals("PROPMETA")) continue;
                this.updateMetadata((Key)column.getKey(), (Value)column.getValue(), propertyVisibility, context);
            }
        }

        private void updateMetadata(Key key, Value value, String propertyVisibility, Mapper.Context context) throws IOException, InterruptedException {
            String columnQualifier = key.getColumnQualifier().toString();
            if (this.count(columnQualifier, "\u001f") != 2) {
                return;
            }
            Mutation m = new Mutation(key.getRow());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("mutation: " + key.getRow());
            }
            int lastValueSeparator = columnQualifier.lastIndexOf("\u001f");
            String newColumnQualifier = columnQualifier.substring(0, lastValueSeparator) + "\u001f" + propertyVisibility + columnQualifier.substring(lastValueSeparator);
            m.put(key.getColumnFamily(), new Text(newColumnQualifier), key.getColumnVisibilityParsed(), key.getTimestamp(), value);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  put: " + key.getColumnFamily() + ", " + newColumnQualifier + ", " + key.getColumnVisibilityParsed() + ", " + key.getTimestamp() + ", " + value);
            }
            m.putDelete(key.getColumnFamily(), key.getColumnQualifier(), key.getColumnVisibilityParsed(), key.getTimestamp());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  put delete: " + key.getColumnFamily() + ", " + key.getColumnQualifier() + ", " + key.getColumnVisibilityParsed() + ", " + key.getTimestamp());
            }
            context.write((Object)this.getOutputTableNameText(), (Object)m);
        }

        private int count(String columnQualifier, String valueSeparator) {
            int fromIndex = 0;
            int count = 0;
            while ((fromIndex = columnQualifier.indexOf(valueSeparator, fromIndex)) >= 0) {
                ++fromIndex;
                ++count;
            }
            return count;
        }
    }
}

