/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.util.ArrayUtils;
import org.neolumin.vertexium.util.Preconditions;

public class AccumuloAuthorizations
implements Authorizations,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] authorizations;

    public AccumuloAuthorizations(String ... authorizations) {
        this.authorizations = authorizations;
    }

    public String[] getAuthorizations() {
        return this.authorizations;
    }

    public boolean equals(Authorizations authorizations) {
        return ArrayUtils.intersectsAll((Object[])this.getAuthorizations(), (Object[])authorizations.getAuthorizations());
    }

    public String toString() {
        return Arrays.toString(this.authorizations);
    }

    public boolean canRead(Visibility visibility) {
        Preconditions.checkNotNull((Object)visibility, (Object)"visibility is required");
        if (visibility.getVisibilityString().length() == 0) {
            return true;
        }
        VisibilityEvaluator visibilityEvaluator = new VisibilityEvaluator(new org.apache.accumulo.core.security.Authorizations(this.getAuthorizations()));
        ColumnVisibility columnVisibility = new ColumnVisibility(visibility.getVisibilityString());
        try {
            return visibilityEvaluator.evaluate(columnVisibility);
        }
        catch (VisibilityParseException e) {
            throw new VertexiumException("could not evaluate visibility " + visibility.getVisibilityString(), (Exception)((Object)e));
        }
    }
}

