/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.util.EnumSet;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloElement;
import org.neolumin.vertexium.mutation.ExistingEdgeMutation;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;

public class AccumuloEdge
extends AccumuloElement
implements Edge {
    public static final Text CF_SIGNAL = new Text("E");
    public static final Text CF_OUT_VERTEX = new Text("EOUT");
    public static final Text CF_IN_VERTEX = new Text("EIN");
    private final String outVertexId;
    private final String inVertexId;
    private final String label;
    private final String newEdgeLabel;

    public AccumuloEdge(Graph graph, String id, String outVertexId, String inVertexId, String label, String newEdgeLabel, Visibility visibility, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations, Iterable<Visibility> hiddenVisibilities, Authorizations authorizations, long timestamp) {
        super(graph, id, visibility, properties, propertyRemoveMutations, hiddenVisibilities, authorizations, timestamp);
        this.outVertexId = outVertexId;
        this.inVertexId = inVertexId;
        this.label = label;
        this.newEdgeLabel = newEdgeLabel;
    }

    String getNewEdgeLabel() {
        return this.newEdgeLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public String getVertexId(Direction direction) {
        switch (direction) {
            case OUT: {
                return this.outVertexId;
            }
            case IN: {
                return this.inVertexId;
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + direction);
    }

    public Vertex getVertex(Direction direction, Authorizations authorizations) {
        return this.getVertex(direction, FetchHint.ALL, authorizations);
    }

    public String getOtherVertexId(String myVertexId) {
        if (this.inVertexId.equals(myVertexId)) {
            return this.outVertexId;
        }
        if (this.outVertexId.equals(myVertexId)) {
            return this.inVertexId;
        }
        throw new VertexiumException("myVertexId does not appear on either the in or the out.");
    }

    public Vertex getOtherVertex(String myVertexId, Authorizations authorizations) {
        return this.getOtherVertex(myVertexId, FetchHint.ALL, authorizations);
    }

    public Vertex getOtherVertex(String myVertexId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getOtherVertexId(myVertexId), fetchHints, authorizations);
    }

    public Vertex getVertex(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertex(this.getVertexId(direction), fetchHints, authorizations);
    }

    public ExistingEdgeMutation prepareMutation() {
        return new ExistingEdgeMutation(this){

            public Edge save(Authorizations authorizations) {
                AccumuloEdge.this.saveExistingElementMutation(this, authorizations);
                return (Edge)this.getElement();
            }
        };
    }
}

