/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.io.Serializable;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.ElementBase;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.HasTimestamp;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloEdge;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.mutation.EdgeMutation;
import org.neolumin.vertexium.mutation.ExistingElementMutationImpl;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;

public abstract class AccumuloElement
extends ElementBase
implements Serializable,
HasTimestamp {
    private static final long serialVersionUID = 1L;
    public static final Text CF_HIDDEN = new Text("H");
    public static final Text CQ_HIDDEN = new Text("H");
    public static final Value HIDDEN_VALUE = new Value("".getBytes());
    public static final Text CF_PROPERTY = new Text("PROP");
    public static final Text CF_PROPERTY_HIDDEN = new Text("PROPH");
    public static final Text CF_PROPERTY_METADATA = new Text("PROPMETA");
    private final long timestamp;

    protected AccumuloElement(Graph graph, String id, Visibility visibility, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations, Iterable<Visibility> hiddenVisibilities, Authorizations authorizations, long timestamp) {
        super(graph, id, visibility, properties, propertyRemoveMutations, hiddenVisibilities, authorizations);
        this.timestamp = timestamp;
    }

    public void removeProperty(String key, String name, Authorizations authorizations) {
        Property property = super.removePropertyInternal(key, name);
        if (property != null) {
            this.getGraph().removeProperty(this, property, authorizations);
        }
    }

    public void removeProperty(String name, Authorizations authorizations) {
        Iterable properties = super.removePropertyInternal(name);
        for (Property property : properties) {
            this.getGraph().removeProperty(this, property, authorizations);
        }
    }

    public void markPropertyHidden(Property property, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyHidden(this, property, visibility, authorizations);
    }

    public void markPropertyVisible(Property property, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, property, visibility, authorizations);
    }

    public AccumuloGraph getGraph() {
        return (AccumuloGraph)super.getGraph();
    }

    protected <TElement extends Element> void saveExistingElementMutation(ExistingElementMutationImpl<TElement> mutation, Authorizations authorizations) {
        EdgeMutation edgeMutation;
        String newEdgeLabel;
        this.getGraph().alterPropertyMetadatas((AccumuloElement)mutation.getElement(), mutation.getSetPropertyMetadatas());
        this.getGraph().alterElementPropertyVisibilities((AccumuloElement)mutation.getElement(), mutation.getAlterPropertyVisibilities());
        Iterable propertyRemoves = mutation.getPropertyRemoves();
        Iterable properties = mutation.getProperties();
        this.updatePropertiesInternal(properties, propertyRemoves);
        this.getGraph().saveProperties((AccumuloElement)mutation.getElement(), properties, propertyRemoves, mutation.getIndexHint(), authorizations);
        if (mutation.getNewElementVisibility() != null) {
            this.getGraph().alterElementVisibility((AccumuloElement)mutation.getElement(), mutation.getNewElementVisibility());
        }
        if (mutation instanceof EdgeMutation && (newEdgeLabel = (edgeMutation = (EdgeMutation)mutation).getNewEdgeLabel()) != null) {
            this.getGraph().alterEdgeLabel((AccumuloEdge)mutation.getElement(), newEdgeLabel);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

