/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.EdgeBuilder;
import org.neolumin.vertexium.EdgeBuilderBase;
import org.neolumin.vertexium.EdgeBuilderByVertexId;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.ElementType;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphBaseWithSearchIndex;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.GraphMetadataEntry;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexBuilder;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloAuthorizations;
import org.neolumin.vertexium.accumulo.AccumuloEdge;
import org.neolumin.vertexium.accumulo.AccumuloElement;
import org.neolumin.vertexium.accumulo.AccumuloGraphConfiguration;
import org.neolumin.vertexium.accumulo.AccumuloVertex;
import org.neolumin.vertexium.accumulo.EdgeInfo;
import org.neolumin.vertexium.accumulo.EdgeMaker;
import org.neolumin.vertexium.accumulo.ElementMutationBuilder;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueRef;
import org.neolumin.vertexium.accumulo.VertexMaker;
import org.neolumin.vertexium.accumulo.iterator.ElementVisibilityRowFilter;
import org.neolumin.vertexium.accumulo.serializer.ValueSerializer;
import org.neolumin.vertexium.event.AddEdgeEvent;
import org.neolumin.vertexium.event.AddPropertyEvent;
import org.neolumin.vertexium.event.AddVertexEvent;
import org.neolumin.vertexium.event.GraphEvent;
import org.neolumin.vertexium.event.MarkHiddenEdgeEvent;
import org.neolumin.vertexium.event.MarkHiddenPropertyEvent;
import org.neolumin.vertexium.event.MarkHiddenVertexEvent;
import org.neolumin.vertexium.event.MarkVisibleEdgeEvent;
import org.neolumin.vertexium.event.MarkVisiblePropertyEvent;
import org.neolumin.vertexium.event.MarkVisibleVertexEvent;
import org.neolumin.vertexium.event.RemoveEdgeEvent;
import org.neolumin.vertexium.event.RemovePropertyEvent;
import org.neolumin.vertexium.event.RemoveVertexEvent;
import org.neolumin.vertexium.id.IdGenerator;
import org.neolumin.vertexium.id.NameSubstitutionStrategy;
import org.neolumin.vertexium.mutation.AlterPropertyVisibility;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;
import org.neolumin.vertexium.mutation.SetPropertyMetadata;
import org.neolumin.vertexium.property.MutableProperty;
import org.neolumin.vertexium.property.StreamingPropertyValue;
import org.neolumin.vertexium.search.IndexHint;
import org.neolumin.vertexium.search.SearchIndex;
import org.neolumin.vertexium.util.CloseableIterable;
import org.neolumin.vertexium.util.EmptyClosableIterable;
import org.neolumin.vertexium.util.IterableUtils;
import org.neolumin.vertexium.util.JavaSerializableUtils;
import org.neolumin.vertexium.util.LookAheadIterable;
import org.neolumin.vertexium.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloGraph
extends GraphBaseWithSearchIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccumuloGraph.class);
    private static final String ROW_DELETING_ITERATOR_NAME = RowDeletingIterator.class.getSimpleName();
    private static final int ROW_DELETING_ITERATOR_PRIORITY = 7;
    public static final Text DELETE_ROW_COLUMN_FAMILY = new Text("");
    public static final Text DELETE_ROW_COLUMN_QUALIFIER = new Text("");
    public static final Text METADATA_COLUMN_FAMILY = new Text("");
    public static final Text METADATA_COLUMN_QUALIFIER = new Text("");
    public static final String VERTEX_AFTER_ROW_KEY_PREFIX = "W";
    public static final String EDGE_AFTER_ROW_KEY_PREFIX = "F";
    private static final Object addIteratorLock = new Object();
    private static final Integer METADATA_ACCUMULO_GRAPH_VERSION = 2;
    private static final String METADATA_ACCUMULO_GRAPH_VERSION_KEY = "accumulo.graph.version";
    private static final String METADATA_VALUE_SERIALIZER = "accumulo.graph.valueSerializer";
    private static final Authorizations METADATA_AUTHORIZATIONS = new AccumuloAuthorizations(new String[0]);
    private final Connector connector;
    private final ValueSerializer valueSerializer;
    private final FileSystem fileSystem;
    private final String dataDir;
    private BatchWriter verticesWriter;
    private BatchWriter edgesWriter;
    private BatchWriter dataWriter;
    private BatchWriter metadataWriter;
    protected ElementMutationBuilder elementMutationBuilder;
    private final Queue<GraphEvent> graphEventQueue = new LinkedList<GraphEvent>();
    private Integer accumuloGraphVersion;
    private boolean foundValueSerializerMetadata;
    private final NameSubstitutionStrategy nameSubstitutionStrategy;

    protected AccumuloGraph(AccumuloGraphConfiguration config, IdGenerator idGenerator, SearchIndex searchIndex, Connector connector, FileSystem fileSystem, ValueSerializer valueSerializer, NameSubstitutionStrategy nameSubstitutionStrategy) {
        super((GraphConfiguration)config, idGenerator, searchIndex);
        this.connector = connector;
        this.valueSerializer = valueSerializer;
        this.fileSystem = fileSystem;
        this.dataDir = config.getDataDir();
        this.nameSubstitutionStrategy = nameSubstitutionStrategy;
        long maxStreamingPropertyValueTableDataSize = config.getMaxStreamingPropertyValueTableDataSize();
        this.elementMutationBuilder = new ElementMutationBuilder(fileSystem, valueSerializer, maxStreamingPropertyValueTableDataSize, this.dataDir){

            @Override
            protected Text getPropertyColumnQualifier(Property p) {
                return 1.getValueSeparatedJoined(AccumuloGraph.this.nameSubstitutionStrategy.deflate(p.getName()), AccumuloGraph.this.nameSubstitutionStrategy.deflate(p.getKey()));
            }

            @Override
            protected void saveVertexMutation(Mutation m) {
                AccumuloGraph.this.addMutations(AccumuloGraph.this.getVerticesWriter(), m);
            }

            @Override
            protected void saveEdgeMutation(Mutation m) {
                AccumuloGraph.this.addMutations(AccumuloGraph.this.getEdgesWriter(), m);
            }

            @Override
            protected void saveDataMutation(Mutation dataMutation) {
                AccumuloGraph.this.addMutations(AccumuloGraph.this.getDataWriter(), dataMutation);
            }

            @Override
            protected StreamingPropertyValueRef saveStreamingPropertyValue(String rowKey, Property property, StreamingPropertyValue propertyValue) {
                StreamingPropertyValueRef streamingPropertyValueRef = super.saveStreamingPropertyValue(rowKey, property, propertyValue);
                ((MutableProperty)property).setValue((Object)streamingPropertyValueRef.toStreamingPropertyValue(AccumuloGraph.this));
                return streamingPropertyValueRef;
            }
        };
    }

    public static AccumuloGraph create(AccumuloGraphConfiguration config) throws AccumuloSecurityException, AccumuloException, VertexiumException, InterruptedException, IOException, URISyntaxException {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        Connector connector = config.createConnector();
        FileSystem fs = config.createFileSystem();
        ValueSerializer valueSerializer = config.createValueSerializer();
        SearchIndex searchIndex = config.createSearchIndex();
        IdGenerator idGenerator = config.createIdGenerator();
        NameSubstitutionStrategy nameSubstitutionStrategy = config.createSubstitutionStrategy();
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getVerticesTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getEdgesTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getDataTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getMetadataTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getVerticesTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getEdgesTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getDataTableName(config.getTableNamePrefix()));
        AccumuloGraph graph = new AccumuloGraph(config, idGenerator, searchIndex, connector, fs, valueSerializer, nameSubstitutionStrategy);
        graph.setup();
        return graph;
    }

    protected void setup() {
        super.setup();
        if (this.accumuloGraphVersion == null) {
            this.setMetadata(METADATA_ACCUMULO_GRAPH_VERSION_KEY, METADATA_ACCUMULO_GRAPH_VERSION);
        } else if (!METADATA_ACCUMULO_GRAPH_VERSION.equals(this.accumuloGraphVersion)) {
            throw new VertexiumException("Invalid accumulo graph version. Expected " + METADATA_ACCUMULO_GRAPH_VERSION + " found " + this.accumuloGraphVersion);
        }
    }

    protected void setupGraphMetadata() {
        this.foundValueSerializerMetadata = false;
        super.setupGraphMetadata();
        if (!this.foundValueSerializerMetadata) {
            this.setMetadata(METADATA_VALUE_SERIALIZER, this.valueSerializer.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupGraphMetadata(GraphMetadataEntry graphMetadataEntry) {
        super.setupGraphMetadata(graphMetadataEntry);
        if (graphMetadataEntry.getKey().equals(METADATA_ACCUMULO_GRAPH_VERSION_KEY)) {
            if (!(graphMetadataEntry.getValue() instanceof Integer)) throw new VertexiumException("Invalid accumulo version in metadata. " + graphMetadataEntry);
            this.accumuloGraphVersion = (Integer)graphMetadataEntry.getValue();
            LOGGER.info("accumulo.graph.version=" + this.accumuloGraphVersion);
            return;
        } else {
            if (!graphMetadataEntry.getKey().equals(METADATA_VALUE_SERIALIZER)) return;
            if (!(graphMetadataEntry.getValue() instanceof String)) throw new VertexiumException("Invalid accumulo.graph.valueSerializer expected string found " + graphMetadataEntry.getValue().getClass().getName());
            String valueSerializerClassName = (String)graphMetadataEntry.getValue();
            if (!valueSerializerClassName.equals(this.valueSerializer.getClass().getName())) {
                throw new VertexiumException("Invalid accumulo.graph.valueSerializer expected " + valueSerializerClassName + " found " + this.valueSerializer.getClass().getName());
            }
            this.foundValueSerializerMetadata = true;
        }
    }

    protected static void ensureTableExists(Connector connector, String tableName) {
        try {
            if (!connector.tableOperations().exists(tableName)) {
                connector.tableOperations().create(tableName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create table " + tableName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void ensureRowDeletingIteratorIsAttached(Connector connector, String tableName) {
        try {
            Object object = addIteratorLock;
            synchronized (object) {
                block8: {
                    IteratorSetting is = new IteratorSetting(7, ROW_DELETING_ITERATOR_NAME, RowDeletingIterator.class);
                    if (!connector.tableOperations().listIterators(tableName).containsKey(ROW_DELETING_ITERATOR_NAME)) {
                        try {
                            connector.tableOperations().attachIterator(tableName, is);
                        }
                        catch (Exception ex) {
                            int SLEEP_TIME = 5000;
                            LOGGER.warn("Failed to attach RowDeletingIterator. Retrying in 5000ms.");
                            Thread.sleep(5000L);
                            if (connector.tableOperations().listIterators(tableName).containsKey(ROW_DELETING_ITERATOR_NAME)) break block8;
                            connector.tableOperations().attachIterator(tableName, is);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new VertexiumException("Could not attach RowDeletingIterator", e);
        }
    }

    public static AccumuloGraph create(Map config) throws AccumuloSecurityException, AccumuloException, VertexiumException, InterruptedException, IOException, URISyntaxException {
        return AccumuloGraph.create(new AccumuloGraphConfiguration(config));
    }

    public Vertex addVertex(String vertexId, Visibility vertexVisibility, Authorizations authorizations) {
        return this.prepareVertex(vertexId, vertexVisibility).save(authorizations);
    }

    public VertexBuilder prepareVertex(String vertexId, Visibility visibility) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        return new VertexBuilder(vertexId, visibility){

            public Vertex save(Authorizations authorizations) {
                AccumuloVertex vertex = new AccumuloVertex(AccumuloGraph.this, this.getVertexId(), this.getVisibility(), (Iterable<Property>)this.getProperties(), (Iterable<PropertyRemoveMutation>)this.getPropertyRemoves(), null, authorizations, System.currentTimeMillis());
                AccumuloGraph.this.elementMutationBuilder.saveVertex(vertex);
                if (this.getIndexHint() != IndexHint.DO_NOT_INDEX) {
                    AccumuloGraph.this.getSearchIndex().addElement((Graph)AccumuloGraph.this, (Element)vertex, authorizations);
                }
                if (AccumuloGraph.this.hasEventListeners()) {
                    AccumuloGraph.this.queueEvent((GraphEvent)new AddVertexEvent((Graph)AccumuloGraph.this, (Vertex)vertex));
                    for (Property property : this.getProperties()) {
                        AccumuloGraph.this.queueEvent((GraphEvent)new AddPropertyEvent((Graph)AccumuloGraph.this, (Element)vertex, property));
                    }
                    for (PropertyRemoveMutation propertyRemoveMutation : this.getPropertyRemoves()) {
                        AccumuloGraph.this.queueEvent((GraphEvent)new RemovePropertyEvent((Graph)AccumuloGraph.this, (Element)vertex, propertyRemoveMutation));
                    }
                }
                return vertex;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEvent(GraphEvent graphEvent) {
        Queue<GraphEvent> queue = this.graphEventQueue;
        synchronized (queue) {
            this.graphEventQueue.add(graphEvent);
        }
    }

    void saveProperties(AccumuloElement element, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoves, IndexHint indexHint, Authorizations authorizations) {
        String rowPrefix = this.getRowPrefixForElement(element);
        String elementRowKey = rowPrefix + element.getId();
        Mutation m = new Mutation((CharSequence)elementRowKey);
        boolean hasProperty = false;
        for (PropertyRemoveMutation propertyRemove : propertyRemoves) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertyRemoveToMutation(m, propertyRemove);
        }
        for (Property property : properties) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertyToMutation(m, elementRowKey, property);
        }
        if (hasProperty) {
            this.addMutations(this.getWriterFromElementType((Element)element), m);
        }
        if (indexHint != IndexHint.DO_NOT_INDEX) {
            for (PropertyRemoveMutation propertyRemoveMutation : propertyRemoves) {
                this.getSearchIndex().removeProperty((Graph)this, (Element)element, propertyRemoveMutation.getKey(), propertyRemoveMutation.getName(), propertyRemoveMutation.getVisibility(), authorizations);
            }
            this.getSearchIndex().addElement((Graph)this, (Element)element, authorizations);
        }
        if (this.hasEventListeners()) {
            for (Property property : properties) {
                this.queueEvent((GraphEvent)new AddPropertyEvent((Graph)this, (Element)element, property));
            }
            for (PropertyRemoveMutation propertyRemoveMutation : propertyRemoves) {
                this.queueEvent((GraphEvent)new RemovePropertyEvent((Graph)this, (Element)element, propertyRemoveMutation));
            }
        }
    }

    void removeProperty(AccumuloElement element, Property property, Authorizations authorizations) {
        String rowPrefix = this.getRowPrefixForElement(element);
        Mutation m = new Mutation((CharSequence)(rowPrefix + element.getId()));
        this.elementMutationBuilder.addPropertyRemoveToMutation(m, property);
        this.addMutations(this.getWriterFromElementType((Element)element), m);
        this.getSearchIndex().removeProperty((Graph)this, (Element)element, property, authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new RemovePropertyEvent((Graph)this, (Element)element, property));
        }
    }

    private String getRowPrefixForElement(AccumuloElement element) {
        if (element instanceof Vertex) {
            return "V";
        }
        if (element instanceof Edge) {
            return "E";
        }
        throw new VertexiumException("Unexpected element type: " + element.getClass().getName());
    }

    protected void addMutations(BatchWriter writer, Mutation ... mutations) {
        try {
            for (Mutation mutation : mutations) {
                writer.addMutation(mutation);
            }
            if (this.getConfiguration().isAutoFlush()) {
                this.flush();
            }
        }
        catch (MutationsRejectedException ex) {
            throw new RuntimeException("Could not add mutation", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchWriter getVerticesWriter() {
        try {
            if (this.verticesWriter != null) {
                return this.verticesWriter;
            }
            AccumuloGraph accumuloGraph = this;
            synchronized (accumuloGraph) {
                if (this.verticesWriter != null) {
                    return this.verticesWriter;
                }
                BatchWriterConfig writerConfig = this.getConfiguration().createBatchWriterConfig();
                this.verticesWriter = this.connector.createBatchWriter(this.getVerticesTableName(), writerConfig);
                return this.verticesWriter;
            }
        }
        catch (TableNotFoundException ex) {
            throw new RuntimeException("Could not create batch writer", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchWriter getEdgesWriter() {
        try {
            if (this.edgesWriter != null) {
                return this.edgesWriter;
            }
            AccumuloGraph accumuloGraph = this;
            synchronized (accumuloGraph) {
                if (this.edgesWriter != null) {
                    return this.edgesWriter;
                }
                BatchWriterConfig writerConfig = this.getConfiguration().createBatchWriterConfig();
                this.edgesWriter = this.connector.createBatchWriter(this.getEdgesTableName(), writerConfig);
                return this.edgesWriter;
            }
        }
        catch (TableNotFoundException ex) {
            throw new RuntimeException("Could not create batch writer", ex);
        }
    }

    protected BatchWriter getWriterFromElementType(Element element) {
        if (element instanceof Vertex) {
            return this.getVerticesWriter();
        }
        if (element instanceof Edge) {
            return this.getEdgesWriter();
        }
        throw new VertexiumException("Unexpected element type: " + element.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchWriter getDataWriter() {
        try {
            if (this.dataWriter != null) {
                return this.dataWriter;
            }
            AccumuloGraph accumuloGraph = this;
            synchronized (accumuloGraph) {
                if (this.dataWriter != null) {
                    return this.dataWriter;
                }
                BatchWriterConfig writerConfig = this.getConfiguration().createBatchWriterConfig();
                this.dataWriter = this.connector.createBatchWriter(this.getDataTableName(), writerConfig);
                return this.dataWriter;
            }
        }
        catch (TableNotFoundException ex) {
            throw new RuntimeException("Could not create batch writer", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchWriter getMetadataWriter() {
        try {
            if (this.metadataWriter != null) {
                return this.metadataWriter;
            }
            AccumuloGraph accumuloGraph = this;
            synchronized (accumuloGraph) {
                if (this.metadataWriter != null) {
                    return this.metadataWriter;
                }
                BatchWriterConfig writerConfig = this.getConfiguration().createBatchWriterConfig();
                this.metadataWriter = this.connector.createBatchWriter(this.getMetadataTableName(), writerConfig);
                return this.metadataWriter;
            }
        }
        catch (TableNotFoundException ex) {
            throw new RuntimeException("Could not create batch writer", ex);
        }
    }

    public Iterable<Vertex> getVertices(EnumSet<FetchHint> fetchHints, Authorizations authorizations) throws VertexiumException {
        return this.getVerticesInRange(null, null, fetchHints, authorizations);
    }

    public void removeVertex(Vertex vertex, Authorizations authorizations) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex cannot be null");
        }
        this.getSearchIndex().removeElement((Graph)this, (Element)vertex, authorizations);
        for (Edge edge : vertex.getEdges(Direction.BOTH, authorizations)) {
            this.removeEdge(edge, authorizations);
        }
        this.addMutations(this.getVerticesWriter(), this.getDeleteRowMutation("V" + vertex.getId()));
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new RemoveVertexEvent((Graph)this, vertex));
        }
    }

    public void markVertexHidden(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex cannot be null");
        ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
        for (Edge edge : vertex.getEdges(Direction.BOTH, authorizations)) {
            this.markEdgeHidden(edge, visibility, authorizations);
        }
        this.addMutations(this.getVerticesWriter(), this.getMarkHiddenRowMutation("V" + vertex.getId(), columnVisibility));
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new MarkHiddenVertexEvent((Graph)this, vertex));
        }
    }

    public void markVertexVisible(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex cannot be null");
        ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
        for (Edge edge : vertex.getEdges(Direction.BOTH, FetchHint.ALL_INCLUDING_HIDDEN, authorizations)) {
            this.markEdgeVisible(edge, visibility, authorizations);
        }
        this.addMutations(this.getVerticesWriter(), this.getMarkVisibleRowMutation("V" + vertex.getId(), columnVisibility));
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new MarkVisibleVertexEvent((Graph)this, vertex));
        }
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilderByVertexId(edgeId, outVertexId, inVertexId, label, visibility){

            public Edge save(Authorizations authorizations) {
                return AccumuloGraph.this.savePreparedEdge((EdgeBuilderBase)this, this.getOutVertexId(), this.getInVertexId(), null, authorizations);
            }
        };
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        if (outVertex == null) {
            throw new IllegalArgumentException("outVertex is required");
        }
        if (inVertex == null) {
            throw new IllegalArgumentException("inVertex is required");
        }
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilder(edgeId, outVertex, inVertex, label, visibility){

            public Edge save(Authorizations authorizations) {
                AddEdgeToVertexRunnable addEdgeToVertex = new AddEdgeToVertexRunnable(){

                    @Override
                    public void run(AccumuloEdge edge) {
                        if (this.getOutVertex() instanceof AccumuloVertex) {
                            ((AccumuloVertex)this.getOutVertex()).addOutEdge(edge);
                        }
                        if (this.getInVertex() instanceof AccumuloVertex) {
                            ((AccumuloVertex)this.getInVertex()).addInEdge(edge);
                        }
                    }
                };
                return AccumuloGraph.this.savePreparedEdge((EdgeBuilderBase)this, this.getOutVertex().getId(), this.getInVertex().getId(), addEdgeToVertex, authorizations);
            }
        };
    }

    private Edge savePreparedEdge(EdgeBuilderBase edgeBuilder, String outVertexId, String inVertexId, AddEdgeToVertexRunnable addEdgeToVertex, Authorizations authorizations) {
        AccumuloEdge edge = new AccumuloEdge((Graph)this, edgeBuilder.getEdgeId(), outVertexId, inVertexId, edgeBuilder.getLabel(), edgeBuilder.getNewEdgeLabel(), edgeBuilder.getVisibility(), edgeBuilder.getProperties(), edgeBuilder.getPropertyRemoves(), null, authorizations, System.currentTimeMillis());
        this.elementMutationBuilder.saveEdge(edge);
        if (addEdgeToVertex != null) {
            addEdgeToVertex.run(edge);
        }
        if (edgeBuilder.getIndexHint() != IndexHint.DO_NOT_INDEX) {
            this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        }
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new AddEdgeEvent((Graph)this, (Edge)edge));
            for (Property property : edgeBuilder.getProperties()) {
                this.queueEvent((GraphEvent)new AddPropertyEvent((Graph)this, (Element)edge, property));
            }
            for (PropertyRemoveMutation propertyRemoveMutation : edgeBuilder.getPropertyRemoves()) {
                this.queueEvent((GraphEvent)new RemovePropertyEvent((Graph)this, (Element)edge, propertyRemoveMutation));
            }
        }
        return edge;
    }

    public NameSubstitutionStrategy getNameSubstitutionStrategy() {
        return this.nameSubstitutionStrategy;
    }

    public CloseableIterable<Edge> getEdges(EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdgesInRange(null, null, fetchHints, authorizations);
    }

    public void removeEdge(Edge edge, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge);
        this.getSearchIndex().removeElement((Graph)this, (Element)edge, authorizations);
        ColumnVisibility visibility = AccumuloGraph.visibilityToAccumuloVisibility(edge.getVisibility());
        Mutation outMutation = new Mutation((CharSequence)("V" + edge.getVertexId(Direction.OUT)));
        outMutation.putDelete(AccumuloVertex.CF_OUT_EDGE, new Text(edge.getId()), visibility);
        Mutation inMutation = new Mutation((CharSequence)("V" + edge.getVertexId(Direction.IN)));
        inMutation.putDelete(AccumuloVertex.CF_IN_EDGE, new Text(edge.getId()), visibility);
        this.addMutations(this.getVerticesWriter(), outMutation, inMutation);
        this.addMutations(this.getEdgesWriter(), this.getDeleteRowMutation("E" + edge.getId()));
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new RemoveEdgeEvent((Graph)this, edge));
        }
    }

    public void markEdgeHidden(Edge edge, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge);
        Vertex out = edge.getVertex(Direction.OUT, authorizations);
        if (out == null) {
            throw new VertexiumException(String.format("Unable to mark edge hidden %s, can't find out vertex %s", edge.getId(), edge.getVertexId(Direction.OUT)));
        }
        Vertex in = edge.getVertex(Direction.IN, authorizations);
        if (in == null) {
            throw new VertexiumException(String.format("Unable to mark edge hidden %s, can't find in vertex %s", edge.getId(), edge.getVertexId(Direction.IN)));
        }
        ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
        Mutation outMutation = new Mutation((CharSequence)("V" + out.getId()));
        outMutation.put(AccumuloVertex.CF_OUT_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility, AccumuloElement.HIDDEN_VALUE);
        Mutation inMutation = new Mutation((CharSequence)("V" + in.getId()));
        inMutation.put(AccumuloVertex.CF_IN_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility, AccumuloElement.HIDDEN_VALUE);
        this.addMutations(this.getVerticesWriter(), outMutation, inMutation);
        this.addMutations(this.getEdgesWriter(), this.getMarkHiddenRowMutation("E" + edge.getId(), columnVisibility));
        if (out instanceof AccumuloVertex) {
            ((AccumuloVertex)out).removeOutEdge(edge);
        }
        if (in instanceof AccumuloVertex) {
            ((AccumuloVertex)in).removeInEdge(edge);
        }
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new MarkHiddenEdgeEvent((Graph)this, edge));
        }
    }

    public void markEdgeVisible(Edge edge, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge);
        Vertex out = edge.getVertex(Direction.OUT, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        if (out == null) {
            throw new VertexiumException(String.format("Unable to mark edge visible %s, can't find out vertex %s", edge.getId(), edge.getVertexId(Direction.OUT)));
        }
        Vertex in = edge.getVertex(Direction.IN, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        if (in == null) {
            throw new VertexiumException(String.format("Unable to mark edge visible %s, can't find in vertex %s", edge.getId(), edge.getVertexId(Direction.IN)));
        }
        ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
        Mutation outMutation = new Mutation((CharSequence)("V" + out.getId()));
        outMutation.putDelete(AccumuloVertex.CF_OUT_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility);
        Mutation inMutation = new Mutation((CharSequence)("V" + in.getId()));
        inMutation.putDelete(AccumuloVertex.CF_IN_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility);
        this.addMutations(this.getVerticesWriter(), outMutation, inMutation);
        this.addMutations(this.getEdgesWriter(), this.getMarkVisibleRowMutation("E" + edge.getId(), columnVisibility));
        if (out instanceof AccumuloVertex) {
            ((AccumuloVertex)out).addOutEdge(edge);
        }
        if (in instanceof AccumuloVertex) {
            ((AccumuloVertex)in).addInEdge(edge);
        }
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new MarkVisibleEdgeEvent((Graph)this, edge));
        }
    }

    public Authorizations createAuthorizations(String ... auths) {
        return new AccumuloAuthorizations(auths);
    }

    public void markPropertyHidden(AccumuloElement element, Property property, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)element);
        ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
        if (element instanceof Vertex) {
            this.addMutations(this.getVerticesWriter(), this.getMarkHiddenPropertyMutation("V" + element.getId(), property, columnVisibility));
        } else if (element instanceof Edge) {
            this.addMutations(this.getVerticesWriter(), this.getMarkHiddenPropertyMutation("E" + element.getId(), property, columnVisibility));
        }
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkHiddenPropertyEvent((Graph)this, (Element)element, property, visibility));
        }
    }

    private Mutation getMarkHiddenPropertyMutation(String rowKey, Property property, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        Text columnQualifier = ElementMutationBuilder.getPropertyColumnQualifierWithVisibilityString(property);
        m.put(AccumuloElement.CF_PROPERTY_HIDDEN, columnQualifier, visibility, AccumuloElement.HIDDEN_VALUE);
        return m;
    }

    public void markPropertyVisible(AccumuloElement element, Property property, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)element);
        ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
        if (element instanceof Vertex) {
            this.addMutations(this.getVerticesWriter(), this.getMarkVisiblePropertyMutation("V" + element.getId(), property, columnVisibility));
        } else if (element instanceof Edge) {
            this.addMutations(this.getVerticesWriter(), this.getMarkVisiblePropertyMutation("E" + element.getId(), property, columnVisibility));
        }
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkVisiblePropertyEvent((Graph)this, (Element)element, property, visibility));
        }
    }

    private Mutation getMarkVisiblePropertyMutation(String rowKey, Property property, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        Text columnQualifier = ElementMutationBuilder.getPropertyColumnQualifierWithVisibilityString(property);
        m.putDelete(AccumuloElement.CF_PROPERTY_HIDDEN, columnQualifier, visibility);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.hasEventListeners()) {
            Queue<GraphEvent> queue = this.graphEventQueue;
            synchronized (queue) {
                this.flushWritersAndSuper();
                this.flushGraphEventQueue();
            }
        } else {
            this.flushWritersAndSuper();
        }
    }

    private void flushWritersAndSuper() {
        AccumuloGraph.flushWriter(this.dataWriter);
        AccumuloGraph.flushWriter(this.verticesWriter);
        AccumuloGraph.flushWriter(this.edgesWriter);
        super.flush();
    }

    private void flushGraphEventQueue() {
        GraphEvent graphEvent;
        while ((graphEvent = this.graphEventQueue.poll()) != null) {
            this.fireGraphEvent(graphEvent);
        }
    }

    private static void flushWriter(BatchWriter writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (MutationsRejectedException e) {
                throw new VertexiumException("Could not flush", (Exception)((Object)e));
            }
        }
    }

    public void shutdown() {
        try {
            this.flush();
            if (this.dataWriter != null) {
                this.dataWriter.close();
                this.dataWriter = null;
            }
            if (this.verticesWriter != null) {
                this.verticesWriter.close();
                this.verticesWriter = null;
            }
            if (this.edgesWriter != null) {
                this.edgesWriter.close();
                this.edgesWriter = null;
            }
            super.shutdown();
        }
        catch (Exception ex) {
            throw new VertexiumException(ex);
        }
    }

    private Mutation getDeleteRowMutation(String rowKey) {
        Mutation m = new Mutation((CharSequence)rowKey);
        m.put(DELETE_ROW_COLUMN_FAMILY, DELETE_ROW_COLUMN_QUALIFIER, RowDeletingIterator.DELETE_ROW_VALUE);
        return m;
    }

    private Mutation getMarkHiddenRowMutation(String rowKey, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        m.put(AccumuloElement.CF_HIDDEN, AccumuloElement.CQ_HIDDEN, visibility, AccumuloElement.HIDDEN_VALUE);
        return m;
    }

    private Mutation getMarkVisibleRowMutation(String rowKey, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        m.putDelete(AccumuloElement.CF_HIDDEN, AccumuloElement.CQ_HIDDEN, visibility);
        return m;
    }

    public ValueSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public AccumuloGraphConfiguration getConfiguration() {
        return (AccumuloGraphConfiguration)super.getConfiguration();
    }

    public Vertex getVertex(String vertexId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) throws VertexiumException {
        Iterator vertices = this.getVerticesInRange(new Range((CharSequence)("V" + vertexId)), fetchHints, authorizations).iterator();
        if (vertices.hasNext()) {
            return (Vertex)vertices.next();
        }
        return null;
    }

    private CloseableIterable<Vertex> getVerticesInRange(String startId, String endId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) throws VertexiumException {
        Key startKey = startId == null ? new Key((CharSequence)"V") : new Key((CharSequence)("V" + startId));
        Key endKey = endId == null ? new Key((CharSequence)VERTEX_AFTER_ROW_KEY_PREFIX) : new Key((CharSequence)("V" + endId + "~"));
        Range range = new Range(startKey, endKey);
        return this.getVerticesInRange(range, fetchHints, authorizations);
    }

    protected Scanner createVertexScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations) throws VertexiumException {
        return this.createElementVisibilityScanner(fetchHints, authorizations, ElementType.VERTEX);
    }

    protected Scanner createEdgeScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations) throws VertexiumException {
        return this.createElementVisibilityScanner(fetchHints, authorizations, ElementType.EDGE);
    }

    private Scanner createElementVisibilityScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations, ElementType elementType) throws VertexiumException {
        try {
            String tableName = this.getTableNameFromElementType(elementType);
            Scanner scanner = this.connector.createScanner(tableName, this.toAccumuloAuthorizations(authorizations));
            if (this.getConfiguration().isUseServerSideElementVisibilityRowFilter()) {
                IteratorSetting iteratorSetting = new IteratorSetting(100, ElementVisibilityRowFilter.class.getSimpleName(), ElementVisibilityRowFilter.class);
                String elementMode = this.getElementModeFromElementType(elementType);
                iteratorSetting.addOption(elementMode, Boolean.TRUE.toString());
                scanner.addScanIterator(iteratorSetting);
            }
            this.applyFetchHints((ScannerBase)scanner, fetchHints, elementType);
            return scanner;
        }
        catch (TableNotFoundException e) {
            throw new VertexiumException((Exception)((Object)e));
        }
    }

    protected BatchScanner createVertexBatchScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations, int numQueryThreads) throws VertexiumException {
        return this.createElementVisibilityWholeRowBatchScanner(fetchHints, authorizations, ElementType.VERTEX, numQueryThreads);
    }

    protected BatchScanner createEdgeBatchScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations, int numQueryThreads) throws VertexiumException {
        return this.createElementVisibilityWholeRowBatchScanner(fetchHints, authorizations, ElementType.EDGE, numQueryThreads);
    }

    private BatchScanner createElementVisibilityWholeRowBatchScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations, ElementType elementType, int numQueryThreads) throws VertexiumException {
        BatchScanner scanner = this.createElementVisibilityBatchScanner(fetchHints, authorizations, elementType, numQueryThreads);
        IteratorSetting iteratorSetting = new IteratorSetting(101, WholeRowIterator.class.getSimpleName(), WholeRowIterator.class);
        scanner.addScanIterator(iteratorSetting);
        return scanner;
    }

    private BatchScanner createElementVisibilityBatchScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations, ElementType elementType, int numQueryThreads) {
        BatchScanner scanner = this.createElementBatchScanner(fetchHints, authorizations, elementType, numQueryThreads);
        if (this.getConfiguration().isUseServerSideElementVisibilityRowFilter()) {
            IteratorSetting iteratorSetting = new IteratorSetting(100, ElementVisibilityRowFilter.class.getSimpleName(), ElementVisibilityRowFilter.class);
            String elementMode = this.getElementModeFromElementType(elementType);
            iteratorSetting.addOption(elementMode, Boolean.TRUE.toString());
            scanner.addScanIterator(iteratorSetting);
        }
        return scanner;
    }

    private BatchScanner createElementBatchScanner(EnumSet<FetchHint> fetchHints, Authorizations authorizations, ElementType elementType, int numQueryThreads) {
        try {
            String tableName = this.getTableNameFromElementType(elementType);
            BatchScanner scanner = this.connector.createBatchScanner(tableName, this.toAccumuloAuthorizations(authorizations), numQueryThreads);
            this.applyFetchHints((ScannerBase)scanner, fetchHints, elementType);
            return scanner;
        }
        catch (TableNotFoundException e) {
            throw new VertexiumException((Exception)((Object)e));
        }
    }

    private void applyFetchHints(ScannerBase scanner, EnumSet<FetchHint> fetchHints, ElementType elementType) {
        scanner.clearColumns();
        if (fetchHints.equals(FetchHint.ALL)) {
            return;
        }
        scanner.fetchColumnFamily(AccumuloElement.CF_HIDDEN);
        if (elementType == ElementType.VERTEX) {
            scanner.fetchColumnFamily(AccumuloVertex.CF_SIGNAL);
        } else if (elementType == ElementType.EDGE) {
            scanner.fetchColumnFamily(AccumuloEdge.CF_SIGNAL);
            scanner.fetchColumnFamily(AccumuloEdge.CF_IN_VERTEX);
            scanner.fetchColumnFamily(AccumuloEdge.CF_OUT_VERTEX);
        } else {
            throw new VertexiumException("Unhandled element type: " + elementType);
        }
        if (fetchHints.contains(FetchHint.IN_EDGE_REFS)) {
            scanner.fetchColumnFamily(AccumuloVertex.CF_IN_EDGE);
            scanner.fetchColumnFamily(AccumuloVertex.CF_IN_EDGE_HIDDEN);
        }
        if (fetchHints.contains(FetchHint.OUT_EDGE_REFS)) {
            scanner.fetchColumnFamily(AccumuloVertex.CF_OUT_EDGE);
            scanner.fetchColumnFamily(AccumuloVertex.CF_OUT_EDGE_HIDDEN);
        }
        if (fetchHints.contains(FetchHint.PROPERTIES)) {
            scanner.fetchColumnFamily(AccumuloElement.CF_PROPERTY_HIDDEN);
            scanner.fetchColumnFamily(AccumuloElement.CF_PROPERTY);
        }
        if (fetchHints.contains(FetchHint.PROPERTY_METADATA)) {
            scanner.fetchColumnFamily(AccumuloElement.CF_PROPERTY_HIDDEN);
            scanner.fetchColumnFamily(AccumuloElement.CF_PROPERTY_METADATA);
        }
    }

    private String getTableNameFromElementType(ElementType elementType) {
        String tableName;
        switch (elementType) {
            case VERTEX: {
                tableName = this.getVerticesTableName();
                break;
            }
            case EDGE: {
                tableName = this.getEdgesTableName();
                break;
            }
            default: {
                throw new VertexiumException("Unexpected element type: " + elementType);
            }
        }
        return tableName;
    }

    private String getElementModeFromElementType(ElementType elementType) {
        String elementMode;
        switch (elementType) {
            case VERTEX: {
                elementMode = "vertex.enabled";
                break;
            }
            case EDGE: {
                elementMode = "edge.enabled";
                break;
            }
            default: {
                throw new VertexiumException("Unexpected element type: " + elementType);
            }
        }
        return elementMode;
    }

    private org.apache.accumulo.core.security.Authorizations toAccumuloAuthorizations(Authorizations authorizations) {
        if (authorizations == null) {
            throw new NullPointerException("authorizations is required");
        }
        return new org.apache.accumulo.core.security.Authorizations(authorizations.getAuthorizations());
    }

    public Edge getEdge(String edgeId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        Iterator edges = this.getEdgesInRange(edgeId, edgeId, fetchHints, authorizations).iterator();
        if (edges.hasNext()) {
            return (Edge)edges.next();
        }
        return null;
    }

    private void printTable(Authorizations authorizations) {
        String[] tables = new String[]{this.getEdgesTableName(), this.getVerticesTableName(), this.getDataTableName()};
        System.out.println("---------------------------------------------- BEGIN printTable ----------------------------------------------");
        try {
            for (String tableName : tables) {
                System.out.println("TABLE: " + tableName);
                System.out.println("");
                Scanner scanner = this.connector.createScanner(tableName, this.toAccumuloAuthorizations(authorizations));
                RowIterator it = new RowIterator(scanner.iterator());
                while (it.hasNext()) {
                    boolean first = true;
                    Text lastColumnFamily = null;
                    Iterator row = it.next();
                    while (row.hasNext()) {
                        Map.Entry col = (Map.Entry)row.next();
                        if (first) {
                            System.out.println("\"" + ((Key)col.getKey()).getRow() + "\"");
                            first = false;
                        }
                        if (!((Key)col.getKey()).getColumnFamily().equals(lastColumnFamily)) {
                            System.out.println("  \"" + ((Key)col.getKey()).getColumnFamily() + "\"");
                            lastColumnFamily = ((Key)col.getKey()).getColumnFamily();
                        }
                        System.out.println("    \"" + ((Key)col.getKey()).getColumnQualifier() + "\"(" + ((Key)col.getKey()).getColumnVisibility() + ")=\"" + col.getValue() + "\"");
                    }
                }
            }
            System.out.flush();
        }
        catch (TableNotFoundException e) {
            throw new VertexiumException((Exception)((Object)e));
        }
        System.out.println("---------------------------------------------- END printTable ------------------------------------------------");
    }

    public byte[] streamingPropertyValueTableData(String dataRowKey) {
        try {
            Scanner scanner = this.connector.createScanner(this.getDataTableName(), new org.apache.accumulo.core.security.Authorizations());
            scanner.setRange(new Range((CharSequence)dataRowKey));
            Iterator it = scanner.iterator();
            if (it.hasNext()) {
                Map.Entry col = (Map.Entry)it.next();
                return ((Value)col.getValue()).get();
            }
        }
        catch (Exception ex) {
            throw new VertexiumException(ex);
        }
        throw new VertexiumException("Unexpected end of row: " + dataRowKey);
    }

    public static ColumnVisibility visibilityToAccumuloVisibility(Visibility visibility) {
        return new ColumnVisibility(visibility.getVisibilityString());
    }

    public static ColumnVisibility visibilityToAccumuloVisibility(String visibilityString) {
        return new ColumnVisibility(visibilityString);
    }

    public static Visibility accumuloVisibilityToVisibility(ColumnVisibility columnVisibility) {
        String columnVisibilityString = columnVisibility.toString();
        return AccumuloGraph.accumuloVisibilityToVisibility(columnVisibilityString);
    }

    public static Visibility accumuloVisibilityToVisibility(String columnVisibilityString) {
        if (columnVisibilityString.startsWith("[") && columnVisibilityString.endsWith("]")) {
            return new Visibility(columnVisibilityString.substring(1, columnVisibilityString.length() - 1));
        }
        return new Visibility(columnVisibilityString);
    }

    public static String getVerticesTableName(String tableNamePrefix) {
        return tableNamePrefix + "_v";
    }

    public static String getEdgesTableName(String tableNamePrefix) {
        return tableNamePrefix + "_e";
    }

    public static String getDataTableName(String tableNamePrefix) {
        return tableNamePrefix + "_d";
    }

    public static String getMetadataTableName(String tableNamePrefix) {
        return tableNamePrefix + "_m";
    }

    public String getVerticesTableName() {
        return AccumuloGraph.getVerticesTableName(this.getConfiguration().getTableNamePrefix());
    }

    public String getEdgesTableName() {
        return AccumuloGraph.getEdgesTableName(this.getConfiguration().getTableNamePrefix());
    }

    public String getDataTableName() {
        return AccumuloGraph.getDataTableName(this.getConfiguration().getTableNamePrefix());
    }

    public String getMetadataTableName() {
        return AccumuloGraph.getMetadataTableName(this.getConfiguration().getTableNamePrefix());
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public Connector getConnector() {
        return this.connector;
    }

    void alterElementVisibility(AccumuloElement element, Visibility newVisibility) {
        Mutation m;
        BatchWriter elementWriter = this.getWriterFromElementType((Element)element);
        String rowPrefix = this.getRowPrefixForElement(element);
        String elementRowKey = rowPrefix + element.getId();
        if (element instanceof Edge) {
            String vinRowKey;
            Mutation mvin;
            BatchWriter vertexWriter = this.getVerticesWriter();
            Edge edge = (Edge)element;
            String voutRowKey = "V" + edge.getVertexId(Direction.OUT);
            Mutation mvout = new Mutation((CharSequence)voutRowKey);
            if (this.elementMutationBuilder.alterEdgeVertexOutVertex(mvout, edge, newVisibility)) {
                this.addMutations(vertexWriter, mvout);
            }
            if (this.elementMutationBuilder.alterEdgeVertexInVertex(mvin = new Mutation((CharSequence)(vinRowKey = "V" + edge.getVertexId(Direction.IN))), edge, newVisibility)) {
                this.addMutations(vertexWriter, mvin);
            }
        }
        if (this.elementMutationBuilder.alterElementVisibility(m = new Mutation((CharSequence)elementRowKey), element, newVisibility)) {
            this.addMutations(elementWriter, m);
        }
    }

    public void alterEdgeLabel(AccumuloEdge edge, String newEdgeLabel) {
        this.elementMutationBuilder.alterEdgeLabel(edge, newEdgeLabel);
    }

    void alterElementPropertyVisibilities(AccumuloElement element, List<AlterPropertyVisibility> alterPropertyVisibilities) {
        if (alterPropertyVisibilities.size() == 0) {
            return;
        }
        BatchWriter writer = this.getWriterFromElementType((Element)element);
        String rowPrefix = this.getRowPrefixForElement(element);
        String elementRowKey = rowPrefix + element.getId();
        boolean propertyChanged = false;
        Mutation m = new Mutation((CharSequence)elementRowKey);
        for (AlterPropertyVisibility apv : alterPropertyVisibilities) {
            MutableProperty property = (MutableProperty)element.getProperty(apv.getKey(), apv.getName(), apv.getExistingVisibility());
            if (property == null) {
                throw new VertexiumException("Could not find property " + apv.getKey() + ":" + apv.getName());
            }
            if (property.getVisibility().equals((Object)apv.getVisibility())) continue;
            this.elementMutationBuilder.addPropertyRemoveToMutation(m, (Property)property);
            property.setVisibility(apv.getVisibility());
            this.elementMutationBuilder.addPropertyToMutation(m, elementRowKey, (Property)property);
            propertyChanged = true;
        }
        if (propertyChanged) {
            this.addMutations(writer, m);
        }
    }

    void alterPropertyMetadatas(AccumuloElement element, List<SetPropertyMetadata> setPropertyMetadatas) {
        if (setPropertyMetadatas.size() == 0) {
            return;
        }
        ArrayList<Property> propertiesToSave = new ArrayList<Property>();
        for (SetPropertyMetadata apm : setPropertyMetadatas) {
            Property property = element.getProperty(apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility());
            if (property == null) {
                throw new VertexiumException(String.format("Could not find property %s:%s(%s)", apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility()));
            }
            property.getMetadata().add(apm.getMetadataName(), apm.getNewValue(), apm.getMetadataVisibility());
            propertiesToSave.add(property);
        }
        BatchWriter writer = this.getWriterFromElementType((Element)element);
        String rowPrefix = this.getRowPrefixForElement(element);
        String elementRowKey = rowPrefix + element.getId();
        Mutation m = new Mutation((CharSequence)elementRowKey);
        for (Property property : propertiesToSave) {
            this.elementMutationBuilder.addPropertyMetadataToMutation(m, property);
        }
        this.addMutations(writer, m);
    }

    public boolean isVisibilityValid(Visibility visibility, Authorizations authorizations) {
        return authorizations.canRead(visibility);
    }

    public void clearData() {
        try {
            this.connector.tableOperations().deleteRows(this.getDataTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getEdgesTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getVerticesTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getMetadataTableName(), null, null);
            this.getSearchIndex().clearData();
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not delete rows", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> findRelatedEdges(Iterable<String> vertexIds, Authorizations authorizations) {
        Set vertexIdsSet = IterableUtils.toSet(vertexIds);
        if (vertexIdsSet.size() == 0) {
            return new HashSet<String>();
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String vertexId : vertexIdsSet) {
            Text rowKey = new Text("V" + vertexId);
            Range range = new Range(rowKey);
            ranges.add(range);
        }
        int numQueryThreads = Math.min(Math.max(1, ranges.size() / 10), 10);
        try (BatchScanner batchScanner = this.createElementBatchScanner(EnumSet.of(FetchHint.OUT_EDGE_REFS), authorizations, ElementType.VERTEX, numQueryThreads);){
            batchScanner.setRanges(ranges);
            Iterator it = batchScanner.iterator();
            HashSet<String> edgeIds = new HashSet<String>();
            while (it.hasNext()) {
                EdgeInfo edgeInfo;
                Map.Entry c = (Map.Entry)it.next();
                if (!((Key)c.getKey()).getColumnFamily().equals((Object)AccumuloVertex.CF_OUT_EDGE) || !vertexIdsSet.contains((edgeInfo = EdgeInfo.parse((Value)c.getValue())).getVertexId())) continue;
                String edgeId = ((Key)c.getKey()).getColumnQualifier().toString();
                edgeIds.add(edgeId);
            }
            HashSet<String> hashSet = edgeIds;
            return hashSet;
        }
    }

    public Iterable<GraphMetadataEntry> getMetadataInRange(final Range range) {
        return new LookAheadIterable<Map.Entry<Key, Value>, GraphMetadataEntry>(){
            public BatchScanner batchScanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, GraphMetadataEntry graphMetadataEntry) {
                return true;
            }

            protected GraphMetadataEntry convert(Map.Entry<Key, Value> entry) {
                String key = entry.getKey().getRow().toString();
                Object value = JavaSerializableUtils.bytesToObject((byte[])entry.getValue().get());
                return new GraphMetadataEntry(key, value);
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                try {
                    this.batchScanner = AccumuloGraph.this.connector.createBatchScanner(AccumuloGraph.this.getMetadataTableName(), AccumuloGraph.this.toAccumuloAuthorizations(METADATA_AUTHORIZATIONS), 1);
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    if (range == null) {
                        ranges.add(new Range());
                    } else {
                        ranges.add(range);
                    }
                    this.batchScanner.setRanges(ranges);
                }
                catch (TableNotFoundException ex) {
                    throw new VertexiumException("Could not create metadata scanner", (Exception)((Object)ex));
                }
                return this.batchScanner.iterator();
            }

            public void close() {
                super.close();
                this.batchScanner.close();
            }
        };
    }

    public Iterable<GraphMetadataEntry> getMetadata() {
        return this.getMetadataInRange(null);
    }

    public void setMetadata(String key, Object value) {
        try {
            Mutation m = new Mutation((CharSequence)key);
            byte[] valueBytes = JavaSerializableUtils.objectToBytes((Object)value);
            m.put(METADATA_COLUMN_FAMILY, METADATA_COLUMN_QUALIFIER, new Value(valueBytes));
            BatchWriter writer = this.getMetadataWriter();
            writer.addMutation(m);
            writer.flush();
        }
        catch (MutationsRejectedException ex) {
            throw new VertexiumException("Could not add metadata " + key, (Exception)((Object)ex));
        }
    }

    public Object getMetadata(String key) {
        Range range = new Range((CharSequence)key);
        GraphMetadataEntry entry = (GraphMetadataEntry)IterableUtils.singleOrDefault(this.getMetadataInRange(range), null);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    protected CloseableIterable<Vertex> getVerticesInRange(final Range range, final EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<Iterator<Map.Entry<Key, Value>>, Vertex>(){
            public Scanner scanner;

            protected boolean isIncluded(Iterator<Map.Entry<Key, Value>> src, Vertex dest) {
                return dest != null;
            }

            protected Vertex convert(Iterator<Map.Entry<Key, Value>> next) {
                VertexMaker maker = new VertexMaker(AccumuloGraph.this, next, authorizations);
                return (Vertex)maker.make(includeHidden);
            }

            protected Iterator<Iterator<Map.Entry<Key, Value>>> createIterator() {
                this.scanner = AccumuloGraph.this.createVertexScanner(fetchHints, authorizations);
                this.scanner.setRange(range);
                return new RowIterator(this.scanner.iterator());
            }

            public void close() {
                super.close();
                this.scanner.close();
            }
        };
    }

    public CloseableIterable<Vertex> getVertices(Iterable<String> ids, final EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        final ArrayList<Range> ranges = new ArrayList<Range>();
        for (String id : ids) {
            Text rowKey = new Text("V" + id);
            ranges.add(new Range(rowKey));
        }
        if (ranges.size() == 0) {
            return new EmptyClosableIterable();
        }
        return new LookAheadIterable<Map.Entry<Key, Value>, Vertex>(){
            public BatchScanner batchScanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, Vertex dest) {
                return dest != null;
            }

            protected Vertex convert(Map.Entry<Key, Value> wholeRow) {
                try {
                    SortedMap row = WholeRowIterator.decodeRow((Key)wholeRow.getKey(), (Value)wholeRow.getValue());
                    VertexMaker maker = new VertexMaker(AccumuloGraph.this, row.entrySet().iterator(), authorizations);
                    return (Vertex)maker.make(includeHidden);
                }
                catch (IOException ex) {
                    throw new VertexiumException("Could not recreate row", (Exception)ex);
                }
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                this.batchScanner = AccumuloGraph.this.createVertexBatchScanner(fetchHints, authorizations, Math.min(Math.max(1, ranges.size() / 10), 10));
                this.batchScanner.setRanges((Collection)ranges);
                return this.batchScanner.iterator();
            }

            public void close() {
                super.close();
                this.batchScanner.close();
            }
        };
    }

    public CloseableIterable<Edge> getEdges(Iterable<String> ids, final EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        final ArrayList<Range> ranges = new ArrayList<Range>();
        for (String id : ids) {
            Text rowKey = new Text("E" + id);
            ranges.add(new Range(rowKey));
        }
        if (ranges.size() == 0) {
            return new EmptyClosableIterable();
        }
        return new LookAheadIterable<Map.Entry<Key, Value>, Edge>(){
            public BatchScanner batchScanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, Edge dest) {
                return dest != null;
            }

            protected Edge convert(Map.Entry<Key, Value> wholeRow) {
                try {
                    SortedMap row = WholeRowIterator.decodeRow((Key)wholeRow.getKey(), (Value)wholeRow.getValue());
                    EdgeMaker maker = new EdgeMaker(AccumuloGraph.this, row.entrySet().iterator(), authorizations);
                    return (Edge)maker.make(includeHidden);
                }
                catch (IOException ex) {
                    throw new VertexiumException("Could not recreate row", (Exception)ex);
                }
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                this.batchScanner = AccumuloGraph.this.createEdgeBatchScanner(fetchHints, authorizations, Math.min(Math.max(1, ranges.size() / 10), 10));
                this.batchScanner.setRanges((Collection)ranges);
                return this.batchScanner.iterator();
            }

            public void close() {
                super.close();
                this.batchScanner.close();
            }
        };
    }

    protected CloseableIterable<Edge> getEdgesInRange(String startId, String endId, final EnumSet<FetchHint> fetchHints, final Authorizations authorizations) throws VertexiumException {
        final AccumuloGraph graph = this;
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        final Key startKey = startId == null ? new Key((CharSequence)"E") : new Key((CharSequence)("E" + startId));
        final Key endKey = endId == null ? new Key((CharSequence)EDGE_AFTER_ROW_KEY_PREFIX) : new Key((CharSequence)("E" + endId + "~"));
        return new LookAheadIterable<Iterator<Map.Entry<Key, Value>>, Edge>(){
            public Scanner scanner;

            protected boolean isIncluded(Iterator<Map.Entry<Key, Value>> src, Edge dest) {
                return dest != null;
            }

            protected Edge convert(Iterator<Map.Entry<Key, Value>> next) {
                EdgeMaker maker = new EdgeMaker(graph, next, authorizations);
                return (Edge)maker.make(includeHidden);
            }

            protected Iterator<Iterator<Map.Entry<Key, Value>>> createIterator() {
                this.scanner = AccumuloGraph.this.createEdgeScanner(fetchHints, authorizations);
                this.scanner.setRange(new Range(startKey, endKey));
                return new RowIterator(this.scanner.iterator());
            }

            public void close() {
                super.close();
                this.scanner.close();
            }
        };
    }

    private static abstract class AddEdgeToVertexRunnable {
        private AddEdgeToVertexRunnable() {
        }

        public abstract void run(AccumuloEdge var1);
    }
}

