/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.accumulo.SimpleSubstitutionUtils;
import org.neolumin.vertexium.accumulo.serializer.JavaValueSerializer;
import org.neolumin.vertexium.accumulo.serializer.ValueSerializer;
import org.neolumin.vertexium.id.IdentityNameSubstitutionStrategy;
import org.neolumin.vertexium.id.NameSubstitutionStrategy;
import org.neolumin.vertexium.id.SimpleNameSubstitutionStrategy;
import org.neolumin.vertexium.util.ConfigurationUtils;
import org.neolumin.vertexium.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloGraphConfiguration
extends GraphConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccumuloGraphConfiguration.class);
    public static final String HDFS_CONFIG_PREFIX = "hdfs";
    public static final String BATCHWRITER_CONFIG_PREFIX = "batchwriter";
    public static final String ACCUMULO_INSTANCE_NAME = "accumuloInstanceName";
    public static final String ACCUMULO_USERNAME = "username";
    public static final String ACCUMULO_PASSWORD = "password";
    public static final String ZOOKEEPER_SERVERS = "zookeeperServers";
    public static final String VALUE_SERIALIZER_PROP_PREFIX = "serializer";
    public static final String NAME_SUBSTITUTION_STRATEGY_PROP_PREFIX = "nameSubstitutionStrategy";
    public static final String TABLE_NAME_PREFIX = "tableNamePrefix";
    public static final String MAX_STREAMING_PROPERTY_VALUE_TABLE_DATA_SIZE = "maxStreamingPropertyValueTableDataSize";
    public static final String HDFS_USER = "hdfs.user";
    public static final String HDFS_ROOT_DIR = "hdfs.rootDir";
    public static final String DATA_DIR = "hdfs.dataDir";
    public static final String USE_SERVER_SIDE_ELEMENT_VISIBILITY_ROW_FILTER = "useServerSideElementVisibilityRowFilter";
    public static final String BATCHWRITER_MAX_MEMORY = "batchwriter.maxMemory";
    public static final String BATCHWRITER_MAX_LATENCY = "batchwriter.maxLatency";
    public static final String BATCHWRITER_TIMEOUT = "batchwriter.timeout";
    public static final String BATCHWRITER_MAX_WRITE_THREADS = "batchwriter.maxWriteThreads";
    public static final String DEFAULT_ACCUMULO_PASSWORD = "password";
    public static final String DEFAULT_VALUE_SERIALIZER = JavaValueSerializer.class.getName();
    public static final String DEFAULT_ACCUMULO_USERNAME = "root";
    public static final String DEFAULT_ACCUMULO_INSTANCE_NAME = "vertexium";
    public static final String DEFAULT_ZOOKEEPER_SERVERS = "localhost";
    public static final String DEFAULT_TABLE_NAME_PREFIX = "vertexium";
    public static final int DEFAULT_MAX_STREAMING_PROPERTY_VALUE_TABLE_DATA_SIZE = 0xA00000;
    public static final String DEFAULT_HDFS_USER = "hadoop";
    public static final String DEFAULT_HDFS_ROOT_DIR = "";
    public static final String DEFAULT_DATA_DIR = "/accumuloGraph";
    public static final boolean DEFAULT_USE_SERVER_SIDE_ELEMENT_VISIBILITY_ROW_FILTER = true;
    private static final String DEFAULT_NAME_SUBSTITUTION_STRATEGY = IdentityNameSubstitutionStrategy.class.getName();
    public static final Long DEFAULT_BATCHWRITER_MAX_MEMORY = 0x3200000L;
    public static final Long DEFAULT_BATCHWRITER_MAX_LATENCY = 120000L;
    public static final Long DEFAULT_BATCHWRITER_TIMEOUT = Long.MAX_VALUE;
    public static final Integer DEFAULT_BATCHWRITER_MAX_WRITE_THREADS = 3;

    public AccumuloGraphConfiguration(Map config) {
        super(config);
    }

    public AccumuloGraphConfiguration(Configuration configuration, String prefix) {
        super(AccumuloGraphConfiguration.toMap(configuration, prefix));
    }

    private static Map toMap(Configuration configuration, String prefix) {
        HashMap map = new HashMap();
        for (Map.Entry entry : configuration) {
            String key = (String)entry.getKey();
            if (key.startsWith(prefix)) {
                key = key.substring(prefix.length());
            }
            map.put(key, entry.getValue());
        }
        return map;
    }

    public Connector createConnector() throws AccumuloSecurityException, AccumuloException {
        LOGGER.info("Connecting to accumulo instance [{}] zookeeper servers [{}]", (Object)this.getAccumuloInstanceName(), (Object)this.getZookeeperServers());
        ZooKeeperInstance instance = new ZooKeeperInstance(this.getAccumuloInstanceName(), this.getZookeeperServers());
        return instance.getConnector(this.getAccumuloUsername(), this.getAuthenticationToken());
    }

    public FileSystem createFileSystem() throws URISyntaxException, IOException, InterruptedException {
        return FileSystem.get((URI)this.getHdfsRootDir(), (Configuration)this.getHadoopConfiguration(), (String)this.getHdfsUser());
    }

    private String getHdfsUser() {
        return this.getString(HDFS_USER, DEFAULT_HDFS_USER);
    }

    private URI getHdfsRootDir() throws URISyntaxException {
        return new URI(this.getString(HDFS_ROOT_DIR, DEFAULT_HDFS_ROOT_DIR));
    }

    private Configuration getHadoopConfiguration() {
        Configuration configuration = new Configuration();
        Iterator i$ = MapUtils.getAllWithPrefix((Map)this.getConfig(), (String)HDFS_CONFIG_PREFIX).entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entrySetObject;
            Map.Entry entrySet = entrySetObject = i$.next();
            configuration.set(DEFAULT_HDFS_ROOT_DIR + entrySet.getKey(), DEFAULT_HDFS_ROOT_DIR + entrySet.getValue());
        }
        return configuration;
    }

    public AuthenticationToken getAuthenticationToken() {
        String password = this.getString("password", "password");
        return new PasswordToken((CharSequence)password);
    }

    public String getAccumuloUsername() {
        return this.getString(ACCUMULO_USERNAME, DEFAULT_ACCUMULO_USERNAME);
    }

    public String getAccumuloInstanceName() {
        return this.getString(ACCUMULO_INSTANCE_NAME, "vertexium");
    }

    public String getZookeeperServers() {
        return this.getString(ZOOKEEPER_SERVERS, DEFAULT_ZOOKEEPER_SERVERS);
    }

    public ValueSerializer createValueSerializer() throws VertexiumException {
        return (ValueSerializer)ConfigurationUtils.createProvider((GraphConfiguration)this, (String)VALUE_SERIALIZER_PROP_PREFIX, (String)DEFAULT_VALUE_SERIALIZER);
    }

    public boolean isAutoFlush() {
        return this.getBoolean("autoFlush", false);
    }

    public String getTableNamePrefix() {
        return this.getString(TABLE_NAME_PREFIX, "vertexium");
    }

    public long getMaxStreamingPropertyValueTableDataSize() {
        return this.getConfigLong(MAX_STREAMING_PROPERTY_VALUE_TABLE_DATA_SIZE, 0xA00000L);
    }

    public String getDataDir() {
        return this.getString(DATA_DIR, DEFAULT_DATA_DIR);
    }

    public boolean isUseServerSideElementVisibilityRowFilter() {
        return this.getBoolean(USE_SERVER_SIDE_ELEMENT_VISIBILITY_ROW_FILTER, true);
    }

    public NameSubstitutionStrategy createSubstitutionStrategy() {
        NameSubstitutionStrategy strategy = (NameSubstitutionStrategy)ConfigurationUtils.createProvider((GraphConfiguration)this, (String)NAME_SUBSTITUTION_STRATEGY_PROP_PREFIX, (String)DEFAULT_NAME_SUBSTITUTION_STRATEGY);
        if (strategy instanceof SimpleNameSubstitutionStrategy) {
            ((SimpleNameSubstitutionStrategy)strategy).setSubstitutionList(SimpleSubstitutionUtils.getSubstitutionList(this.getConfig()));
        }
        return strategy;
    }

    public BatchWriterConfig createBatchWriterConfig() {
        long maxMemory = this.getConfigLong(BATCHWRITER_MAX_MEMORY, DEFAULT_BATCHWRITER_MAX_MEMORY);
        long maxLatency = this.getConfigLong(BATCHWRITER_MAX_LATENCY, DEFAULT_BATCHWRITER_MAX_LATENCY);
        int maxWriteThreads = this.getInt(BATCHWRITER_MAX_WRITE_THREADS, DEFAULT_BATCHWRITER_MAX_WRITE_THREADS);
        long timeout = this.getConfigLong(BATCHWRITER_TIMEOUT, DEFAULT_BATCHWRITER_TIMEOUT);
        BatchWriterConfig config = new BatchWriterConfig();
        config.setMaxMemory(maxMemory);
        config.setMaxLatency(maxLatency, TimeUnit.MILLISECONDS);
        config.setMaxWriteThreads(maxWriteThreads);
        config.setTimeout(timeout, TimeUnit.MILLISECONDS);
        return config;
    }
}

