/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloElement;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.EdgeInfo;
import org.neolumin.vertexium.accumulo.GetVertexIdsIterable;
import org.neolumin.vertexium.mutation.ExistingElementMutation;
import org.neolumin.vertexium.mutation.ExistingElementMutationImpl;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;
import org.neolumin.vertexium.query.VertexQuery;
import org.neolumin.vertexium.util.ConvertingIterable;
import org.neolumin.vertexium.util.IterableUtils;
import org.neolumin.vertexium.util.JoinIterable;
import org.neolumin.vertexium.util.LookAheadIterable;

public class AccumuloVertex
extends AccumuloElement
implements Vertex {
    public static final Text CF_SIGNAL = new Text("V");
    public static final Text CF_OUT_EDGE = new Text("EOUT");
    public static final Text CF_OUT_EDGE_HIDDEN = new Text("EOUTH");
    public static final Text CF_IN_EDGE = new Text("EIN");
    public static final Text CF_IN_EDGE_HIDDEN = new Text("EINH");
    private final Map<String, EdgeInfo> inEdges;
    private final Map<String, EdgeInfo> outEdges;

    public AccumuloVertex(AccumuloGraph graph, String vertexId, Visibility vertexVisibility, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations, Iterable<Visibility> hiddenVisibilities, Authorizations authorizations, long timestamp) {
        this(graph, vertexId, vertexVisibility, properties, propertyRemoveMutations, hiddenVisibilities, new HashMap<String, EdgeInfo>(), new HashMap<String, EdgeInfo>(), authorizations, timestamp);
    }

    AccumuloVertex(AccumuloGraph graph, String vertexId, Visibility vertexVisibility, Iterable<Property> properties, Iterable<PropertyRemoveMutation> propertyRemoveMutations, Iterable<Visibility> hiddenVisibilities, Map<String, EdgeInfo> inEdges, Map<String, EdgeInfo> outEdges, Authorizations authorizations, long timestamp) {
        super((Graph)graph, vertexId, vertexVisibility, properties, propertyRemoveMutations, hiddenVisibilities, authorizations, timestamp);
        this.inEdges = inEdges;
        this.outEdges = outEdges;
    }

    public Iterable<Edge> getEdges(Direction direction, Authorizations authorizations) {
        return this.getEdges(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIds(direction, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(null, direction, null, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIds(direction, this.labelToArrayOrNull(label), authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(null, direction, this.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(null, direction, labels, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(null, direction, labels, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, null, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, null, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, this.labelToArrayOrNull(label), authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, this.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, labels, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, labels, authorizations);
    }

    public int getEdgeCount(Direction direction, Authorizations authorizations) {
        return IterableUtils.count(this.getEdgeIds(direction, authorizations));
    }

    public Iterable<String> getEdgeLabels(Direction direction, Authorizations authorizations) {
        return IterableUtils.toSet((Iterable)new ConvertingIterable<Map.Entry<String, EdgeInfo>, String>(this.getEdgeInfos(direction)){

            protected String convert(Map.Entry<String, EdgeInfo> o) {
                return o.getValue().getLabel();
            }
        });
    }

    public Iterable<Vertex> getVertices(Direction direction, Authorizations authorizations) {
        return this.getVertices(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<String> getEdgeIdsWithOtherVertexId(final String otherVertexId, final Direction direction, final String[] labels, Authorizations authorizations) {
        return new LookAheadIterable<Map.Entry<String, EdgeInfo>, String>(){

            protected boolean isIncluded(Map.Entry<String, EdgeInfo> edgeInfo, String edgeId) {
                if (otherVertexId != null && !otherVertexId.equals(edgeInfo.getValue().getVertexId())) {
                    return false;
                }
                if (labels == null || labels.length == 0) {
                    return true;
                }
                for (String label : labels) {
                    if (!label.equals(edgeInfo.getValue().getLabel())) continue;
                    return true;
                }
                return false;
            }

            protected String convert(Map.Entry<String, EdgeInfo> edgeInfo) {
                return edgeInfo.getKey();
            }

            protected Iterator<Map.Entry<String, EdgeInfo>> createIterator() {
                return AccumuloVertex.this.getEdgeInfos(direction).iterator();
            }
        };
    }

    private Iterable<Map.Entry<String, EdgeInfo>> getEdgeInfos(Direction direction) {
        switch (direction) {
            case IN: {
                return this.inEdges.entrySet();
            }
            case OUT: {
                return this.outEdges.entrySet();
            }
            case BOTH: {
                return new JoinIterable(new Iterable[]{this.inEdges.entrySet(), this.outEdges.entrySet()});
            }
        }
        throw new VertexiumException("Unexpected direction: " + direction);
    }

    public Iterable<Vertex> getVertices(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertices(this.getVertexIds(direction, authorizations), fetchHints, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, Authorizations authorizations) {
        return this.getVertices(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVertices(direction, this.labelToArrayOrNull(label), fetchHints, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getVertices(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertices(this.getVertexIds(direction, labels, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getVertexIds(Direction direction, String label, Authorizations authorizations) {
        return this.getVertexIds(direction, this.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<String> getVertexIds(Direction direction, Authorizations authorizations) {
        return this.getVertexIds(direction, (String[])null, authorizations);
    }

    public Iterable<String> getVertexIds(Direction direction, String[] labels, Authorizations authorizations) {
        switch (direction) {
            case BOTH: {
                Iterable<String> inVertexIds = this.getVertexIds(Direction.IN, labels, authorizations);
                Iterable<String> outVertexIds = this.getVertexIds(Direction.OUT, labels, authorizations);
                return new JoinIterable(new Iterable[]{inVertexIds, outVertexIds});
            }
            case IN: {
                return new GetVertexIdsIterable(this.inEdges.values(), labels);
            }
            case OUT: {
                return new GetVertexIdsIterable(this.outEdges.values(), labels);
            }
        }
        throw new VertexiumException("Unexpected direction: " + direction);
    }

    public VertexQuery query(Authorizations authorizations) {
        return this.query(null, authorizations);
    }

    public VertexQuery query(String queryString, Authorizations authorizations) {
        return this.getGraph().getSearchIndex().queryVertex((Graph)this.getGraph(), (Vertex)this, queryString, authorizations);
    }

    void addOutEdge(Edge edge) {
        this.outEdges.put(edge.getId(), new EdgeInfo(edge.getLabel(), edge.getVertexId(Direction.IN)));
    }

    void removeOutEdge(Edge edge) {
        this.outEdges.remove(edge.getId());
    }

    void addInEdge(Edge edge) {
        this.inEdges.put(edge.getId(), new EdgeInfo(edge.getLabel(), edge.getVertexId(Direction.OUT)));
    }

    void removeInEdge(Edge edge) {
        this.inEdges.remove(edge.getId());
    }

    public ExistingElementMutation<Vertex> prepareMutation() {
        return new ExistingElementMutationImpl<Vertex>((Vertex)this){

            public Vertex save(Authorizations authorizations) {
                AccumuloVertex.this.saveExistingElementMutation(this, authorizations);
                return (Vertex)this.getElement();
            }
        };
    }
}

