/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.accumulo.core.data.Value;
import org.neolumin.vertexium.VertexiumException;

public class EdgeInfo {
    public static final String CHARSET_NAME = "UTF-8";
    private final byte[] bytes;
    private transient boolean decoded;
    private transient String label;
    private transient String vertexId;

    public EdgeInfo(String label, String vertexId) {
        try {
            int vertexIdBytesLength;
            byte[] vertexIdBytes;
            int labelBytesLength;
            byte[] labelBytes;
            if (label == null) {
                labelBytes = null;
                labelBytesLength = -1;
            } else {
                labelBytes = label.getBytes(CHARSET_NAME);
                labelBytesLength = labelBytes.length;
            }
            if (vertexId == null) {
                vertexIdBytes = null;
                vertexIdBytesLength = -1;
            } else {
                vertexIdBytes = vertexId.getBytes(CHARSET_NAME);
                vertexIdBytesLength = vertexIdBytes.length;
            }
            int len = 4 + labelBytesLength + 4 + vertexIdBytesLength;
            ByteBuffer buffer = ByteBuffer.allocate(len);
            buffer.putInt(labelBytesLength);
            if (labelBytes != null) {
                buffer.put(labelBytes);
            }
            buffer.putInt(vertexIdBytesLength);
            if (vertexIdBytes != null) {
                buffer.put(vertexIdBytes);
            }
            this.bytes = buffer.array();
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not serialize edge info", (Exception)ex);
        }
    }

    public EdgeInfo(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getLabel() {
        this.decodeBytes();
        return this.label;
    }

    public String getVertexId() {
        this.decodeBytes();
        return this.vertexId;
    }

    private void decodeBytes() {
        if (!this.decoded) {
            try {
                ByteBuffer in = ByteBuffer.wrap(this.bytes);
                this.label = this.readString(in);
                this.vertexId = this.readString(in);
                this.decoded = true;
            }
            catch (IOException ex) {
                throw new VertexiumException("Could not decode EdgeInfo data", (Exception)ex);
            }
        }
    }

    private String readString(ByteBuffer in) throws IOException {
        int labelBytesLength = in.getInt();
        if (labelBytesLength == -1) {
            return null;
        }
        byte[] d = new byte[labelBytesLength];
        in.get(d);
        return new String(d, CHARSET_NAME);
    }

    public static EdgeInfo parse(Value value) {
        return new EdgeInfo(value.get());
    }

    public Value toValue() {
        return new Value(this.bytes);
    }
}

