/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.accumulo.AccumuloEdge;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.ElementMaker;

public class EdgeMaker
extends ElementMaker<Edge> {
    private static final String VISIBILITY_SIGNAL = AccumuloEdge.CF_SIGNAL.toString();
    private final AccumuloGraph graph;
    private String inVertexId;
    private String outVertexId;
    private String label;
    private long timestamp;

    public EdgeMaker(AccumuloGraph graph, Iterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        super(graph, row, authorizations);
        this.graph = graph;
    }

    @Override
    protected void processColumn(Key key, Value value) {
        Text columnFamily = this.getColumnFamily(key);
        Text columnQualifier = this.getColumnQualifier(key);
        if (AccumuloEdge.CF_SIGNAL.compareTo((BinaryComparable)columnFamily) == 0) {
            this.label = columnQualifier.toString();
            this.timestamp = key.getTimestamp();
            return;
        }
        if (AccumuloEdge.CF_IN_VERTEX.compareTo((BinaryComparable)columnFamily) == 0) {
            this.inVertexId = columnQualifier.toString();
            return;
        }
        if (AccumuloEdge.CF_OUT_VERTEX.compareTo((BinaryComparable)columnFamily) == 0) {
            this.outVertexId = columnQualifier.toString();
        }
    }

    @Override
    protected String getIdFromRowKey(String rowKey) {
        if (rowKey.startsWith("E")) {
            return rowKey.substring("E".length());
        }
        throw new VertexiumException("Invalid row key for edge: " + rowKey);
    }

    @Override
    protected String getVisibilitySignal() {
        return VISIBILITY_SIGNAL;
    }

    @Override
    protected Edge makeElement(boolean includeHidden) {
        return new AccumuloEdge((Graph)this.graph, this.getId(), this.outVertexId, this.inVertexId, this.label, null, this.getVisibility(), this.getProperties(includeHidden), null, this.getHiddenVisibilities(), this.getAuthorizations(), this.timestamp);
    }
}

