/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloElement;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.LazyMutableProperty;
import org.neolumin.vertexium.accumulo.LazyPropertyMetadata;

public abstract class ElementMaker<T> {
    private final Iterator<Map.Entry<Key, Value>> row;
    private final Map<String, String> propertyNames = new HashMap<String, String>();
    private final Map<String, String> propertyColumnQualifier = new HashMap<String, String>();
    private final Map<String, byte[]> propertyValues = new HashMap<String, byte[]>();
    private final Map<String, Visibility> propertyVisibilities = new HashMap<String, Visibility>();
    private final Map<String, LazyPropertyMetadata> propertyMetadata = new HashMap<String, LazyPropertyMetadata>();
    private final Map<String, Long> propertyTimestamps = new HashMap<String, Long>();
    private final Set<HiddenProperty> hiddenProperties = new HashSet<HiddenProperty>();
    private final Set<Visibility> hiddenVisibilities = new HashSet<Visibility>();
    private final AccumuloGraph graph;
    private final Authorizations authorizations;
    private String id;
    private Visibility visibility;

    public ElementMaker(AccumuloGraph graph, Iterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        this.graph = graph;
        this.row = row;
        this.authorizations = authorizations;
    }

    public T make(boolean includeHidden) {
        while (this.row.hasNext()) {
            Map.Entry<Key, Value> col = this.row.next();
            if (this.id == null) {
                this.id = this.getIdFromRowKey(col.getKey().getRow().toString());
            }
            Text columnFamily = this.getColumnFamily(col.getKey());
            Text columnQualifier = this.getColumnQualifier(col.getKey());
            ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(col.getKey().getColumnVisibility().toString());
            Value value = col.getValue();
            if (columnFamily.equals((Object)AccumuloGraph.DELETE_ROW_COLUMN_FAMILY) && columnQualifier.equals((Object)AccumuloGraph.DELETE_ROW_COLUMN_QUALIFIER) && value.equals((Object)RowDeletingIterator.DELETE_ROW_VALUE)) {
                return null;
            }
            if (columnFamily.equals((Object)AccumuloElement.CF_HIDDEN)) {
                if (includeHidden) {
                    this.hiddenVisibilities.add(AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility));
                } else {
                    return null;
                }
            }
            if (columnFamily.equals((Object)AccumuloElement.CF_PROPERTY_HIDDEN)) {
                this.extractPropertyHidden(columnQualifier, columnVisibility);
            }
            if (AccumuloElement.CF_PROPERTY.compareTo((BinaryComparable)columnFamily) == 0) {
                this.extractPropertyData(col, columnVisibility);
                continue;
            }
            if (AccumuloElement.CF_PROPERTY_METADATA.compareTo((BinaryComparable)columnFamily) == 0) {
                this.extractPropertyMetadata(columnQualifier, columnVisibility, value);
                continue;
            }
            if (this.getVisibilitySignal().equals(columnFamily.toString())) {
                this.visibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
            }
            this.processColumn(col.getKey(), col.getValue());
        }
        if (this.visibility == null) {
            return null;
        }
        return this.makeElement(includeHidden);
    }

    protected Text getColumnFamily(Key key) {
        return this.inflate(key.getColumnFamily());
    }

    protected Text getColumnQualifier(Key key) {
        return this.inflate(key.getColumnQualifier());
    }

    private Text inflate(Text text) {
        return new Text(this.getGraph().getNameSubstitutionStrategy().inflate(text.toString()));
    }

    protected abstract void processColumn(Key var1, Value var2);

    protected abstract String getIdFromRowKey(String var1);

    protected abstract String getVisibilitySignal();

    protected abstract T makeElement(boolean var1);

    protected String getId() {
        return this.id;
    }

    protected Visibility getVisibility() {
        return this.visibility;
    }

    public AccumuloGraph getGraph() {
        return this.graph;
    }

    protected Set<Visibility> getHiddenVisibilities() {
        return this.hiddenVisibilities;
    }

    protected List<Property> getProperties(boolean includeHidden) {
        ArrayList<Property> results = new ArrayList<Property>(this.propertyValues.size());
        for (Map.Entry<String, byte[]> propertyValueEntry : this.propertyValues.entrySet()) {
            String key = propertyValueEntry.getKey();
            String propertyKey = this.getPropertyKeyFromColumnQualifier(this.propertyColumnQualifier.get(key));
            String propertyName = this.propertyNames.get(key);
            byte[] propertyValue = propertyValueEntry.getValue();
            Visibility propertyVisibility = this.propertyVisibilities.get(key);
            long propertyTimestamp = this.propertyTimestamps.get(key);
            Set<Visibility> propertyHiddenVisibilities = this.getPropertyHiddenVisibilities(propertyKey, propertyName, propertyVisibility);
            if (!includeHidden && this.isHidden(propertyKey, propertyName, propertyVisibility)) continue;
            LazyPropertyMetadata metadata = this.propertyMetadata.get(key);
            LazyMutableProperty property = new LazyMutableProperty(this.getGraph(), this.getGraph().getValueSerializer(), propertyKey, propertyName, propertyValue, metadata, propertyHiddenVisibilities, propertyVisibility, propertyTimestamp);
            results.add((Property)property);
        }
        return results;
    }

    private Set<Visibility> getPropertyHiddenVisibilities(String propertyKey, String propertyName, Visibility propertyVisibility) {
        HashSet<Visibility> hiddenVisibilities = null;
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            if (hiddenVisibilities == null) {
                hiddenVisibilities = new HashSet<Visibility>();
            }
            hiddenVisibilities.add(hiddenProperty.getHiddenVisibility());
        }
        return hiddenVisibilities;
    }

    private boolean isHidden(String propertyKey, String propertyName, Visibility visibility) {
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, visibility)) continue;
            return true;
        }
        return false;
    }

    private void extractPropertyHidden(Text columnQualifier, ColumnVisibility columnVisibility) {
        String columnQualifierStr = columnQualifier.toString();
        int nameKeySep = columnQualifierStr.indexOf("\u001f");
        if (nameKeySep < 0) {
            throw new VertexiumException("Invalid property hidden column qualifier");
        }
        int keyVisSep = columnQualifierStr.indexOf("\u001f", nameKeySep + 1);
        if (nameKeySep < 0) {
            throw new VertexiumException("Invalid property hidden column qualifier");
        }
        String name = columnQualifierStr.substring(0, nameKeySep);
        String key = columnQualifierStr.substring(nameKeySep + 1, keyVisSep);
        String vis = columnQualifierStr.substring(keyVisSep + 1);
        this.hiddenProperties.add(new HiddenProperty(key, name, vis, AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility)));
    }

    private void extractPropertyMetadata(Text columnQualifier, ColumnVisibility columnVisibility, Value value) {
        Visibility metadataVisibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
        String columnQualifierString = columnQualifier.toString();
        int i = columnQualifierString.lastIndexOf("\u001f");
        if (i < 0) {
            throw new VertexiumException("Invalid property metadata column qualifier: " + columnQualifierString);
        }
        String propertyKey = columnQualifierString.substring(0, i);
        String metadataKey = columnQualifierString.substring(i + 1);
        LazyPropertyMetadata lazyPropertyMetadata = this.getOrCreatePropertyMetadata(propertyKey);
        lazyPropertyMetadata.add(metadataKey, metadataVisibility, value.get());
    }

    private LazyPropertyMetadata getOrCreatePropertyMetadata(String propertyKey) {
        LazyPropertyMetadata lazyPropertyMetadata = this.propertyMetadata.get(propertyKey);
        if (lazyPropertyMetadata == null) {
            lazyPropertyMetadata = new LazyPropertyMetadata();
            this.propertyMetadata.put(propertyKey, lazyPropertyMetadata);
        }
        return lazyPropertyMetadata;
    }

    private void extractPropertyData(Map.Entry<Key, Value> column, ColumnVisibility columnVisibility) {
        Text columnQualifier = this.getColumnQualifier(column.getKey());
        Value value = column.getValue();
        Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
        String propertyName = this.getPropertyNameFromColumnQualifier(columnQualifier.toString());
        String key = this.propertyColumnQualifierToKey(columnQualifier, visibility);
        long timestamp = column.getKey().getTimestamp();
        this.propertyColumnQualifier.put(key, columnQualifier.toString());
        this.propertyNames.put(key, propertyName);
        this.propertyValues.put(key, value.get());
        this.propertyVisibilities.put(key, visibility);
        this.propertyTimestamps.put(key, timestamp);
    }

    private String propertyColumnQualifierToKey(Text columnQualifier, Visibility visibility) {
        return columnQualifier.toString() + "\u001f" + visibility.toString();
    }

    private String getPropertyNameFromColumnQualifier(String columnQualifier) {
        int i = columnQualifier.indexOf("\u001f");
        if (i < 0) {
            throw new VertexiumException("Invalid property column qualifier");
        }
        return columnQualifier.substring(0, i);
    }

    private String getPropertyKeyFromColumnQualifier(String columnQualifier) {
        int i = columnQualifier.indexOf("\u001f");
        if (i < 0) {
            throw new VertexiumException("Invalid property column qualifier");
        }
        return columnQualifier.substring(i + 1);
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    private static class HiddenProperty {
        private final String key;
        private final String name;
        private final String visibility;
        private final Visibility hiddenVisibility;

        public HiddenProperty(String key, String name, String visibility, Visibility hiddenVisibility) {
            this.key = key;
            this.name = name;
            this.visibility = visibility;
            this.hiddenVisibility = hiddenVisibility;
        }

        public boolean matches(String propertyKey, String propertyName, Visibility visibility) {
            return propertyKey.equals(this.key) && propertyName.equals(this.name) && visibility.getVisibilityString().equals(this.visibility);
        }

        public Visibility getHiddenVisibility() {
            return this.hiddenVisibility;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiddenProperty that = (HiddenProperty)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.visibility != null ? !this.visibility.equals(that.visibility) : that.visibility != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "HiddenProperty{key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", visibility='" + this.visibility + '\'' + '}';
        }
    }
}

