/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.DateOnly;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Metadata;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloEdge;
import org.neolumin.vertexium.accumulo.AccumuloElement;
import org.neolumin.vertexium.accumulo.AccumuloVertex;
import org.neolumin.vertexium.accumulo.EdgeInfo;
import org.neolumin.vertexium.accumulo.HdfsLargeDataStore;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueHdfsRef;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueRef;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueTableRef;
import org.neolumin.vertexium.accumulo.serializer.ValueSerializer;
import org.neolumin.vertexium.mutation.PropertyPropertyRemoveMutation;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;
import org.neolumin.vertexium.property.StreamingPropertyValue;
import org.neolumin.vertexium.util.LimitOutputStream;
import org.neolumin.vertexium.util.Preconditions;
import org.neolumin.vertexium.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElementMutationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementMutationBuilder.class);
    private static final Text EMPTY_TEXT = new Text("");
    public static final Value EMPTY_VALUE = new Value(new byte[0]);
    public static final String VALUE_SEPARATOR = "\u001f";
    private final FileSystem fileSystem;
    private final ValueSerializer valueSerializer;
    private final long maxStreamingPropertyValueTableDataSize;
    private final String dataDir;

    protected ElementMutationBuilder(FileSystem fileSystem, ValueSerializer valueSerializer, long maxStreamingPropertyValueTableDataSize, String dataDir) {
        this.fileSystem = fileSystem;
        this.valueSerializer = valueSerializer;
        this.maxStreamingPropertyValueTableDataSize = maxStreamingPropertyValueTableDataSize;
        this.dataDir = dataDir;
    }

    public void saveVertex(AccumuloVertex vertex) {
        Mutation m = this.createMutationForVertex(vertex);
        this.saveVertexMutation(m);
    }

    protected abstract void saveVertexMutation(Mutation var1);

    private Mutation createMutationForVertex(AccumuloVertex vertex) {
        String vertexRowKey = "V" + vertex.getId();
        Mutation m = new Mutation((CharSequence)vertexRowKey);
        m.put(AccumuloVertex.CF_SIGNAL, EMPTY_TEXT, this.visibilityToAccumuloVisibility(vertex.getVisibility()), EMPTY_VALUE);
        for (PropertyRemoveMutation propertyRemoveMutation : vertex.getPropertyRemoveMutations()) {
            this.addPropertyRemoveToMutation(m, propertyRemoveMutation);
        }
        for (Property property : vertex.getProperties()) {
            this.addPropertyToMutation(m, vertexRowKey, property);
        }
        return m;
    }

    public void saveEdge(AccumuloEdge edge) {
        ColumnVisibility edgeColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        Mutation m = this.createMutationForEdge(edge, edgeColumnVisibility);
        this.saveEdgeMutation(m);
        String edgeLabel = edge.getNewEdgeLabel() != null ? edge.getNewEdgeLabel() : edge.getLabel();
        this.saveEdgeInfoOnVertex(edge, edgeLabel, edgeColumnVisibility);
    }

    private void saveEdgeInfoOnVertex(AccumuloEdge edge, String edgeLabel, ColumnVisibility edgeColumnVisibility) {
        Mutation addEdgeToOutMutation = new Mutation((CharSequence)("V" + edge.getVertexId(Direction.OUT)));
        EdgeInfo edgeInfo = new EdgeInfo(edgeLabel, edge.getVertexId(Direction.IN));
        addEdgeToOutMutation.put(AccumuloVertex.CF_OUT_EDGE, new Text(edge.getId()), edgeColumnVisibility, edgeInfo.toValue());
        this.saveVertexMutation(addEdgeToOutMutation);
        Mutation addEdgeToInMutation = new Mutation((CharSequence)("V" + edge.getVertexId(Direction.IN)));
        edgeInfo = new EdgeInfo(edgeLabel, edge.getVertexId(Direction.OUT));
        addEdgeToInMutation.put(AccumuloVertex.CF_IN_EDGE, new Text(edge.getId()), edgeColumnVisibility, edgeInfo.toValue());
        this.saveVertexMutation(addEdgeToInMutation);
    }

    public void alterEdgeLabel(AccumuloEdge edge, String newEdgeLabel) {
        ColumnVisibility edgeColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        Mutation m = this.createAlterEdgeLabelMutation(edge, newEdgeLabel, edgeColumnVisibility);
        this.saveEdgeMutation(m);
        this.saveEdgeInfoOnVertex(edge, newEdgeLabel, edgeColumnVisibility);
    }

    private ColumnVisibility visibilityToAccumuloVisibility(Visibility visibility) {
        return new ColumnVisibility(visibility.getVisibilityString());
    }

    protected abstract void saveEdgeMutation(Mutation var1);

    private Mutation createMutationForEdge(AccumuloEdge edge, ColumnVisibility edgeColumnVisibility) {
        String edgeRowKey = "E" + edge.getId();
        Mutation m = new Mutation((CharSequence)edgeRowKey);
        String edgeLabel = edge.getLabel();
        if (edge.getNewEdgeLabel() != null) {
            edgeLabel = edge.getNewEdgeLabel();
            m.putDelete(AccumuloEdge.CF_SIGNAL, new Text(edge.getLabel()), edgeColumnVisibility);
        }
        m.put(AccumuloEdge.CF_SIGNAL, new Text(edgeLabel), edgeColumnVisibility, EMPTY_VALUE);
        m.put(AccumuloEdge.CF_OUT_VERTEX, new Text(edge.getVertexId(Direction.OUT)), edgeColumnVisibility, EMPTY_VALUE);
        m.put(AccumuloEdge.CF_IN_VERTEX, new Text(edge.getVertexId(Direction.IN)), edgeColumnVisibility, EMPTY_VALUE);
        for (PropertyRemoveMutation propertyRemoveMutation : edge.getPropertyRemoveMutations()) {
            this.addPropertyRemoveToMutation(m, propertyRemoveMutation);
        }
        for (Property property : edge.getProperties()) {
            this.addPropertyToMutation(m, edgeRowKey, property);
        }
        return m;
    }

    private Mutation createAlterEdgeLabelMutation(AccumuloEdge edge, String newEdgeLabel, ColumnVisibility edgeColumnVisibility) {
        String edgeRowKey = "E" + edge.getId();
        Mutation m = new Mutation((CharSequence)edgeRowKey);
        m.putDelete(AccumuloEdge.CF_SIGNAL, new Text(edge.getLabel()), edgeColumnVisibility);
        m.put(AccumuloEdge.CF_SIGNAL, new Text(newEdgeLabel), edgeColumnVisibility, EMPTY_VALUE);
        return m;
    }

    public boolean alterElementVisibility(Mutation m, AccumuloElement element, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = this.visibilityToAccumuloVisibility(element.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = this.visibilityToAccumuloVisibility(newVisibility))) {
            return false;
        }
        if (element instanceof AccumuloEdge) {
            AccumuloEdge edge = (AccumuloEdge)element;
            m.putDelete(AccumuloEdge.CF_SIGNAL, new Text(edge.getLabel()), currentColumnVisibility);
            m.put(AccumuloEdge.CF_SIGNAL, new Text(edge.getLabel()), newColumnVisibility, EMPTY_VALUE);
            m.putDelete(AccumuloEdge.CF_OUT_VERTEX, new Text(edge.getVertexId(Direction.OUT)), currentColumnVisibility);
            m.put(AccumuloEdge.CF_OUT_VERTEX, new Text(edge.getVertexId(Direction.OUT)), newColumnVisibility, EMPTY_VALUE);
            m.putDelete(AccumuloEdge.CF_IN_VERTEX, new Text(edge.getVertexId(Direction.IN)), currentColumnVisibility);
            m.put(AccumuloEdge.CF_IN_VERTEX, new Text(edge.getVertexId(Direction.IN)), newColumnVisibility, EMPTY_VALUE);
        } else if (element instanceof AccumuloVertex) {
            m.putDelete(AccumuloVertex.CF_SIGNAL, EMPTY_TEXT, currentColumnVisibility);
            m.put(AccumuloVertex.CF_SIGNAL, EMPTY_TEXT, newColumnVisibility, EMPTY_VALUE);
        } else {
            throw new IllegalArgumentException("Invalid element type: " + element);
        }
        return true;
    }

    public boolean alterEdgeVertexOutVertex(Mutation mvout, Edge edge, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = this.visibilityToAccumuloVisibility(newVisibility))) {
            return false;
        }
        EdgeInfo edgeInfo = new EdgeInfo(edge.getLabel(), edge.getVertexId(Direction.IN));
        mvout.putDelete(AccumuloVertex.CF_OUT_EDGE, new Text(edge.getId()), currentColumnVisibility);
        mvout.put(AccumuloVertex.CF_OUT_EDGE, new Text(edge.getId()), newColumnVisibility, edgeInfo.toValue());
        return true;
    }

    public boolean alterEdgeVertexInVertex(Mutation mvin, Edge edge, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = this.visibilityToAccumuloVisibility(newVisibility))) {
            return false;
        }
        EdgeInfo edgeInfo = new EdgeInfo(edge.getLabel(), edge.getVertexId(Direction.OUT));
        mvin.putDelete(AccumuloVertex.CF_IN_EDGE, new Text(edge.getId()), currentColumnVisibility);
        mvin.put(AccumuloVertex.CF_IN_EDGE, new Text(edge.getId()), newColumnVisibility, edgeInfo.toValue());
        return true;
    }

    public void addPropertyToMutation(Mutation m, String rowKey, Property property) {
        Text columnQualifier = this.getPropertyColumnQualifier(property);
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(property.getVisibility());
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            propertyValue = this.saveStreamingPropertyValue(rowKey, property, (StreamingPropertyValue)propertyValue);
        }
        if (propertyValue instanceof DateOnly) {
            propertyValue = ((DateOnly)propertyValue).getDate();
        }
        Value value = new Value(this.valueSerializer.objectToValue(propertyValue));
        m.put(AccumuloElement.CF_PROPERTY, columnQualifier, columnVisibility, value);
        this.addPropertyMetadataToMutation(m, property);
    }

    public void addPropertyRemoveToMutation(Mutation m, PropertyRemoveMutation propertyRemove) {
        Text columnQualifier = this.getPropertyColumnQualifier(propertyRemove);
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(propertyRemove.getVisibility());
        m.putDelete(AccumuloElement.CF_PROPERTY, columnQualifier, columnVisibility);
        this.addPropertyRemoveMetadataToMutation(m, propertyRemove);
    }

    public void addPropertyMetadataToMutation(Mutation m, Property property) {
        Metadata metadata = property.getMetadata();
        for (Metadata.Entry metadataItem : metadata.entrySet()) {
            Text columnQualifier = this.getPropertyMetadataColumnQualifier(property, metadataItem.getKey());
            ColumnVisibility metadataVisibility = this.visibilityToAccumuloVisibility(metadataItem.getVisibility());
            if (metadataItem.getValue() == null) {
                m.putDelete(AccumuloElement.CF_PROPERTY_METADATA, columnQualifier, metadataVisibility);
                continue;
            }
            Value metadataValue = new Value(this.valueSerializer.objectToValue(metadataItem.getValue()));
            m.put(AccumuloElement.CF_PROPERTY_METADATA, columnQualifier, metadataVisibility, metadataValue);
        }
    }

    public void addPropertyRemoveMetadataToMutation(Mutation m, PropertyRemoveMutation propertyRemoveMutation) {
        if (propertyRemoveMutation instanceof PropertyPropertyRemoveMutation) {
            Property property = ((PropertyPropertyRemoveMutation)propertyRemoveMutation).getProperty();
            Metadata metadata = property.getMetadata();
            for (Metadata.Entry metadataItem : metadata.entrySet()) {
                Text columnQualifier = this.getPropertyMetadataColumnQualifier(property, metadataItem.getKey());
                ColumnVisibility metadataVisibility = this.visibilityToAccumuloVisibility(metadataItem.getVisibility());
                m.putDelete(AccumuloElement.CF_PROPERTY_METADATA, columnQualifier, metadataVisibility);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamingPropertyValueRef saveStreamingPropertyValue(String rowKey, Property property, StreamingPropertyValue propertyValue) {
        try {
            HdfsLargeDataStore largeDataStore = new HdfsLargeDataStore(this.fileSystem, this.dataDir, rowKey, property);
            try (LimitOutputStream out = new LimitOutputStream((LimitOutputStream.LargeDataStore)largeDataStore, this.maxStreamingPropertyValueTableDataSize);){
                StreamUtils.copy((InputStream)propertyValue.getInputStream(), (OutputStream)out);
            }
            if (out.hasExceededSizeLimit()) {
                LOGGER.debug(String.format("saved large file to \"%s\" (length: %d)", largeDataStore.getFullHdfsPath(), out.getLength()));
                return new StreamingPropertyValueHdfsRef(largeDataStore.getRelativeFileName(), propertyValue);
            }
            return this.saveStreamingPropertyValueSmall(rowKey, property, out.getSmall(), propertyValue);
        }
        catch (IOException ex) {
            throw new VertexiumException((Exception)ex);
        }
    }

    public void addPropertyRemoveToMutation(Mutation m, Property property) {
        Preconditions.checkNotNull((Object)m, (Object)"mutation cannot be null");
        Preconditions.checkNotNull((Object)property, (Object)"property cannot be null");
        Text columnQualifier = this.getPropertyColumnQualifier(property);
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(property.getVisibility());
        m.putDelete(AccumuloElement.CF_PROPERTY, columnQualifier, columnVisibility);
        for (Metadata.Entry metadataEntry : property.getMetadata().entrySet()) {
            Text metadataEntryColumnQualifier = this.getPropertyMetadataColumnQualifier(property, metadataEntry.getKey());
            ColumnVisibility metadataEntryVisibility = this.visibilityToAccumuloVisibility(metadataEntry.getVisibility());
            m.putDelete(AccumuloElement.CF_PROPERTY_METADATA, metadataEntryColumnQualifier, metadataEntryVisibility);
        }
    }

    private StreamingPropertyValueRef saveStreamingPropertyValueSmall(String rowKey, Property property, byte[] data, StreamingPropertyValue propertyValue) {
        String dataRowKey = this.createTableDataRowKey(rowKey, property);
        Mutation dataMutation = new Mutation((CharSequence)dataRowKey);
        dataMutation.put(EMPTY_TEXT, EMPTY_TEXT, new Value(data));
        this.saveDataMutation(dataMutation);
        return new StreamingPropertyValueTableRef(dataRowKey, propertyValue, data);
    }

    protected abstract void saveDataMutation(Mutation var1);

    protected Text getPropertyColumnQualifier(PropertyRemoveMutation propertyRemove) {
        return ElementMutationBuilder.getValueSeparatedJoined(propertyRemove.getName(), propertyRemove.getKey());
    }

    protected Text getPropertyColumnQualifier(Property property) {
        return ElementMutationBuilder.getValueSeparatedJoined(property.getName(), property.getKey());
    }

    protected Text getPropertyMetadataColumnQualifier(Property property, String metadataKey) {
        return ElementMutationBuilder.getValueSeparatedJoined(property.getName(), property.getKey(), property.getVisibility().getVisibilityString(), metadataKey);
    }

    protected static Text getPropertyColumnQualifierWithVisibilityString(Property property) {
        return ElementMutationBuilder.getValueSeparatedJoined(property.getName(), property.getKey(), property.getVisibility().getVisibilityString());
    }

    protected static Text getValueSeparatedJoined(String ... values) {
        return new Text(ElementMutationBuilder.getStringValueSeparatorJoined(values));
    }

    protected static String getStringValueSeparatorJoined(String ... values) {
        return Joiner.on((String)VALUE_SEPARATOR).join((Object[])values);
    }

    private String createTableDataRowKey(String rowKey, Property property) {
        return ElementMutationBuilder.getStringValueSeparatorJoined("D" + rowKey, property.getName(), property.getKey());
    }
}

