/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.util.HashSet;
import java.util.Set;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.HasTimestamp;
import org.neolumin.vertexium.Metadata;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.LazyPropertyMetadata;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueRef;
import org.neolumin.vertexium.accumulo.serializer.ValueSerializer;
import org.neolumin.vertexium.property.MutableProperty;

public class LazyMutableProperty
extends MutableProperty
implements HasTimestamp {
    private final AccumuloGraph graph;
    private final ValueSerializer valueSerializer;
    private final String propertyKey;
    private final String propertyName;
    private final long timestamp;
    private Set<Visibility> hiddenVisibilities;
    private byte[] propertyValue;
    private final LazyPropertyMetadata metadata;
    private Visibility visibility;
    private transient Object cachedPropertyValue;
    private transient Metadata cachedMetadata;

    public LazyMutableProperty(AccumuloGraph graph, ValueSerializer valueSerializer, String propertyKey, String propertyName, byte[] propertyValue, LazyPropertyMetadata metadata, Set<Visibility> hiddenVisibilities, Visibility visibility, long timestamp) {
        this.graph = graph;
        this.valueSerializer = valueSerializer;
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.metadata = metadata;
        this.visibility = visibility;
        this.hiddenVisibilities = hiddenVisibilities;
        this.timestamp = timestamp;
    }

    public void setValue(Object value) {
        this.cachedPropertyValue = value;
        this.propertyValue = null;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void addHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.add(visibility);
    }

    public void removeHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.remove(visibility);
    }

    protected void addMetadata(String key, Object value, Visibility visibility) {
        this.getMetadata().add(key, value, visibility);
    }

    protected void removeMetadata(String key, Visibility visibility) {
        this.getMetadata().remove(key, visibility);
    }

    public String getKey() {
        return this.propertyKey;
    }

    public String getName() {
        return this.propertyName;
    }

    public Object getValue() {
        if (this.cachedPropertyValue == null) {
            if (this.propertyValue == null || this.propertyValue.length == 0) {
                return null;
            }
            this.cachedPropertyValue = this.valueSerializer.valueToObject(this.propertyValue);
            if (this.cachedPropertyValue instanceof StreamingPropertyValueRef) {
                this.cachedPropertyValue = ((StreamingPropertyValueRef)this.cachedPropertyValue).toStreamingPropertyValue(this.graph);
            }
        }
        return this.cachedPropertyValue;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Metadata getMetadata() {
        if (this.cachedMetadata == null) {
            this.cachedMetadata = this.metadata == null ? new Metadata() : this.metadata.toMetadata(this.valueSerializer);
        }
        return this.cachedMetadata;
    }

    public Iterable<Visibility> getHiddenVisibilities() {
        return this.hiddenVisibilities;
    }

    public boolean isHidden(Authorizations authorizations) {
        if (this.hiddenVisibilities != null) {
            for (Visibility v : this.getHiddenVisibilities()) {
                if (!authorizations.canRead(v)) continue;
                return true;
            }
        }
        return false;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

