/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.neolumin.vertexium.util.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubstitutionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSubstitutionUtils.class);
    public static final String SUBSTITUTION_MAP_PREFIX = "substitution";
    public static final String KEY_IDENTIFIER = "key";
    public static final String VALUE_IDENTIFIER = "value";

    public static List<Pair<String, String>> getSubstitutionList(Map configuration) {
        Map substitutionMap = Maps.newHashMap();
        for (Object objKey : configuration.keySet()) {
            String key = objKey.toString();
            if (!key.startsWith("substitution.")) continue;
            List parts = Lists.newArrayList((Collection)IterableUtils.toList((Iterable)Splitter.on((char)'.').split((CharSequence)key)));
            String pairKey = (String)parts.get(parts.size() - 2);
            String valueType = (String)parts.get(parts.size() - 1);
            if (!substitutionMap.containsKey(pairKey)) {
                substitutionMap.put(pairKey, new MutablePair());
            }
            MutablePair pair = (MutablePair)substitutionMap.get(pairKey);
            if (KEY_IDENTIFIER.equals(valueType)) {
                pair.setLeft((Object)configuration.get(key).toString());
                continue;
            }
            if (!VALUE_IDENTIFIER.equals(valueType)) continue;
            pair.setValue((Object)configuration.get(key).toString());
        }
        List keys = Lists.newArrayList(substitutionMap.keySet());
        Collections.sort(keys);
        List finalMap = Lists.newArrayList();
        for (String key : keys) {
            Pair pair = (Pair)substitutionMap.get(key);
            finalMap.add(pair);
            LOGGER.info(String.format("Using substitution %s -> %s", pair.getKey(), pair.getValue()));
        }
        return finalMap;
    }
}

