/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.StreamingPropertyValueTableRef;
import org.neolumin.vertexium.property.StreamingPropertyValue;

class StreamingPropertyValueTable
extends StreamingPropertyValue {
    private final AccumuloGraph graph;
    private final String dataRowKey;
    private transient byte[] data;

    StreamingPropertyValueTable(AccumuloGraph graph, String dataRowKey, StreamingPropertyValueTableRef valueRef) {
        super(null, valueRef.getValueType());
        this.store(valueRef.isStore());
        this.searchIndex(valueRef.isSearchIndex());
        this.graph = graph;
        this.dataRowKey = dataRowKey;
        this.data = valueRef.getData();
    }

    public long getLength() {
        this.ensureDataLoaded();
        return this.data.length;
    }

    public InputStream getInputStream() {
        this.ensureDataLoaded();
        return new ByteArrayInputStream(this.data);
    }

    private void ensureDataLoaded() {
        if (this.data == null) {
            this.data = this.graph.streamingPropertyValueTableData(this.dataRowKey);
        }
    }
}

