/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.AccumuloVertex;
import org.neolumin.vertexium.accumulo.EdgeInfo;
import org.neolumin.vertexium.accumulo.ElementMaker;

public class VertexMaker
extends ElementMaker<Vertex> {
    private static final String VISIBILITY_SIGNAL = AccumuloVertex.CF_SIGNAL.toString();
    private final AccumuloGraph graph;
    private final Map<String, EdgeInfo> outEdges = new HashMap<String, EdgeInfo>();
    private final Map<String, EdgeInfo> inEdges = new HashMap<String, EdgeInfo>();
    private final Set<String> hiddenEdges = new HashSet<String>();
    private long timestamp;

    public VertexMaker(AccumuloGraph graph, Iterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        super(graph, row, authorizations);
        this.graph = graph;
    }

    @Override
    protected void processColumn(Key key, Value value) {
        Text columnFamily = this.getColumnFamily(key);
        Text columnQualifier = this.getColumnQualifier(key);
        if (AccumuloVertex.CF_SIGNAL.compareTo((BinaryComparable)columnFamily) == 0) {
            this.timestamp = key.getTimestamp();
            return;
        }
        if (AccumuloVertex.CF_OUT_EDGE_HIDDEN.compareTo((BinaryComparable)columnFamily) == 0 || AccumuloVertex.CF_IN_EDGE_HIDDEN.compareTo((BinaryComparable)columnFamily) == 0) {
            String edgeId = columnQualifier.toString();
            this.hiddenEdges.add(edgeId);
            return;
        }
        if (AccumuloVertex.CF_OUT_EDGE.compareTo((BinaryComparable)columnFamily) == 0) {
            String edgeId = columnQualifier.toString();
            EdgeInfo edgeInfo = EdgeInfo.parse(value);
            this.outEdges.put(edgeId, edgeInfo);
            return;
        }
        if (AccumuloVertex.CF_IN_EDGE.compareTo((BinaryComparable)columnFamily) == 0) {
            String edgeId = columnQualifier.toString();
            EdgeInfo edgeInfo = EdgeInfo.parse(value);
            this.inEdges.put(edgeId, edgeInfo);
            return;
        }
    }

    @Override
    protected String getIdFromRowKey(String rowKey) throws VertexiumException {
        if (rowKey.startsWith("V")) {
            return rowKey.substring("V".length());
        }
        throw new VertexiumException("Invalid row key for vertex: " + rowKey);
    }

    @Override
    protected String getVisibilitySignal() {
        return VISIBILITY_SIGNAL;
    }

    @Override
    protected Vertex makeElement(boolean includeHidden) {
        if (!includeHidden) {
            for (String edgeId : this.hiddenEdges) {
                this.inEdges.remove(edgeId);
                this.outEdges.remove(edgeId);
            }
        }
        return new AccumuloVertex(this.graph, this.getId(), this.getVisibility(), this.getProperties(includeHidden), null, this.getHiddenVisibilities(), this.inEdges, this.outEdges, this.getAuthorizations(), this.timestamp);
    }
}

