/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo.mapreduce;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.GraphFactory;
import org.neolumin.vertexium.accumulo.AccumuloAuthorizations;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.mapreduce.VertexiumMRUtils;
import org.neolumin.vertexium.util.MapUtils;

public abstract class AccumuloElementInputFormatBase<TValue extends Element>
extends InputFormat<Text, TValue> {
    private final AccumuloRowInputFormat accumuloInputFormat = new AccumuloRowInputFormat();

    protected static void setInputInfo(Job job, String instanceName, String zooKeepers, String principal, AuthenticationToken token, String[] authorizations, String tableName) throws AccumuloSecurityException {
        AccumuloRowInputFormat.setInputTableName((Job)job, (String)tableName);
        AccumuloRowInputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        AccumuloRowInputFormat.setZooKeeperInstance((Job)job, (String)instanceName, (String)zooKeepers);
        AccumuloRowInputFormat.setScanAuthorizations((Job)job, (org.apache.accumulo.core.security.Authorizations)new org.apache.accumulo.core.security.Authorizations(authorizations));
        job.getConfiguration().setStrings("authorizations", authorizations);
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.accumuloInputFormat.getSplits(jobContext);
    }

    public RecordReader<Text, TValue> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        final RecordReader reader = this.accumuloInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        return new RecordReader<Text, TValue>(){
            public AccumuloGraph graph;
            public Authorizations authorizations;

            public void initialize(InputSplit inputSplit, TaskAttemptContext ctx) throws IOException, InterruptedException {
                reader.initialize(inputSplit, ctx);
                Map configurationMap = VertexiumMRUtils.toMap(ctx.getConfiguration());
                this.graph = (AccumuloGraph)new GraphFactory().createGraph(MapUtils.getAllWithPrefix((Map)configurationMap, (String)"graph"));
                this.authorizations = new AccumuloAuthorizations(ctx.getConfiguration().getStrings("authorizations"));
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return reader.nextKeyValue();
            }

            public Text getCurrentKey() throws IOException, InterruptedException {
                return (Text)reader.getCurrentKey();
            }

            public TValue getCurrentValue() throws IOException, InterruptedException {
                PeekingIterator row = (PeekingIterator)reader.getCurrentValue();
                return AccumuloElementInputFormatBase.this.createElementFromRow(this.graph, (PeekingIterator<Map.Entry<Key, Value>>)row, this.authorizations);
            }

            public float getProgress() throws IOException, InterruptedException {
                return reader.getProgress();
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }

    protected abstract TValue createElementFromRow(AccumuloGraph var1, PeekingIterator<Map.Entry<Key, Value>> var2, Authorizations var3);
}

