/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.accumulo.mapreduce;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.EdgeBuilder;
import org.neolumin.vertexium.EdgeBuilderByVertexId;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexBuilder;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.accumulo.AccumuloEdge;
import org.neolumin.vertexium.accumulo.AccumuloGraph;
import org.neolumin.vertexium.accumulo.AccumuloGraphConfiguration;
import org.neolumin.vertexium.accumulo.AccumuloVertex;
import org.neolumin.vertexium.accumulo.ElementMutationBuilder;
import org.neolumin.vertexium.accumulo.mapreduce.ElementMapperGraph;
import org.neolumin.vertexium.accumulo.serializer.ValueSerializer;
import org.neolumin.vertexium.id.IdGenerator;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;

public abstract class ElementMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    public static final String GRAPH_CONFIG_PREFIX = "graphConfigPrefix";
    private ElementMutationBuilder elementMutationBuilder;
    private ElementMapperGraph graph;

    protected void setup(final Mapper.Context context) throws IOException, InterruptedException {
        FileSystem fileSystem;
        super.setup(context);
        String configPrefix = context.getConfiguration().get(GRAPH_CONFIG_PREFIX, "");
        AccumuloGraphConfiguration accumuloGraphConfiguration = new AccumuloGraphConfiguration(context.getConfiguration(), configPrefix);
        String tableNamePrefix = accumuloGraphConfiguration.getTableNamePrefix();
        final Text edgesTableName = new Text(AccumuloGraph.getEdgesTableName(tableNamePrefix));
        final Text dataTableName = new Text(AccumuloGraph.getDataTableName(tableNamePrefix));
        final Text verticesTableName = new Text(AccumuloGraph.getVerticesTableName(tableNamePrefix));
        ValueSerializer valueSerializer = accumuloGraphConfiguration.createValueSerializer();
        long maxStreamingPropertyValueTableDataSize = accumuloGraphConfiguration.getMaxStreamingPropertyValueTableDataSize();
        String dataDir = accumuloGraphConfiguration.getDataDir();
        try {
            fileSystem = accumuloGraphConfiguration.createFileSystem();
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not initialize", e);
        }
        this.elementMutationBuilder = new ElementMutationBuilder(fileSystem, valueSerializer, maxStreamingPropertyValueTableDataSize, dataDir){

            @Override
            protected void saveVertexMutation(Mutation m) {
                try {
                    ElementMapper.this.saveVertexMutation(context, verticesTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save vertex", e);
                }
            }

            @Override
            protected void saveEdgeMutation(Mutation m) {
                try {
                    ElementMapper.this.saveEdgeMutation(context, edgesTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save edge", e);
                }
            }

            @Override
            protected void saveDataMutation(Mutation m) {
                try {
                    ElementMapper.this.saveDataMutation(context, dataTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save data", e);
                }
            }
        };
        this.graph = new ElementMapperGraph(this);
    }

    protected abstract void saveDataMutation(Mapper.Context var1, Text var2, Mutation var3) throws IOException, InterruptedException;

    protected abstract void saveEdgeMutation(Mapper.Context var1, Text var2, Mutation var3) throws IOException, InterruptedException;

    protected abstract void saveVertexMutation(Mapper.Context var1, Text var2, Mutation var3) throws IOException, InterruptedException;

    public VertexBuilder prepareVertex(Vertex vertex) {
        return this.prepareVertex(vertex.getId(), vertex.getVisibility());
    }

    public VertexBuilder prepareVertex(String vertexId, Visibility visibility) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        return new VertexBuilder(vertexId, visibility){

            public Vertex save(Authorizations authorizations) {
                AccumuloVertex vertex = new AccumuloVertex(null, this.getVertexId(), this.getVisibility(), (Iterable<Property>)this.getProperties(), (Iterable<PropertyRemoveMutation>)this.getPropertyRemoves(), null, authorizations, System.currentTimeMillis());
                ElementMapper.this.elementMutationBuilder.saveVertex(vertex);
                return vertex;
            }
        };
    }

    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, visibility).save(authorizations);
    }

    public EdgeBuilderByVertexId prepareEdge(Edge edge) {
        return this.prepareEdge(edge.getId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel(), edge.getVisibility());
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilderByVertexId(edgeId, outVertexId, inVertexId, label, visibility){

            public Edge save(Authorizations authorizations) {
                AccumuloEdge edge = new AccumuloEdge(null, this.getEdgeId(), this.getOutVertexId(), this.getInVertexId(), this.getLabel(), this.getNewEdgeLabel(), this.getVisibility(), this.getProperties(), this.getPropertyRemoves(), null, authorizations, System.currentTimeMillis());
                ElementMapper.this.elementMutationBuilder.saveEdge(edge);
                return edge;
            }
        };
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilder(edgeId, outVertex, inVertex, label, visibility){

            public Edge save(Authorizations authorizations) {
                AccumuloEdge edge = new AccumuloEdge(null, this.getEdgeId(), this.getOutVertex().getId(), this.getInVertex().getId(), this.getLabel(), this.getNewEdgeLabel(), this.getVisibility(), this.getProperties(), this.getPropertyRemoves(), null, authorizations, System.currentTimeMillis());
                ElementMapper.this.elementMutationBuilder.saveEdge(edge);
                return edge;
            }
        };
    }

    public abstract IdGenerator getIdGenerator();

    public Graph getGraph() {
        return this.graph;
    }
}

