/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.blueprints;

import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.blueprints.VertexiumBlueprintsGraph;
import org.neolumin.vertexium.util.MapUtils;

public abstract class VertexiumBlueprintsFactory {
    public static final String STORAGE_CONFIG_PREFIX = "storage";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VertexiumBlueprintsGraph open(String configFileName) throws Exception {
        try (FileInputStream in = new FileInputStream(configFileName);){
            Properties properties = new Properties();
            properties.load(in);
            String storageFactoryClassName = properties.getProperty(STORAGE_CONFIG_PREFIX);
            Map storageConfig = MapUtils.getAllWithPrefix((Map)properties, (String)STORAGE_CONFIG_PREFIX);
            VertexiumBlueprintsGraph vertexiumBlueprintsGraph = VertexiumBlueprintsFactory.createFactory(storageFactoryClassName).createGraph(storageConfig);
            return vertexiumBlueprintsGraph;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    protected abstract VertexiumBlueprintsGraph createGraph(Map var1);

    private static VertexiumBlueprintsFactory createFactory(String factoryClassName) {
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
            return (VertexiumBlueprintsFactory)constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not create factory: " + factoryClassName, ex);
        }
    }
}

