/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.cli;

import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.cli.model.LazyEdge;
import org.neolumin.vertexium.cli.model.LazyEdgeMap;
import org.neolumin.vertexium.cli.model.LazyProperty;
import org.neolumin.vertexium.cli.model.LazyVertex;
import org.neolumin.vertexium.cli.model.LazyVertexMap;
import org.neolumin.vertexium.property.StreamingPropertyValue;

public class VertexiumScript
extends Script {
    private static Graph graph;
    private static Authorizations authorizations;
    private static final Map<String, LazyProperty> contextProperties;
    private static final Map<String, LazyEdge> contextEdges;
    private static final Map<String, LazyVertex> contextVertices;

    public static void setGraph(Graph graph) {
        VertexiumScript.graph = graph;
    }

    public static Graph getGraph() {
        return graph;
    }

    public Object run() {
        return null;
    }

    public Object invokeMethod(String name, Object args) {
        if ("setauths".equalsIgnoreCase(name)) {
            return this.invokeSetAuths(args);
        }
        if ("getauths".equalsIgnoreCase(name)) {
            return this.invokeGetAuths();
        }
        return super.invokeMethod(name, args);
    }

    private Object invokeGetAuths() {
        return VertexiumScript.getAuthorizations();
    }

    private Object invokeSetAuths(Object args) {
        String[] auths = this.invokeMethodArgsToStrings(args);
        VertexiumScript.setAuthorizations(VertexiumScript.getGraph().createAuthorizations(auths));
        return this.invokeGetAuths();
    }

    private String[] invokeMethodArgsToStrings(Object args) {
        if (args == null) {
            return new String[0];
        }
        Object[] authsObjects = (Object[])args;
        ArrayList<String> authsList = new ArrayList<String>();
        for (Object authObject : authsObjects) {
            authsList.add(authObject.toString());
        }
        return authsList.toArray(new String[authsList.size()]);
    }

    public Object getProperty(String property) {
        if ("v".equals(property)) {
            return new LazyVertexMap();
        }
        if ("e".equals(property)) {
            return new LazyEdgeMap();
        }
        if ("g".equals(property)) {
            return VertexiumScript.getGraph();
        }
        if ("setauths".equalsIgnoreCase(property)) {
            return this.invokeSetAuths(null);
        }
        if ("getauths".equalsIgnoreCase(property)) {
            return this.invokeGetAuths();
        }
        LazyProperty contextProperty = contextProperties.get(property);
        if (contextProperty != null) {
            return contextProperty;
        }
        LazyEdge contextEdge = contextEdges.get(property);
        if (contextEdge != null) {
            return contextEdge;
        }
        LazyVertex contextVertex = contextVertices.get(property);
        if (contextVertex != null) {
            return contextVertex;
        }
        return super.getProperty(property);
    }

    public static Authorizations getAuthorizations() {
        if (authorizations == null) {
            authorizations = VertexiumScript.getGraph().createAuthorizations(new String[0]);
        }
        return authorizations;
    }

    public static void setAuthorizations(Authorizations authorizations) {
        VertexiumScript.authorizations = authorizations;
    }

    public static Map<String, LazyProperty> getContextProperties() {
        return contextProperties;
    }

    public static Map<String, LazyEdge> getContextEdges() {
        return contextEdges;
    }

    public static Map<String, LazyVertex> getContextVertices() {
        return contextVertices;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String valueToString(Object value, boolean expanded) {
        if (value == null) {
            return null;
        }
        if (!expanded) return value.toString();
        if (!(value instanceof StreamingPropertyValue)) return value.toString();
        StreamingPropertyValue spv = (StreamingPropertyValue)value;
        if (spv.getValueType() != String.class) return value.toString();
        try (InputStream in = spv.getInputStream();){
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        catch (IOException e) {
            throw new SecurityException("Could not get StreamingPropertyValue input stream", e);
        }
    }

    public static String resultToString(Object obj) {
        if (obj instanceof Vertex) {
            return LazyVertex.toString((Vertex)obj, VertexiumScript.getAuthorizations());
        }
        if (obj instanceof Edge) {
            return LazyEdge.toString((Edge)obj);
        }
        if (obj instanceof Property) {
            return LazyProperty.toString((Property)obj, "property");
        }
        return InvokerHelper.toString((Object)obj);
    }

    static {
        contextProperties = new HashMap<String, LazyProperty>();
        contextEdges = new HashMap<String, LazyEdge>();
        contextVertices = new HashMap<String, LazyVertex>();
    }
}

