/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium;

import java.util.ArrayList;
import java.util.List;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.Metadata;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.mutation.ElementMutation;
import org.neolumin.vertexium.mutation.KeyNameVisibilityPropertyRemoveMutation;
import org.neolumin.vertexium.mutation.PropertyPropertyRemoveMutation;
import org.neolumin.vertexium.mutation.PropertyRemoveMutation;
import org.neolumin.vertexium.property.MutablePropertyImpl;
import org.neolumin.vertexium.search.IndexHint;
import org.neolumin.vertexium.util.Preconditions;

public abstract class ElementBuilder<T extends Element>
implements ElementMutation<T> {
    private final List<Property> properties = new ArrayList<Property>();
    private final List<PropertyRemoveMutation> propertyRemoves = new ArrayList<PropertyRemoveMutation>();
    private IndexHint indexHint = IndexHint.INDEX;

    @Override
    public ElementBuilder<T> setProperty(String name, Object value, Visibility visibility) {
        return this.setProperty(name, value, new Metadata(), visibility);
    }

    @Override
    public ElementBuilder<T> setProperty(String name, Object value, Metadata metadata, Visibility visibility) {
        return this.addPropertyValue("", name, value, metadata, visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Object value, Visibility visibility) {
        return this.addPropertyValue(key, name, value, new Metadata(), visibility);
    }

    @Override
    public ElementBuilder<T> addPropertyValue(String key, String name, Object value, Metadata metadata, Visibility visibility) {
        Preconditions.checkNotNull(name, "property name cannot be null for property: " + name + ":" + key);
        Preconditions.checkNotNull(value, "property value cannot be null for property: " + name + ":" + key);
        this.properties.add(new MutablePropertyImpl(key, name, value, metadata, null, visibility));
        return this;
    }

    @Override
    public ElementBuilder<T> removeProperty(Property property) {
        this.propertyRemoves.add(new PropertyPropertyRemoveMutation(property));
        return this;
    }

    @Override
    public ElementBuilder<T> removeProperty(String name, Visibility visibility) {
        return this.removeProperty("", name, visibility);
    }

    @Override
    public ElementBuilder<T> removeProperty(String key, String name, Visibility visibility) {
        Preconditions.checkNotNull(name, "property name cannot be null for property: " + name + ":" + key);
        this.propertyRemoves.add(new KeyNameVisibilityPropertyRemoveMutation(key, name, visibility));
        return this;
    }

    @Override
    public abstract T save(Authorizations var1);

    @Override
    public Iterable<Property> getProperties() {
        return this.properties;
    }

    @Override
    public Iterable<PropertyRemoveMutation> getPropertyRemoves() {
        return this.propertyRemoves;
    }

    public IndexHint getIndexHint() {
        return this.indexHint;
    }

    @Override
    public ElementMutation<T> setIndexHint(IndexHint indexHint) {
        this.indexHint = indexHint;
        return this;
    }
}

