/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.DefinePropertyBuilder;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.EdgeBuilder;
import org.neolumin.vertexium.EdgeBuilderByVertexId;
import org.neolumin.vertexium.ElementBuilder;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphMetadataEntry;
import org.neolumin.vertexium.Path;
import org.neolumin.vertexium.ProgressCallback;
import org.neolumin.vertexium.SearchIndexSecurityGranularity;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexBuilder;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.event.GraphEvent;
import org.neolumin.vertexium.event.GraphEventListener;
import org.neolumin.vertexium.path.PathFindingAlgorithm;
import org.neolumin.vertexium.path.RecursivePathFindingAlgorithm;
import org.neolumin.vertexium.query.GraphQuery;
import org.neolumin.vertexium.query.SimilarToGraphQuery;
import org.neolumin.vertexium.util.IterableUtils;
import org.neolumin.vertexium.util.LookAheadIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphBase
implements Graph {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphBase.class);
    private final PathFindingAlgorithm pathFindingAlgorithm = new RecursivePathFindingAlgorithm();
    private final List<GraphEventListener> graphEventListeners = new ArrayList<GraphEventListener>();

    protected GraphBase() {
    }

    @Override
    public Vertex addVertex(Visibility visibility, Authorizations authorizations) {
        return this.prepareVertex(visibility).save(authorizations);
    }

    @Override
    public Vertex addVertex(String vertexId, Visibility visibility, Authorizations authorizations) {
        return this.prepareVertex(vertexId, visibility).save(authorizations);
    }

    @Override
    public Iterable<Vertex> addVertices(Iterable<ElementBuilder<Vertex>> vertices, Authorizations authorizations) {
        ArrayList<Vertex> addedVertices = new ArrayList<Vertex>();
        for (ElementBuilder<Vertex> vertexBuilder : vertices) {
            addedVertices.add(vertexBuilder.save(authorizations));
        }
        return addedVertices;
    }

    @Override
    public VertexBuilder prepareVertex(Visibility visibility) {
        return this.prepareVertex(this.getIdGenerator().nextId(), visibility);
    }

    @Override
    public boolean doesVertexExist(String vertexId, Authorizations authorizations) {
        return this.getVertex(vertexId, FetchHint.NONE, authorizations) != null;
    }

    @Override
    public Vertex getVertex(String vertexId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        LOGGER.warn("Performing scan of all vertices! Override getVertex.");
        for (Vertex vertex : this.getVertices(fetchHints, authorizations)) {
            if (!vertex.getId().equals(vertexId)) continue;
            return vertex;
        }
        return null;
    }

    @Override
    public Vertex getVertex(String vertexId, Authorizations authorizations) throws VertexiumException {
        return this.getVertex(vertexId, FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Vertex> getVertices(final Iterable<String> ids, EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        LOGGER.warn("Getting each vertex one by one! Override getVertices(java.lang.Iterable<java.lang.String>, Authorizations)");
        return new LookAheadIterable<String, Vertex>(){

            @Override
            protected boolean isIncluded(String src, Vertex vertex) {
                return vertex != null;
            }

            @Override
            protected Vertex convert(String id) {
                return GraphBase.this.getVertex(id, authorizations);
            }

            @Override
            protected Iterator<String> createIterator() {
                return ids.iterator();
            }
        };
    }

    @Override
    public Map<String, Boolean> doVerticesExist(List<String> ids, Authorizations authorizations) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String id : ids) {
            results.put(id, false);
        }
        for (Vertex vertex : this.getVertices(ids, FetchHint.NONE, authorizations)) {
            results.put(vertex.getId(), true);
        }
        return results;
    }

    @Override
    public Iterable<Vertex> getVertices(Iterable<String> ids, Authorizations authorizations) {
        return this.getVertices(ids, FetchHint.ALL, authorizations);
    }

    @Override
    public List<Vertex> getVerticesInOrder(Iterable<String> ids, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        final List<String> vertexIds = IterableUtils.toList(ids);
        List<Vertex> vertices = IterableUtils.toList(this.getVertices(vertexIds, authorizations));
        Collections.sort(vertices, new Comparator<Vertex>(){

            @Override
            public int compare(Vertex v1, Vertex v2) {
                Integer i1 = vertexIds.indexOf(v1.getId());
                Integer i2 = vertexIds.indexOf(v2.getId());
                return i1.compareTo(i2);
            }
        });
        return vertices;
    }

    @Override
    public List<Vertex> getVerticesInOrder(Iterable<String> ids, Authorizations authorizations) {
        return this.getVerticesInOrder(ids, FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Vertex> getVertices(Authorizations authorizations) throws VertexiumException {
        return this.getVertices(FetchHint.ALL, authorizations);
    }

    @Override
    public abstract Iterable<Vertex> getVertices(EnumSet<FetchHint> var1, Authorizations var2);

    @Override
    public abstract void removeVertex(Vertex var1, Authorizations var2);

    @Override
    public Edge addEdge(Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(outVertex, inVertex, label, visibility).save(authorizations);
    }

    @Override
    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, visibility).save(authorizations);
    }

    @Override
    public Edge addEdge(String outVertexId, String inVertexId, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(outVertexId, inVertexId, label, visibility).save(authorizations);
    }

    @Override
    public Edge addEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertexId, inVertexId, label, visibility).save(authorizations);
    }

    @Override
    public EdgeBuilderByVertexId prepareEdge(String outVertexId, String inVertexId, String label, Visibility visibility) {
        return this.prepareEdge(this.getIdGenerator().nextId(), outVertexId, inVertexId, label, visibility);
    }

    @Override
    public EdgeBuilder prepareEdge(Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        return this.prepareEdge(this.getIdGenerator().nextId(), outVertex, inVertex, label, visibility);
    }

    @Override
    public boolean doesEdgeExist(String edgeId, Authorizations authorizations) {
        return this.getEdge(edgeId, FetchHint.NONE, authorizations) != null;
    }

    @Override
    public Edge getEdge(String edgeId, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        LOGGER.warn("Performing scan of all edges! Override getEdge.");
        for (Edge edge : this.getEdges(fetchHints, authorizations)) {
            if (!edge.getId().equals(edgeId)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public Edge getEdge(String edgeId, Authorizations authorizations) {
        return this.getEdge(edgeId, FetchHint.ALL, authorizations);
    }

    @Override
    public Map<String, Boolean> doEdgesExist(List<String> ids, Authorizations authorizations) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String id : ids) {
            results.put(id, false);
        }
        for (Edge edge : this.getEdges(ids, FetchHint.NONE, authorizations)) {
            results.put(edge.getId(), true);
        }
        return results;
    }

    @Override
    public Iterable<Edge> getEdges(final Iterable<String> ids, EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        LOGGER.warn("Getting each edge one by one! Override getEdges(java.lang.Iterable<java.lang.String>, Authorizations)");
        return new LookAheadIterable<String, Edge>(){

            @Override
            protected boolean isIncluded(String src, Edge edge) {
                return edge != null;
            }

            @Override
            protected Edge convert(String id) {
                return GraphBase.this.getEdge(id, authorizations);
            }

            @Override
            protected Iterator<String> createIterator() {
                return ids.iterator();
            }
        };
    }

    @Override
    public Iterable<Edge> getEdges(Iterable<String> ids, Authorizations authorizations) {
        return this.getEdges(ids, FetchHint.ALL, authorizations);
    }

    @Override
    public Iterable<Edge> getEdges(Authorizations authorizations) {
        return this.getEdges(FetchHint.ALL, authorizations);
    }

    @Override
    public abstract Iterable<Edge> getEdges(EnumSet<FetchHint> var1, Authorizations var2);

    @Override
    public abstract void removeEdge(Edge var1, Authorizations var2);

    @Override
    public Iterable<Path> findPaths(Vertex sourceVertex, Vertex destVertex, int maxHops, Authorizations authorizations) {
        ProgressCallback progressCallback = new ProgressCallback(){

            @Override
            public void progress(double progressPercent, ProgressCallback.Step step, Integer edgeIndex, Integer vertexCount) {
                LOGGER.debug(String.format("findPaths progress %d%%: %s", (int)(progressPercent * 100.0), step.formatMessage(edgeIndex, vertexCount)));
            }
        };
        return this.findPaths(sourceVertex, destVertex, maxHops, progressCallback, authorizations);
    }

    @Override
    public Iterable<Path> findPaths(Vertex sourceVertex, Vertex destVertex, int maxHops, ProgressCallback progressCallback, Authorizations authorizations) {
        return this.pathFindingAlgorithm.findPaths(this, sourceVertex, destVertex, maxHops, progressCallback, authorizations);
    }

    @Override
    public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, int maxHops, ProgressCallback progressCallback, Authorizations authorizations) {
        EnumSet<FetchHint> fetchHints = FetchHint.EDGE_REFS;
        Vertex sourceVertex = this.getVertex(sourceVertexId, fetchHints, authorizations);
        if (sourceVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + sourceVertexId);
        }
        Vertex destVertex = this.getVertex(destVertexId, fetchHints, authorizations);
        if (destVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + destVertexId);
        }
        return this.findPaths(sourceVertex, destVertex, maxHops, progressCallback, authorizations);
    }

    @Override
    public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, int maxHops, Authorizations authorizations) {
        EnumSet<FetchHint> fetchHints = FetchHint.EDGE_REFS;
        Vertex sourceVertex = this.getVertex(sourceVertexId, fetchHints, authorizations);
        if (sourceVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + sourceVertexId);
        }
        Vertex destVertex = this.getVertex(destVertexId, fetchHints, authorizations);
        if (destVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + destVertexId);
        }
        return this.findPaths(sourceVertex, destVertex, maxHops, authorizations);
    }

    @Override
    public Iterable<String> findRelatedEdges(Iterable<String> vertexIds, Authorizations authorizations) {
        HashSet<String> results = new HashSet<String>();
        List<Vertex> vertices = IterableUtils.toList(this.getVertices(vertexIds, authorizations));
        HashMap<String, String> checkedCombinations = new HashMap<String, String>();
        for (Vertex sourceVertex : vertices) {
            for (Vertex destVertex : vertices) {
                if (checkedCombinations.containsKey(sourceVertex.getId() + destVertex.getId())) continue;
                Iterable<String> edgeIds = sourceVertex.getEdgeIds(destVertex, Direction.BOTH, authorizations);
                for (String edgeId : edgeIds) {
                    results.add(edgeId);
                }
                checkedCombinations.put(sourceVertex.getId() + destVertex.getId(), "");
                checkedCombinations.put(destVertex.getId() + sourceVertex.getId(), "");
            }
        }
        return results;
    }

    @Override
    public void removeEdge(String edgeId, Authorizations authorizations) {
        Edge edge = this.getEdge(edgeId, authorizations);
        if (edge == null) {
            throw new IllegalArgumentException("Could not find edge with id: " + edgeId);
        }
        this.removeEdge(edge, authorizations);
    }

    @Override
    public abstract Iterable<GraphMetadataEntry> getMetadata();

    @Override
    public Object getMetadata(String key) {
        for (GraphMetadataEntry e : this.getMetadata()) {
            if (!e.getKey().equals(key)) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public abstract void setMetadata(String var1, Object var2);

    @Override
    public abstract GraphQuery query(Authorizations var1);

    @Override
    public abstract GraphQuery query(String var1, Authorizations var2);

    @Override
    public abstract void reindex(Authorizations var1);

    @Override
    public abstract void flush();

    @Override
    public abstract void shutdown();

    @Override
    public abstract DefinePropertyBuilder defineProperty(String var1);

    @Override
    public abstract boolean isFieldBoostSupported();

    @Override
    public abstract SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    @Override
    public void addGraphEventListener(GraphEventListener graphEventListener) {
        this.graphEventListeners.add(graphEventListener);
    }

    protected boolean hasEventListeners() {
        return this.graphEventListeners.size() > 0;
    }

    protected void fireGraphEvent(GraphEvent graphEvent) {
        for (GraphEventListener graphEventListener : this.graphEventListeners) {
            graphEventListener.onGraphEvent(graphEvent);
        }
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return false;
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(String[] fields, String text, Authorizations authorizations) {
        throw new VertexiumException("querySimilarTo not supported");
    }
}

