/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.id;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.neolumin.vertexium.id.NameSubstitutionStrategy;

public class SimpleNameSubstitutionStrategy
implements NameSubstitutionStrategy {
    private List<Pair<String, String>> substitutionList = Lists.newArrayList();
    private final Cache<String, String> deflateCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<String, String> inflateCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    public static final String SUBS_DELIM = "\u0002";

    @Override
    public String deflate(String value) {
        String cachedDeflatedValue = (String)this.deflateCache.getIfPresent((Object)value);
        if (cachedDeflatedValue != null) {
            return cachedDeflatedValue;
        }
        String deflatedVal = value;
        for (Pair<String, String> pair : this.substitutionList) {
            deflatedVal = deflatedVal.replaceAll((String)pair.getKey(), SimpleNameSubstitutionStrategy.wrap((String)pair.getValue()));
        }
        this.deflateCache.put((Object)value, (Object)deflatedVal);
        this.inflateCache.put((Object)deflatedVal, (Object)value);
        return deflatedVal;
    }

    @Override
    public String inflate(String value) {
        String cachedInflatedValue = (String)this.inflateCache.getIfPresent((Object)(SUBS_DELIM + value));
        if (cachedInflatedValue != null) {
            return cachedInflatedValue;
        }
        String inflatedValue = value;
        for (Pair<String, String> pair : this.substitutionList) {
            inflatedValue = inflatedValue.replaceAll(SimpleNameSubstitutionStrategy.wrap((String)pair.getValue()), (String)pair.getKey());
        }
        this.inflateCache.put((Object)value, (Object)inflatedValue);
        this.deflateCache.put((Object)inflatedValue, (Object)value);
        return inflatedValue;
    }

    public static String wrap(String str) {
        return SUBS_DELIM + str + SUBS_DELIM;
    }

    public void setSubstitutionList(List<Pair<String, String>> substitutionList) {
        this.substitutionList = substitutionList;
        for (Pair<String, String> pair : this.substitutionList) {
            this.deflateCache.put(pair.getKey(), (Object)SimpleNameSubstitutionStrategy.wrap((String)pair.getValue()));
            this.inflateCache.put((Object)SimpleNameSubstitutionStrategy.wrap((String)pair.getValue()), pair.getKey());
        }
    }
}

