/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.query.Predicate;
import org.neolumin.vertexium.query.Query;
import org.neolumin.vertexium.util.SelectManyIterable;

public class CompositeGraphQuery
implements Query {
    private final List<Query> queries;

    public CompositeGraphQuery(Query ... queries) {
        this(Arrays.asList(queries));
    }

    public CompositeGraphQuery(Collection<Query> queries) {
        this.queries = new ArrayList<Query>(queries);
    }

    @Override
    public Iterable<Vertex> vertices() {
        return this.vertices(FetchHint.ALL);
    }

    @Override
    public Iterable<Vertex> vertices(final EnumSet<FetchHint> fetchHints) {
        final HashSet seenIds = new HashSet();
        return new SelectManyIterable<Query, Vertex>(this.queries){

            @Override
            public Iterable<Vertex> getIterable(Query query) {
                return query.vertices(fetchHints);
            }

            @Override
            protected boolean isIncluded(Vertex vertex) {
                if (seenIds.contains(vertex.getId())) {
                    return false;
                }
                seenIds.add(vertex.getId());
                return super.isIncluded(vertex);
            }
        };
    }

    @Override
    public Iterable<Edge> edges() {
        return this.edges(FetchHint.ALL);
    }

    @Override
    public Iterable<Edge> edges(final EnumSet<FetchHint> fetchHints) {
        final HashSet seenIds = new HashSet();
        return new SelectManyIterable<Query, Edge>(this.queries){

            @Override
            public Iterable<Edge> getIterable(Query query) {
                return query.edges(fetchHints);
            }

            @Override
            protected boolean isIncluded(Edge edge) {
                if (seenIds.contains(edge.getId())) {
                    return false;
                }
                seenIds.add(edge.getId());
                return super.isIncluded(edge);
            }
        };
    }

    @Override
    public Iterable<Edge> edges(String label) {
        return this.edges(label, FetchHint.ALL);
    }

    @Override
    public Iterable<Edge> edges(final String label, final EnumSet<FetchHint> fetchHints) {
        final HashSet seenIds = new HashSet();
        return new SelectManyIterable<Query, Edge>(this.queries){

            @Override
            public Iterable<Edge> getIterable(Query query) {
                return query.edges(label, fetchHints);
            }

            @Override
            protected boolean isIncluded(Edge edge) {
                if (seenIds.contains(edge.getId())) {
                    return false;
                }
                seenIds.add(edge.getId());
                return super.isIncluded(edge);
            }
        };
    }

    @Override
    public <T> Query range(String propertyName, T startValue, T endValue) {
        for (Query query : this.queries) {
            query.range(propertyName, startValue, endValue);
        }
        return this;
    }

    @Override
    public <T> Query has(String propertyName, T value) {
        for (Query query : this.queries) {
            query.has(propertyName, value);
        }
        return this;
    }

    @Override
    public <T> Query has(String propertyName, Predicate predicate, T value) {
        for (Query query : this.queries) {
            query.has(propertyName, predicate, value);
        }
        return this;
    }

    @Override
    public Query skip(int count) {
        for (Query query : this.queries) {
            query.skip(count);
        }
        return this;
    }

    @Override
    public Query limit(int count) {
        for (Query query : this.queries) {
            query.limit(count);
        }
        return this;
    }
}

