/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.query;

import java.util.EnumSet;
import java.util.Map;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.ElementType;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.query.DefaultGraphQueryIterable;
import org.neolumin.vertexium.query.GraphQueryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphQuery
extends GraphQueryBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGraphQuery.class);

    public DefaultGraphQuery(Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, Authorizations authorizations) {
        super(graph, queryString, propertyDefinitions, authorizations);
    }

    @Override
    public Iterable<Vertex> vertices(EnumSet<FetchHint> fetchHints) {
        LOGGER.warn("scanning all vertices! create your own GraphQuery.");
        return new DefaultGraphQueryIterable<Vertex>(this.getParameters(), this.getIterableFromElementType(ElementType.VERTEX, fetchHints), true, true);
    }

    @Override
    public Iterable<Edge> edges(EnumSet<FetchHint> fetchHints) {
        LOGGER.warn("scanning all edges! create your own GraphQuery.");
        return new DefaultGraphQueryIterable<Edge>(this.getParameters(), this.getIterableFromElementType(ElementType.EDGE, fetchHints), true, true);
    }

    private <T extends Element> Iterable<T> getIterableFromElementType(ElementType elementType, EnumSet<FetchHint> fetchHints) throws VertexiumException {
        switch (elementType) {
            case VERTEX: {
                return this.getGraph().getVertices(fetchHints, this.getParameters().getAuthorizations());
            }
            case EDGE: {
                return this.getGraph().getEdges(fetchHints, this.getParameters().getAuthorizations());
            }
        }
        throw new VertexiumException("Unexpected element type: " + (Object)((Object)elementType));
    }
}

