/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.query;

import java.util.Iterator;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.query.QueryBase;
import org.neolumin.vertexium.query.QueryParameters;
import org.neolumin.vertexium.query.QueryStringQueryParameters;

public class DefaultGraphQueryIterable<T extends Element>
implements Iterable<T> {
    private final QueryParameters parameters;
    private final Iterable<T> iterable;
    private final boolean evaluateQueryString;
    private final boolean evaluateHasContainers;

    public DefaultGraphQueryIterable(QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers) {
        this.parameters = parameters;
        this.iterable = iterable;
        this.evaluateQueryString = evaluateQueryString;
        this.evaluateHasContainers = evaluateHasContainers;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> it = this.iterable.iterator();
        return new Iterator<T>(){
            public T next;
            public T current;
            public long count;

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.next != null;
            }

            @Override
            public T next() {
                this.loadNext();
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void loadNext() {
                if (this.next != null) {
                    return;
                }
                if (this.count >= DefaultGraphQueryIterable.this.parameters.getSkip() + DefaultGraphQueryIterable.this.parameters.getLimit()) {
                    return;
                }
                while (it.hasNext()) {
                    Element elem = (Element)it.next();
                    boolean match = true;
                    if (DefaultGraphQueryIterable.this.evaluateHasContainers) {
                        for (QueryBase.HasContainer has : DefaultGraphQueryIterable.this.parameters.getHasContainers()) {
                            if (has.isMatch(elem)) continue;
                            match = false;
                            break;
                        }
                    }
                    if (!match || DefaultGraphQueryIterable.this.evaluateQueryString && DefaultGraphQueryIterable.this.parameters instanceof QueryStringQueryParameters && ((QueryStringQueryParameters)DefaultGraphQueryIterable.this.parameters).getQueryString() != null && !DefaultGraphQueryIterable.this.evaluateQueryString(elem, ((QueryStringQueryParameters)DefaultGraphQueryIterable.this.parameters).getQueryString())) continue;
                    ++this.count;
                    if (this.count <= DefaultGraphQueryIterable.this.parameters.getSkip()) continue;
                    this.next = elem;
                    break;
                }
            }
        };
    }

    protected boolean evaluateQueryString(Element elem, String queryString) {
        for (Property property : elem.getProperties()) {
            if (!this.evaluateQueryStringOnValue(property.getValue(), queryString)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateQueryStringOnValue(Object value, String queryString) {
        if (value == null) {
            return false;
        }
        if (queryString.equals("*")) {
            return true;
        }
        String valueString = value.toString().toLowerCase();
        return valueString.contains(queryString.toLowerCase());
    }
}

