/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.query;

import java.util.Map;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.TextIndexHint;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.property.StreamingPropertyValue;
import org.neolumin.vertexium.query.Predicate;
import org.neolumin.vertexium.type.GeoPoint;

public enum TextPredicate implements Predicate
{
    CONTAINS;


    @Override
    public boolean evaluate(Iterable<Property> properties, Object second, Map<String, PropertyDefinition> propertyDefinitions) {
        for (Property property : properties) {
            PropertyDefinition propertyDefinition;
            if (!this.evaluate(property, second, propertyDefinition = propertyDefinitions.get(property.getName()))) continue;
            return true;
        }
        return false;
    }

    private boolean evaluate(Property property, Object second, PropertyDefinition propertyDefinition) {
        Object first = property.getValue();
        if (!this.canEvaulate(first) || !this.canEvaulate(second)) {
            throw new VertexiumException("Text predicates are only valid for string or GeoPoint fields");
        }
        String firstString = this.valueToString(first);
        String secondString = this.valueToString(second);
        switch (this) {
            case CONTAINS: {
                if (propertyDefinition != null && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.FULL_TEXT)) {
                    return false;
                }
                return firstString.contains(secondString);
            }
        }
        throw new IllegalArgumentException("Invalid text predicate: " + this);
    }

    private String valueToString(Object val) {
        if (val instanceof GeoPoint) {
            val = ((GeoPoint)val).getDescription();
        } else if (val instanceof StreamingPropertyValue) {
            val = ((StreamingPropertyValue)val).readToString();
        }
        return ((String)val).toLowerCase();
    }

    private boolean canEvaulate(Object first) {
        if (first instanceof String) {
            return true;
        }
        if (first instanceof GeoPoint) {
            return true;
        }
        return first instanceof StreamingPropertyValue && ((StreamingPropertyValue)first).getValueType() == String.class;
    }
}

