/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.query;

import java.util.EnumSet;
import java.util.Map;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.query.QueryBase;
import org.neolumin.vertexium.query.VertexQuery;
import org.neolumin.vertexium.util.FilterIterable;

public abstract class VertexQueryBase
extends QueryBase
implements VertexQuery {
    private final Vertex sourceVertex;

    protected VertexQueryBase(Graph graph, Vertex sourceVertex, String queryString, Map<String, PropertyDefinition> propertyDefinitions, Authorizations authorizations) {
        super(graph, queryString, propertyDefinitions, authorizations);
        this.sourceVertex = sourceVertex;
    }

    @Override
    public abstract Iterable<Vertex> vertices(EnumSet<FetchHint> var1);

    @Override
    public abstract Iterable<Edge> edges(EnumSet<FetchHint> var1);

    @Override
    public Iterable<Edge> edges(final Direction direction, EnumSet<FetchHint> fetchHints) {
        return new FilterIterable<Edge>(this.edges(fetchHints)){

            @Override
            protected boolean isIncluded(Edge edge) {
                switch (direction) {
                    case BOTH: {
                        return true;
                    }
                    case IN: {
                        return edge.getVertexId(Direction.IN).equals(VertexQueryBase.this.sourceVertex.getId());
                    }
                    case OUT: {
                        return edge.getVertexId(Direction.OUT).equals(VertexQueryBase.this.sourceVertex.getId());
                    }
                }
                throw new RuntimeException("Unexpected direction: " + (Object)((Object)direction));
            }
        };
    }

    @Override
    public Iterable<Edge> edges(Direction direction) {
        return this.edges(direction, FetchHint.ALL);
    }

    @Override
    public Iterable<Edge> edges(Direction direction, final String label, EnumSet<FetchHint> fetchHints) {
        return new FilterIterable<Edge>(this.edges(direction, fetchHints)){

            @Override
            protected boolean isIncluded(Edge o) {
                return label.equals(o.getLabel());
            }
        };
    }

    @Override
    public Iterable<Edge> edges(Direction direction, String label) {
        return this.edges(direction, label, FetchHint.ALL);
    }

    public Vertex getSourceVertex() {
        return this.sourceVertex;
    }
}

