/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.VertexiumException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);

    public static <T> T createProvider(GraphConfiguration config, String propPrefix, String defaultProvider) throws VertexiumException {
        String implClass = config.getString(propPrefix, defaultProvider);
        return ConfigurationUtils.createProvider(implClass, config);
    }

    public static <T> T createProvider(String className, GraphConfiguration config) throws VertexiumException {
        LOGGER.debug("creating provider " + className);
        Class<GraphConfiguration> constructorParameterClass = GraphConfiguration.class;
        try {
            Class<?> clazz = Class.forName(className);
            try {
                try {
                    Constructor<?> constructor = clazz.getConstructor(constructorParameterClass);
                    return (T)constructor.newInstance(config);
                }
                catch (NoSuchMethodException ignore) {
                    try {
                        Constructor<?> constructor = clazz.getConstructor(Map.class);
                        return (T)constructor.newInstance(config.getConfig());
                    }
                    catch (NoSuchMethodException ignoreInner) {
                        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                        return (T)constructor.newInstance(new Object[0]);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                StringBuilder possibleMatches = new StringBuilder();
                for (Constructor<?> s : clazz.getConstructors()) {
                    possibleMatches.append(s.toGenericString());
                    possibleMatches.append(", ");
                }
                throw new VertexiumException("Invalid constructor for " + className + ". Expected <init>(" + constructorParameterClass.getName() + "). Found: " + possibleMatches, e);
            }
        }
        catch (NoSuchMethodException e) {
            throw new VertexiumException("Provider must have a single argument constructor taking a " + constructorParameterClass.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new VertexiumException("No provider found with class name " + className, e);
        }
        catch (Exception e) {
            throw new VertexiumException(e);
        }
    }
}

