/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.util;

import java.io.Closeable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.neolumin.vertexium.util.CloseableUtils;

public class IterableUtils {
    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T o : iterable) {
            results.add(o);
        }
        IterableUtils.close(iterable);
        return results;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        HashSet<T> results = new HashSet<T>();
        for (T o : iterable) {
            results.add(o);
        }
        IterableUtils.close(iterable);
        return results;
    }

    public static <T> Set<T> toSet(T[] iterable) {
        HashSet results = new HashSet();
        Collections.addAll(results, iterable);
        return results;
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        List<Object> list = IterableUtils.toList(iterable);
        Object[] array = (Object[])Array.newInstance(type, list.size());
        return list.toArray(array);
    }

    public static <T> int count(Iterable<T> iterable) {
        int count = 0;
        for (T ignore : iterable) {
            ++count;
        }
        IterableUtils.close(iterable);
        return count;
    }

    public static <T> Iterable<T> toIterable(final T[] arr) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < arr.length;
                    }

                    @Override
                    public T next() {
                        return arr[this.index++];
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("Not supported");
                    }
                };
            }
        };
    }

    public static <T> T single(Iterable<? extends T> it) {
        Iterator<T> i = it.iterator();
        if (!i.hasNext()) {
            throw new IllegalStateException("No items found.");
        }
        T result = i.next();
        if (i.hasNext()) {
            IterableUtils.close(it);
            throw new IllegalStateException("More than 1 item found.");
        }
        IterableUtils.close(it);
        return result;
    }

    private static <T> void close(Iterable<? extends T> it) {
        if (it instanceof Closeable) {
            CloseableUtils.closeQuietly((Closeable)((Object)it));
        }
    }

    public static <T> T singleOrDefault(Iterable<? extends T> it, T defaultValue) {
        Iterator<T> i = it.iterator();
        if (!i.hasNext()) {
            return defaultValue;
        }
        T result = i.next();
        if (i.hasNext()) {
            IterableUtils.close(it);
            throw new IllegalStateException("More than 1 item found.");
        }
        IterableUtils.close(it);
        return result;
    }
}

