/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.util;

import java.util.Iterator;

public abstract class SelectManyIterable<TSource, TDest>
implements Iterable<TDest> {
    private final Iterable<TSource> source;

    public SelectManyIterable(Iterable<TSource> source) {
        this.source = source;
    }

    @Override
    public Iterator<TDest> iterator() {
        final Iterator<TSource> it = this.source.iterator();
        return new Iterator<TDest>(){
            private TDest next;
            private TDest current;
            public Iterator<TDest> innerIterator = null;

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.next != null;
            }

            @Override
            public TDest next() {
                this.loadNext();
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void loadNext() {
                if (this.next != null) {
                    return;
                }
                while (true) {
                    if (this.innerIterator != null) {
                        if (this.innerIterator.hasNext()) {
                            Object dest = this.innerIterator.next();
                            if (!SelectManyIterable.this.isIncluded(dest)) continue;
                            this.next = dest;
                            return;
                        }
                        this.innerIterator = null;
                        continue;
                    }
                    if (!it.hasNext()) break;
                    Object nextSource = it.next();
                    this.innerIterator = SelectManyIterable.this.getIterable(nextSource).iterator();
                }
            }
        };
    }

    protected boolean isIncluded(TDest dest) {
        return true;
    }

    protected abstract Iterable<TDest> getIterable(TSource var1);
}

