/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.DateOnly;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.FetchHint;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.elasticsearch.ElasticSearchGraphQueryIterable;
import org.neolumin.vertexium.elasticsearch.score.ScoringStrategy;
import org.neolumin.vertexium.query.Compare;
import org.neolumin.vertexium.query.GeoCompare;
import org.neolumin.vertexium.query.GraphQueryBase;
import org.neolumin.vertexium.query.QueryBase;
import org.neolumin.vertexium.query.QueryParameters;
import org.neolumin.vertexium.query.QueryStringQueryParameters;
import org.neolumin.vertexium.query.SimilarToTextQueryParameters;
import org.neolumin.vertexium.query.TextPredicate;
import org.neolumin.vertexium.type.GeoCircle;
import org.neolumin.vertexium.util.ConvertingIterable;
import org.neolumin.vertexium.util.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticSearchGraphQueryBase
extends GraphQueryBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchGraphQueryBase.class);
    private final TransportClient client;
    private final boolean evaluateHasContainers;
    private String[] indicesToQuery;
    private ScoringStrategy scoringStrategy;

    protected ElasticSearchGraphQueryBase(TransportClient client, String[] indicesToQuery, Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, boolean evaluateHasContainers, Authorizations authorizations) {
        super(graph, queryString, propertyDefinitions, authorizations);
        this.client = client;
        this.indicesToQuery = indicesToQuery;
        this.evaluateHasContainers = evaluateHasContainers;
        this.scoringStrategy = scoringStrategy;
    }

    protected ElasticSearchGraphQueryBase(TransportClient client, String[] indicesToQuery, Graph graph, String[] similarToFields, String similarToText, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, boolean evaluateHasContainers, Authorizations authorizations) {
        super(graph, similarToFields, similarToText, propertyDefinitions, authorizations);
        this.client = client;
        this.indicesToQuery = indicesToQuery;
        this.evaluateHasContainers = evaluateHasContainers;
        this.scoringStrategy = scoringStrategy;
    }

    public Iterable<Vertex> vertices(EnumSet<FetchHint> fetchHints) {
        long startTime = System.nanoTime();
        SearchResponse response = this.getSearchResponse("vertex");
        SearchHits hits = response.getHits();
        List ids = IterableUtils.toList((Iterable)new ConvertingIterable<SearchHit, String>((Iterable)hits){

            protected String convert(SearchHit searchHit) {
                return searchHit.getId();
            }
        });
        long endTime = System.nanoTime();
        long searchTime = endTime - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("elastic search results " + ids.size() + " of " + hits.getTotalHits() + " (time: " + searchTime / 1000L / 1000L + "ms)");
        }
        QueryParameters filterParameters = this.getParameters().clone();
        filterParameters.setSkip(0L);
        Iterable vertices = this.getGraph().getVertices((Iterable)ids, fetchHints, filterParameters.getAuthorizations());
        return this.createIterable(response, filterParameters, vertices, this.evaluateHasContainers, searchTime, hits);
    }

    public Iterable<Edge> edges(EnumSet<FetchHint> fetchHints) {
        long startTime = System.nanoTime();
        SearchResponse response = this.getSearchResponse("edge");
        SearchHits hits = response.getHits();
        List ids = IterableUtils.toList((Iterable)new ConvertingIterable<SearchHit, String>((Iterable)hits){

            protected String convert(SearchHit searchHit) {
                return searchHit.getId();
            }
        });
        long endTime = System.nanoTime();
        long searchTime = endTime - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("elastic search results " + ids.size() + " of " + hits.getTotalHits() + " (time: " + (endTime - startTime) / 1000L / 1000L + "ms)");
        }
        QueryParameters filterParameters = this.getParameters().clone();
        filterParameters.setSkip(0L);
        Iterable edges = this.getGraph().getEdges((Iterable)ids, fetchHints, filterParameters.getAuthorizations());
        return this.createIterable(response, filterParameters, edges, this.evaluateHasContainers, searchTime, hits);
    }

    protected <T extends Element> ElasticSearchGraphQueryIterable<T> createIterable(SearchResponse response, QueryParameters filterParameters, Iterable<T> elements, boolean evaluateHasContainers, long searchTime, SearchHits hits) {
        return new ElasticSearchGraphQueryIterable<T>(response, filterParameters, elements, false, evaluateHasContainers, hits.getTotalHits(), searchTime, hits);
    }

    private SearchResponse getSearchResponse(String elementType) {
        List<FilterBuilder> filters = this.getFilters(elementType);
        QueryBuilder query = this.createQuery(this.getParameters(), elementType, filters);
        query = this.scoringStrategy.updateQuery(query);
        SearchRequestBuilder q = this.getSearchRequestBuilder(filters, query);
        LOGGER.debug("query: " + q);
        return (SearchResponse)q.execute().actionGet();
    }

    protected List<FilterBuilder> getFilters(String elementType) {
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        this.addElementTypeFilter(filters, elementType);
        for (QueryBase.HasContainer has : this.getParameters().getHasContainers()) {
            Object value;
            Compare compare;
            if (has.predicate instanceof Compare) {
                compare = (Compare)has.predicate;
                value = has.value;
                String key = has.key;
                if (value instanceof String || value instanceof String[]) {
                    key = key + "_exactMatch";
                }
                switch (compare) {
                    case EQUAL: {
                        if (value instanceof DateOnly) {
                            DateOnly dateOnlyValue = (DateOnly)value;
                            filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).from((Object)dateOnlyValue.toString()).to((Object)dateOnlyValue.toString()));
                            break;
                        }
                        filters.add((FilterBuilder)FilterBuilders.termFilter((String)key, (Object)value));
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).gte(value));
                        break;
                    }
                    case GREATER_THAN: {
                        filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).gt(value));
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).lte(value));
                        break;
                    }
                    case LESS_THAN: {
                        filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).lt(value));
                        break;
                    }
                    case NOT_EQUAL: {
                        this.addNotFilter(filters, key, value);
                        break;
                    }
                    case IN: {
                        filters.add((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])((Object[])has.value)));
                        break;
                    }
                    default: {
                        throw new VertexiumException("Unexpected Compare predicate " + has.predicate);
                    }
                }
                continue;
            }
            if (has.predicate instanceof TextPredicate) {
                compare = (TextPredicate)has.predicate;
                value = has.value;
                if (value instanceof String) {
                    value = ((String)value).toLowerCase();
                }
                switch (3.$SwitchMap$org$neolumin$vertexium$query$TextPredicate[compare.ordinal()]) {
                    case 1: {
                        if (value instanceof String) {
                            filters.add((FilterBuilder)FilterBuilders.termsFilter((String)has.key, (String[])this.splitStringIntoTerms((String)value)).execution("and"));
                            break;
                        }
                        filters.add((FilterBuilder)FilterBuilders.termFilter((String)has.key, (Object)value));
                        break;
                    }
                    default: {
                        throw new VertexiumException("Unexpected text predicate " + has.predicate);
                    }
                }
                continue;
            }
            if (has.predicate instanceof GeoCompare) {
                compare = (GeoCompare)has.predicate;
                switch (3.$SwitchMap$org$neolumin$vertexium$query$GeoCompare[compare.ordinal()]) {
                    case 1: {
                        if (has.value instanceof GeoCircle) {
                            GeoCircle geoCircle = (GeoCircle)has.value;
                            double lat = geoCircle.getLatitude();
                            double lon = geoCircle.getLongitude();
                            double distance = geoCircle.getRadius();
                            filters.add((FilterBuilder)FilterBuilders.geoDistanceFilter((String)(has.key + "_geo")).point(lat, lon).distance(distance, DistanceUnit.KILOMETERS));
                            break;
                        }
                        throw new VertexiumException("Unexpected has value type " + has.value.getClass().getName());
                    }
                    default: {
                        throw new VertexiumException("Unexpected GeoCompare predicate " + has.predicate);
                    }
                }
                continue;
            }
            throw new VertexiumException("Unexpected predicate type " + has.predicate.getClass().getName());
        }
        return filters;
    }

    protected void addElementTypeFilter(List<FilterBuilder> filters, String elementType) {
        filters.add((FilterBuilder)this.createElementTypeFilter(elementType));
    }

    protected TermsFilterBuilder createElementTypeFilter(String elementType) {
        return FilterBuilders.inFilter((String)"__elementType", (String[])new String[]{elementType});
    }

    protected void addNotFilter(List<FilterBuilder> filters, String key, Object value) {
        filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])new Object[]{value})));
    }

    protected SearchRequestBuilder getSearchRequestBuilder(List<FilterBuilder> filters, QueryBuilder queryBuilder) {
        AndFilterBuilder filterBuilder = this.getFilterBuilder(filters);
        return this.getClient().prepareSearch(this.getIndicesToQuery()).setTypes(new String[]{"element"}).setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder)).setFrom((int)this.getParameters().getSkip()).setSize((int)this.getParameters().getLimit());
    }

    protected AndFilterBuilder getFilterBuilder(List<FilterBuilder> filters) {
        return FilterBuilders.andFilter((FilterBuilder[])filters.toArray(new FilterBuilder[filters.size()]));
    }

    private String[] splitStringIntoTerms(String value) {
        String[] values = value.split("[ -]");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    protected QueryBuilder createQuery(QueryParameters queryParameters, String elementType, List<FilterBuilder> filters) {
        if (queryParameters instanceof QueryStringQueryParameters) {
            String queryString = ((QueryStringQueryParameters)queryParameters).getQueryString();
            if (queryString == null || queryString.equals("*")) {
                return QueryBuilders.matchAllQuery();
            }
            return QueryBuilders.queryString((String)queryString);
        }
        if (queryParameters instanceof SimilarToTextQueryParameters) {
            SimilarToTextQueryParameters similarTo = (SimilarToTextQueryParameters)queryParameters;
            MoreLikeThisQueryBuilder q = QueryBuilders.moreLikeThisQuery((String[])similarTo.getFields()).likeText(similarTo.getText());
            if (similarTo.getPercentTermsToMatch() != null) {
                q.percentTermsToMatch(similarTo.getPercentTermsToMatch().floatValue());
            }
            if (similarTo.getMinTermFrequency() != null) {
                q.minTermFreq(similarTo.getMinTermFrequency().intValue());
            }
            if (similarTo.getMaxQueryTerms() != null) {
                q.maxQueryTerms(similarTo.getMaxQueryTerms().intValue());
            }
            if (similarTo.getMinDocFrequency() != null) {
                q.minDocFreq(similarTo.getMinDocFrequency().intValue());
            }
            if (similarTo.getMaxDocFrequency() != null) {
                q.maxDocFreq(similarTo.getMaxDocFrequency().intValue());
            }
            if (similarTo.getBoost() != null) {
                q.boost(similarTo.getBoost().floatValue());
            }
            return q;
        }
        throw new VertexiumException("Query parameters not supported of type: " + queryParameters.getClass().getName());
    }

    public TransportClient getClient() {
        return this.client;
    }

    public String[] getIndicesToQuery() {
        return this.indicesToQuery;
    }
}

