/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.elasticsearch.GeohashUtils;
import org.neolumin.vertexium.query.DefaultGraphQueryIterable;
import org.neolumin.vertexium.query.GeohashBucket;
import org.neolumin.vertexium.query.GeohashResult;
import org.neolumin.vertexium.query.HistogramBucket;
import org.neolumin.vertexium.query.HistogramResult;
import org.neolumin.vertexium.query.IterableWithGeohashResults;
import org.neolumin.vertexium.query.IterableWithHistogramResults;
import org.neolumin.vertexium.query.IterableWithScores;
import org.neolumin.vertexium.query.IterableWithSearchTime;
import org.neolumin.vertexium.query.IterableWithTermsResults;
import org.neolumin.vertexium.query.IterableWithTotalHits;
import org.neolumin.vertexium.query.QueryParameters;
import org.neolumin.vertexium.query.TermsBucket;
import org.neolumin.vertexium.query.TermsResult;
import org.neolumin.vertexium.type.GeoPoint;
import org.neolumin.vertexium.type.GeoRect;

public class ElasticSearchGraphQueryIterable<T extends Element>
extends DefaultGraphQueryIterable<T>
implements IterableWithTotalHits<T>,
IterableWithSearchTime<T>,
IterableWithScores<T>,
IterableWithHistogramResults<T>,
IterableWithTermsResults<T>,
IterableWithGeohashResults<T> {
    private final SearchResponse searchResponse;
    private final long totalHits;
    private final long searchTimeInNanoSeconds;
    private final Map<String, Double> scores = new HashMap<String, Double>();

    public ElasticSearchGraphQueryIterable(SearchResponse searchResponse, QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, long totalHits, long searchTimeInNanoSeconds, SearchHits hits) {
        super(parameters, iterable, evaluateQueryString, evaluateHasContainers);
        this.searchResponse = searchResponse;
        this.totalHits = totalHits;
        this.searchTimeInNanoSeconds = searchTimeInNanoSeconds;
        for (SearchHit hit : hits.getHits()) {
            this.scores.put(hit.getId(), Double.valueOf(hit.getScore()));
        }
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public Map<String, Double> getScores() {
        return this.scores;
    }

    public long getSearchTimeNanoSeconds() {
        return this.searchTimeInNanoSeconds;
    }

    public HistogramResult getHistogramResults(String name) {
        ArrayList<HistogramBucket> buckets = new ArrayList<HistogramBucket>();
        Aggregation agg = this.searchResponse.getAggregations().get(name);
        if (agg == null) {
            return null;
        }
        if (agg instanceof DateHistogram) {
            DateHistogram h = (DateHistogram)agg;
            for (DateHistogram.Bucket b : h.getBuckets()) {
                buckets.add(new HistogramBucket((Object)b.getKeyAsDate().toDate(), b.getDocCount()));
            }
        } else if (agg instanceof Histogram) {
            Histogram h = (Histogram)agg;
            for (Histogram.Bucket b : h.getBuckets()) {
                buckets.add(new HistogramBucket((Object)b.getKey(), b.getDocCount()));
            }
        } else {
            throw new VertexiumException("Aggregation is not a histogram: " + agg.getClass().getName());
        }
        return new HistogramResult(buckets);
    }

    public TermsResult getTermsResults(String name) {
        ArrayList<TermsBucket> buckets = new ArrayList<TermsBucket>();
        Aggregation agg = this.searchResponse.getAggregations().get(name);
        if (agg == null) {
            return null;
        }
        if (agg instanceof Terms) {
            Terms h = (Terms)agg;
            for (Terms.Bucket b : h.getBuckets()) {
                buckets.add(new TermsBucket((Object)b.getKey(), b.getDocCount()));
            }
        } else {
            throw new VertexiumException("Aggregation is not a terms: " + agg.getClass().getName());
        }
        return new TermsResult(buckets);
    }

    public GeohashResult getGeohashResults(String name) {
        ArrayList<1> buckets = new ArrayList<1>();
        Aggregation agg = this.searchResponse.getAggregations().get(name);
        if (agg == null) {
            return null;
        }
        if (agg instanceof GeoHashGrid) {
            GeoHashGrid h = (GeoHashGrid)agg;
            for (GeoHashGrid.Bucket b : h.getBuckets()) {
                org.elasticsearch.common.geo.GeoPoint g = b.getKeyAsGeoPoint();
                GeohashBucket geohashBucket = new GeohashBucket(b.getKey(), b.getDocCount(), new GeoPoint(g.getLat(), g.getLon())){

                    public GeoRect getGeoCell() {
                        org.elasticsearch.common.geo.GeoPoint northWest = new org.elasticsearch.common.geo.GeoPoint();
                        org.elasticsearch.common.geo.GeoPoint southEast = new org.elasticsearch.common.geo.GeoPoint();
                        GeohashUtils.decodeCell(this.getKey(), northWest, southEast);
                        return new GeoRect(new GeoPoint(northWest.getLat(), northWest.getLon()), new GeoPoint(southEast.getLat(), southEast.getLon()));
                    }
                };
                buckets.add(geohashBucket);
            }
        } else {
            throw new VertexiumException("Aggregation is not a geohash: " + agg.getClass().getName());
        }
        return new GeohashResult(buckets);
    }
}

