/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.DateOnly;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.SearchIndexSecurityGranularity;
import org.neolumin.vertexium.TextIndexHint;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.elasticsearch.ElasticSearchSearchIndexConfiguration;
import org.neolumin.vertexium.elasticsearch.IndexInfo;
import org.neolumin.vertexium.property.StreamingPropertyValue;
import org.neolumin.vertexium.query.DefaultVertexQuery;
import org.neolumin.vertexium.query.GraphQuery;
import org.neolumin.vertexium.query.SimilarToGraphQuery;
import org.neolumin.vertexium.query.VertexQuery;
import org.neolumin.vertexium.search.SearchIndex;
import org.neolumin.vertexium.type.GeoPoint;
import org.neolumin.vertexium.util.IterableUtils;
import org.neolumin.vertexium.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticSearchSearchIndexBase
implements SearchIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchSearchIndexBase.class);
    public static final String ELEMENT_TYPE = "element";
    public static final String ELEMENT_TYPE_FIELD_NAME = "__elementType";
    public static final String VISIBILITY_FIELD_NAME = "__visibility";
    public static final String ELEMENT_TYPE_VERTEX = "vertex";
    public static final String ELEMENT_TYPE_EDGE = "edge";
    public static final String EXACT_MATCH_PROPERTY_NAME_SUFFIX = "_exactMatch";
    public static final String GEO_PROPERTY_NAME_SUFFIX = "_geo";
    private final TransportClient client;
    private final ElasticSearchSearchIndexConfiguration config;
    private final Map<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
    private int indexInfosLastSize = 0;
    private String[] indexNamesAsArray;

    protected ElasticSearchSearchIndexBase(GraphConfiguration config) {
        this.config = new ElasticSearchSearchIndexConfiguration(config);
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        if (this.getConfig().getClusterName() != null) {
            settingsBuilder.put("cluster.name", this.getConfig().getClusterName());
        }
        this.client = new TransportClient(settingsBuilder.build());
        for (String esLocation : this.getConfig().getEsLocations()) {
            int port;
            String hostname;
            String[] locationSocket = esLocation.split(":");
            if (locationSocket.length == 2) {
                hostname = locationSocket[0];
                port = Integer.parseInt(locationSocket[1]);
            } else if (locationSocket.length == 1) {
                hostname = locationSocket[0];
                port = this.getConfig().getPort();
            } else {
                throw new VertexiumException("Invalid elastic search location: " + esLocation);
            }
            this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, port));
        }
        for (String indexName : this.getConfig().getIndicesToQuery()) {
            this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
        }
        this.loadIndexInfos();
        this.loadPropertyDefinitions();
    }

    protected void loadIndexInfos() {
        Set indicesToQuery = IterableUtils.toSet((Object[])this.getConfig().getIndicesToQuery());
        Map indices = ((IndicesStatsResponse)this.client.admin().indices().prepareStats(new String[0]).execute().actionGet()).getIndices();
        for (String indexName : indices.keySet()) {
            if (!indicesToQuery.contains(indexName)) {
                LOGGER.debug("skipping index " + indexName + ", not in indicesToQuery");
                continue;
            }
            IndexInfo indexInfo = this.indexInfos.get(indexName);
            if (indexInfo != null) continue;
            LOGGER.debug("loading index info for " + indexName);
            indexInfo = this.createIndexInfo(indexName);
            this.indexInfos.put(indexName, indexInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexInfo ensureIndexCreatedAndInitialized(String indexName, boolean storeSourceData) {
        IndexInfo indexInfo = this.indexInfos.get(indexName);
        if (indexInfo != null && indexInfo.isElementTypeDefined()) {
            return indexInfo;
        }
        Map<String, IndexInfo> map = this.indexInfos;
        synchronized (map) {
            if (indexInfo == null) {
                if (!((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{indexName}).execute().actionGet()).isExists()) {
                    try {
                        this.createIndex(indexName, storeSourceData);
                    }
                    catch (IOException e) {
                        throw new VertexiumException("Could not create index: " + indexName, (Exception)e);
                    }
                }
                indexInfo = this.createIndexInfo(indexName);
                this.indexInfos.put(indexName, indexInfo);
            }
            this.ensureMappingsCreated(indexInfo);
            return indexInfo;
        }
    }

    protected IndexInfo createIndexInfo(String indexName) {
        return new IndexInfo(indexName);
    }

    protected void ensureMappingsCreated(IndexInfo indexInfo) {
        if (!indexInfo.isElementTypeDefined()) {
            try {
                XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().startObject().startObject("_source").field("enabled", this.getConfig().isStoreSourceData()).endObject().startObject("properties");
                this.createIndexAddFieldsToElementType(mappingBuilder);
                XContentBuilder mapping = mappingBuilder.endObject().endObject();
                PutMappingResponse putMappingResponse = (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setType(ELEMENT_TYPE).setSource(mapping).execute().actionGet();
                LOGGER.debug(putMappingResponse.toString());
                indexInfo.setElementTypeDefined(true);
            }
            catch (IOException e) {
                throw new VertexiumException("Could not add mappings to index: " + indexInfo.getIndexName(), (Exception)e);
            }
        }
    }

    protected void createIndex(String indexName, boolean storeSourceData) throws IOException {
        CreateIndexResponse createResponse = (CreateIndexResponse)this.client.admin().indices().prepareCreate(indexName).execute().actionGet();
        LOGGER.debug(createResponse.toString());
        ClusterHealthResponse health = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[]{indexName}).setWaitForGreenStatus().execute().actionGet();
        LOGGER.debug("Index status: " + health.toString());
        if (health.isTimedOut()) {
            LOGGER.warn("timed out waiting for green index status, for index: " + indexName);
        }
    }

    protected void createIndexAddFieldsToElementType(XContentBuilder builder) throws IOException {
        builder.startObject(ELEMENT_TYPE_FIELD_NAME).field("type", "string").field("store", "true").endObject().startObject(VISIBILITY_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject();
        this.getConfig().getScoringStrategy().addFieldsToElementType(builder);
    }

    public synchronized void loadPropertyDefinitions() {
        for (String indexName : this.indexInfos.keySet()) {
            this.loadPropertyDefinitions(indexName);
        }
    }

    private void loadPropertyDefinitions(String indexName) {
        IndexInfo indexInfo = this.indexInfos.get(indexName);
        Map<String, String> propertyTypes = this.getPropertyTypesFromServer(indexName);
        for (Map.Entry<String, String> property : propertyTypes.entrySet()) {
            PropertyDefinition propertyDefinition = this.createPropertyDefinition(property, propertyTypes);
            indexInfo.addPropertyDefinition(propertyDefinition.getPropertyName(), propertyDefinition);
        }
    }

    private PropertyDefinition createPropertyDefinition(Map.Entry<String, String> property, Map<String, String> propertyTypes) {
        String propertyName = property.getKey();
        Class<GeoPoint> dataType = this.elasticSearchTypeToClass(property.getValue());
        HashSet<TextIndexHint> indexHints = new HashSet<TextIndexHint>();
        if (dataType == String.class) {
            if (propertyTypes.containsKey(propertyName + GEO_PROPERTY_NAME_SUFFIX)) {
                dataType = GeoPoint.class;
                indexHints.add(TextIndexHint.FULL_TEXT);
            } else if (propertyName.endsWith(EXACT_MATCH_PROPERTY_NAME_SUFFIX)) {
                indexHints.add(TextIndexHint.EXACT_MATCH);
                if (propertyTypes.containsKey(propertyName.substring(0, propertyName.length() - EXACT_MATCH_PROPERTY_NAME_SUFFIX.length()))) {
                    indexHints.add(TextIndexHint.FULL_TEXT);
                }
            } else {
                indexHints.add(TextIndexHint.FULL_TEXT);
                if (propertyTypes.containsKey(propertyName + EXACT_MATCH_PROPERTY_NAME_SUFFIX)) {
                    indexHints.add(TextIndexHint.EXACT_MATCH);
                }
            }
        } else if (dataType == GeoPoint.class) {
            indexHints.add(TextIndexHint.FULL_TEXT);
        }
        return new PropertyDefinition(propertyName, (Class)dataType, indexHints);
    }

    private Class elasticSearchTypeToClass(String typeName) {
        if ("string".equals(typeName)) {
            return String.class;
        }
        if ("float".equals(typeName)) {
            return Float.class;
        }
        if ("double".equals(typeName)) {
            return Double.class;
        }
        if ("byte".equals(typeName)) {
            return Byte.class;
        }
        if ("short".equals(typeName)) {
            return Short.class;
        }
        if ("integer".equals(typeName)) {
            return Integer.class;
        }
        if ("date".equals(typeName)) {
            return Date.class;
        }
        if ("long".equals(typeName)) {
            return Long.class;
        }
        if ("boolean".equals(typeName)) {
            return Boolean.class;
        }
        if ("geo_point".equals(typeName)) {
            return GeoPoint.class;
        }
        throw new VertexiumException("Unhandled type: " + typeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> getPropertyTypesFromServer(String indexName) {
        HashMap<String, String> propertyTypes = new HashMap<String, String>();
        try {
            ImmutableOpenMap imd = ((GetMappingsResponse)this.client.admin().indices().prepareGetMappings(new String[]{indexName}).execute().actionGet()).getMappings();
            for (ObjectCursor m : imd.values()) {
                ObjectContainer mappingMetaDatas = ((ImmutableOpenMap)m.value).values();
                for (ObjectCursor mappingMetaData : mappingMetaDatas) {
                    Map sourceAsMap = ((MappingMetaData)mappingMetaData.value).getSourceAsMap();
                    Map properties = (Map)sourceAsMap.get("properties");
                    Iterator i$ = properties.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry propertyObj;
                        Map.Entry property = propertyObj = i$.next();
                        String propertyName = (String)property.getKey();
                        try {
                            Map propertyAttributes = (Map)property.getValue();
                            String propertyType = (String)propertyAttributes.get("type");
                            if (propertyType != null) {
                                propertyTypes.put(propertyName, propertyType);
                                continue;
                            }
                            Map subProperties = (Map)propertyAttributes.get("properties");
                            if (subProperties == null || !subProperties.containsKey("lat") || !subProperties.containsKey("lon")) throw new VertexiumException("Failed to parse property type on property could not determine property type: " + propertyName);
                            propertyTypes.put(propertyName, "geo_point");
                        }
                        catch (Exception ex) {
                            throw new VertexiumException("Failed to parse property type on property: " + propertyName);
                        }
                    }
                }
                continue;
                return propertyTypes;
            }
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not get current properties from elastic search for index " + indexName, ex);
        }
    }

    public abstract void addElement(Graph var1, Element var2, Authorizations var3);

    public abstract void removeElement(Graph var1, Element var2, Authorizations var3);

    public void removeProperty(Graph graph, Element element, Property property, Authorizations authorizations) {
        this.removeProperty(graph, element, property.getKey(), property.getName(), property.getVisibility(), authorizations);
    }

    public void removeProperty(Graph graph, Element element, String propertyKey, String propertyName, Visibility propertyVisibility, Authorizations authorizations) {
        this.addElement(graph, element, authorizations);
    }

    public void addElements(Graph graph, Iterable<? extends Element> elements, Authorizations authorizations) {
        int count = 0;
        for (Element element : elements) {
            if (count % 1000 == 0) {
                LOGGER.debug("adding elements... " + count);
            }
            this.addElement(graph, element, authorizations);
            ++count;
        }
        LOGGER.debug("added " + count + " elements");
    }

    public abstract SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    public abstract GraphQuery queryGraph(Graph var1, String var2, Authorizations var3);

    public boolean isQuerySimilarToTextSupported() {
        return true;
    }

    public abstract SimilarToGraphQuery querySimilarTo(Graph var1, String[] var2, String var3, Authorizations var4);

    public VertexQuery queryVertex(Graph graph, Vertex vertex, String queryString, Authorizations authorizations) {
        return new DefaultVertexQuery(graph, vertex, queryString, this.getAllPropertyDefinitions(), authorizations);
    }

    public Map<String, PropertyDefinition> getAllPropertyDefinitions() {
        HashMap<String, PropertyDefinition> allPropertyDefinitions = new HashMap<String, PropertyDefinition>();
        for (IndexInfo indexInfo : this.indexInfos.values()) {
            allPropertyDefinitions.putAll(indexInfo.getPropertyDefinitions());
        }
        return allPropertyDefinitions;
    }

    public void flush() {
        this.client.admin().indices().prepareFlush(this.getIndexNamesAsArray()).execute().actionGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getIndexNamesAsArray() {
        if (this.indexInfos.size() == this.indexInfosLastSize) {
            return this.indexNamesAsArray;
        }
        ElasticSearchSearchIndexBase elasticSearchSearchIndexBase = this;
        synchronized (elasticSearchSearchIndexBase) {
            Set<String> keys = this.indexInfos.keySet();
            this.indexNamesAsArray = keys.toArray(new String[keys.size()]);
            this.indexInfosLastSize = this.indexInfos.size();
            return this.indexNamesAsArray;
        }
    }

    public void shutdown() {
        this.client.close();
    }

    public void addPropertyDefinition(PropertyDefinition propertyDefinition) throws IOException {
        LOGGER.debug("adding property definition: " + propertyDefinition);
        for (String indexName : this.getIndexNames(propertyDefinition)) {
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
            if (propertyDefinition.getDataType() == String.class) {
                if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                    this.addPropertyToIndex(indexInfo, propertyDefinition.getPropertyName() + EXACT_MATCH_PROPERTY_NAME_SUFFIX, String.class, false, propertyDefinition.getBoost());
                }
                if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                    this.addPropertyToIndex(indexInfo, propertyDefinition.getPropertyName(), String.class, true, propertyDefinition.getBoost());
                }
            } else if (propertyDefinition.getDataType() == GeoPoint.class) {
                this.addPropertyToIndex(indexInfo, propertyDefinition.getPropertyName() + GEO_PROPERTY_NAME_SUFFIX, GeoPoint.class, true, propertyDefinition.getBoost());
                this.addPropertyToIndex(indexInfo, propertyDefinition.getPropertyName(), String.class, true, propertyDefinition.getBoost());
            } else {
                this.addPropertyToIndex(indexInfo, propertyDefinition);
            }
            indexInfo.addPropertyDefinition(propertyDefinition.getPropertyName(), propertyDefinition);
        }
    }

    protected Iterable<String> getIndexNames(PropertyDefinition propertyDefinition) {
        ArrayList<String> indexNames = new ArrayList<String>();
        indexNames.add(this.getConfig().getDefaultIndexName());
        return indexNames;
    }

    protected String getIndexName(Element element) {
        return this.getConfig().getDefaultIndexName();
    }

    public boolean isFieldBoostSupported() {
        return true;
    }

    public IndexInfo addPropertiesToIndex(Element element, Iterable<Property> properties) {
        try {
            String indexName = this.getIndexName(element);
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
            for (Property property : properties) {
                this.addPropertyToIndex(indexInfo, property);
            }
            return indexInfo;
        }
        catch (IOException e) {
            throw new VertexiumException("Could not add properties to index", (Exception)e);
        }
    }

    private void addPropertyToIndex(IndexInfo indexInfo, String propertyName, Class dataType, boolean analyzed) throws IOException {
        this.addPropertyToIndex(indexInfo, propertyName, dataType, analyzed, null);
    }

    private void addPropertyToIndex(IndexInfo indexInfo, PropertyDefinition propertyDefinition) throws IOException {
        this.addPropertyToIndex(indexInfo, propertyDefinition.getPropertyName(), propertyDefinition.getDataType(), true, propertyDefinition.getBoost());
    }

    public void addPropertyToIndex(IndexInfo indexInfo, Property property) throws IOException {
        String propertyName = property.getName();
        if (indexInfo.isPropertyDefined(propertyName)) {
            return;
        }
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            StreamingPropertyValue streamingPropertyValue = (StreamingPropertyValue)propertyValue;
            if (!streamingPropertyValue.isSearchIndex()) {
                return;
            }
            Class dataType = streamingPropertyValue.getValueType();
            this.addPropertyToIndex(indexInfo, propertyName, dataType, true);
        } else if (propertyValue instanceof String) {
            Class<String> dataType = String.class;
            this.addPropertyToIndex(indexInfo, propertyName + EXACT_MATCH_PROPERTY_NAME_SUFFIX, dataType, false);
            this.addPropertyToIndex(indexInfo, propertyName, dataType, true);
        } else if (propertyValue instanceof GeoPoint) {
            this.addPropertyToIndex(indexInfo, propertyName + GEO_PROPERTY_NAME_SUFFIX, GeoPoint.class, true);
            this.addPropertyToIndex(indexInfo, propertyName, String.class, true);
        } else {
            Preconditions.checkNotNull((Object)propertyValue, (Object)("property value cannot be null for property: " + propertyName));
            Class<?> dataType = propertyValue.getClass();
            this.addPropertyToIndex(indexInfo, propertyName, dataType, true);
        }
    }

    protected abstract void addPropertyToIndex(IndexInfo var1, String var2, Class var3, boolean var4, Double var5) throws IOException;

    protected boolean shouldIgnoreType(Class dataType) {
        return dataType == byte[].class;
    }

    public TransportClient getClient() {
        return this.client;
    }

    public ElasticSearchSearchIndexConfiguration getConfig() {
        return this.config;
    }

    protected void addTypeToMapping(XContentBuilder mapping, String propertyName, Class dataType, boolean analyzed, Double boost) throws IOException {
        if (dataType == String.class) {
            LOGGER.debug("Registering string type for {}", (Object)propertyName);
            mapping.field("type", "string");
            if (!analyzed) {
                mapping.field("index", "not_analyzed");
            }
        } else if (dataType == Float.class) {
            LOGGER.debug("Registering float type for {}", (Object)propertyName);
            mapping.field("type", "float");
        } else if (dataType == Double.class) {
            LOGGER.debug("Registering double type for {}", (Object)propertyName);
            mapping.field("type", "double");
        } else if (dataType == Byte.class) {
            LOGGER.debug("Registering byte type for {}", (Object)propertyName);
            mapping.field("type", "byte");
        } else if (dataType == Short.class) {
            LOGGER.debug("Registering short type for {}", (Object)propertyName);
            mapping.field("type", "short");
        } else if (dataType == Integer.class) {
            LOGGER.debug("Registering integer type for {}", (Object)propertyName);
            mapping.field("type", "integer");
        } else if (dataType == Date.class || dataType == DateOnly.class) {
            LOGGER.debug("Registering date type for {}", (Object)propertyName);
            mapping.field("type", "date");
        } else if (dataType == Long.class) {
            LOGGER.debug("Registering long type for {}", (Object)propertyName);
            mapping.field("type", "long");
        } else if (dataType == Boolean.class) {
            LOGGER.debug("Registering boolean type for {}", (Object)propertyName);
            mapping.field("type", "boolean");
        } else if (dataType == GeoPoint.class) {
            LOGGER.debug("Registering geo_point type for {}", (Object)propertyName);
            mapping.field("type", "geo_point");
        } else if (Number.class.isAssignableFrom(dataType)) {
            LOGGER.debug("Registering double type for {}", (Object)propertyName);
            mapping.field("type", "double");
        } else {
            throw new VertexiumException("Unexpected value type for property \"" + propertyName + "\": " + dataType.getName());
        }
        if (boost != null) {
            mapping.field("boost", boost.doubleValue());
        }
    }

    protected void doBulkRequest(BulkRequest bulkRequest) {
        BulkResponse response = (BulkResponse)this.getClient().bulk(bulkRequest).actionGet();
        if (response.hasFailures()) {
            for (BulkItemResponse bulkResponse : response) {
                if (!bulkResponse.isFailed()) continue;
                LOGGER.error("Failed to index " + bulkResponse.getId() + " (message: " + bulkResponse.getFailureMessage() + ")");
            }
            throw new VertexiumException("Could not add element.");
        }
    }

    public synchronized void clearData() {
        Set<String> indexInfosSet = this.indexInfos.keySet();
        for (String indexName : indexInfosSet) {
            try {
                DeleteIndexRequest deleteRequest = new DeleteIndexRequest(indexName);
                this.getClient().admin().indices().delete(deleteRequest).actionGet();
                this.indexInfos.remove(indexName);
            }
            catch (Exception ex) {
                throw new VertexiumException("Could not delete index " + indexName, ex);
            }
            this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
        }
        this.loadPropertyDefinitions();
    }

    public abstract void addElementToBulkRequest(Graph var1, BulkRequest var2, IndexInfo var3, Element var4, Authorizations var5);
}

