/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.elasticsearch.score.EdgeCountScoringStrategy;
import org.neolumin.vertexium.elasticsearch.score.ScoringStrategy;
import org.neolumin.vertexium.util.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchSearchIndexConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchSearchIndexConfiguration.class);
    public static final String CONFIG_STORE_SOURCE_DATA = "storeSourceData";
    public static final boolean DEFAULT_STORE_SOURCE_DATA = false;
    public static final String CONFIG_ES_LOCATIONS = "locations";
    public static final String CONFIG_INDEX_NAME = "indexName";
    public static final String DEFAULT_INDEX_NAME = "vertexium";
    public static final String CONFIG_INDICES_TO_QUERY = "indicesToQuery";
    public static final String CONFIG_INDEX_EDGES = "indexEdges";
    public static final boolean DEFAULT_INDEX_EDGES = true;
    public static final boolean DEFAULT_AUTO_FLUSH = false;
    public static final String CONFIG_CLUSTER_NAME = "clusterName";
    public static final String DEFAULT_CLUSTER_NAME = null;
    public static final String CONFIG_PORT = "port";
    public static final int DEFAULT_PORT = 9300;
    public static final String CONFIG_SCORING_STRATEGY_CLASS_NAME = "scoringStrategy";
    public static final Class<? extends ScoringStrategy> DEFAULT_SCORING_STRATEGY = EdgeCountScoringStrategy.class;
    private final boolean autoFlush;
    private final boolean storeSourceData;
    private final String[] esLocations;
    private final String defaultIndexName;
    private final String[] indicesToQuery;
    private final boolean indexEdges;
    private final String clusterName;
    private final int port;
    private ScoringStrategy scoringStrategy;

    public ElasticSearchSearchIndexConfiguration(GraphConfiguration config) {
        this.esLocations = ElasticSearchSearchIndexConfiguration.getElasticSearchLocations(config);
        this.defaultIndexName = ElasticSearchSearchIndexConfiguration.getDefaultIndexName(config);
        this.indicesToQuery = ElasticSearchSearchIndexConfiguration.getIndicesToQuery(config, this.defaultIndexName);
        this.indexEdges = this.getIndexEdges(config);
        this.storeSourceData = ElasticSearchSearchIndexConfiguration.getStoreSourceData(config);
        this.autoFlush = ElasticSearchSearchIndexConfiguration.getAutoFlush(config);
        this.clusterName = ElasticSearchSearchIndexConfiguration.getClusterName(config);
        this.port = ElasticSearchSearchIndexConfiguration.getPort(config);
        this.scoringStrategy = ElasticSearchSearchIndexConfiguration.getScoringStrategy(config);
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public boolean isStoreSourceData() {
        return this.storeSourceData;
    }

    public String[] getEsLocations() {
        return this.esLocations;
    }

    public String getDefaultIndexName() {
        return this.defaultIndexName;
    }

    public String[] getIndicesToQuery() {
        return this.indicesToQuery;
    }

    public boolean isIndexEdges() {
        return this.indexEdges;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getPort() {
        return this.port;
    }

    public ScoringStrategy getScoringStrategy() {
        return this.scoringStrategy;
    }

    private static boolean getAutoFlush(GraphConfiguration config) {
        boolean autoFlush = config.getBoolean("autoFlush", false);
        LOGGER.info("Auto flush: " + autoFlush);
        return autoFlush;
    }

    private static boolean getStoreSourceData(GraphConfiguration config) {
        boolean storeSourceData = config.getBoolean("search.storeSourceData", false);
        LOGGER.info("Store source data: " + storeSourceData);
        return storeSourceData;
    }

    private boolean getIndexEdges(GraphConfiguration config) {
        boolean indexEdges = config.getBoolean("search.indexEdges", true);
        LOGGER.info("index edges: " + indexEdges);
        return indexEdges;
    }

    private static String[] getIndicesToQuery(GraphConfiguration config, String defaultIndexName) {
        String[] indicesToQuery;
        String indicesToQueryString = config.getString("search.indicesToQuery", null);
        if (indicesToQueryString == null) {
            indicesToQuery = new String[]{defaultIndexName};
        } else {
            indicesToQuery = indicesToQueryString.split(",");
            for (int i = 0; i < indicesToQuery.length; ++i) {
                indicesToQuery[i] = indicesToQuery[i].trim();
            }
        }
        if (LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indicesToQuery.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(indicesToQuery[i]);
            }
            LOGGER.info("Indices to query: " + sb.toString());
        }
        return indicesToQuery;
    }

    private static String[] getElasticSearchLocations(GraphConfiguration config) {
        String esLocationsString = config.getString("search.locations", null);
        if (esLocationsString == null) {
            throw new VertexiumException("search.locations is a required configuration parameter");
        }
        LOGGER.info("Using elastic search locations: " + esLocationsString);
        return esLocationsString.split(",");
    }

    private static String getDefaultIndexName(GraphConfiguration config) {
        String defaultIndexName = config.getString("search.indexName", DEFAULT_INDEX_NAME);
        LOGGER.info("Default index name: " + defaultIndexName);
        return defaultIndexName;
    }

    private static String getClusterName(GraphConfiguration config) {
        String clusterName = config.getString("search.clusterName", DEFAULT_CLUSTER_NAME);
        LOGGER.info("Cluster name: " + clusterName);
        return clusterName;
    }

    private static int getPort(GraphConfiguration config) {
        int port = config.getInt("search.port", 9300);
        LOGGER.info("Port: " + port);
        return port;
    }

    private static ScoringStrategy getScoringStrategy(GraphConfiguration config) {
        String className = config.getString("search.scoringStrategy", DEFAULT_SCORING_STRATEGY.getName());
        return (ScoringStrategy)ConfigurationUtils.createProvider((String)className, (GraphConfiguration)config);
    }
}

