/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.lang.reflect.Method;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.neolumin.vertexium.VertexiumException;

class GeohashUtils {
    private static final Method decodeCell;

    GeohashUtils() {
    }

    public static void decodeCell(String key, GeoPoint northWest, GeoPoint southEast) {
        try {
            double[] interval = (double[])decodeCell.invoke(null, key);
            northWest.reset(interval[1], interval[2]);
            southEast.reset(interval[0], interval[3]);
        }
        catch (Exception e) {
            throw new VertexiumException("Could not decode cell", e);
        }
    }

    static {
        try {
            decodeCell = GeoHashUtils.class.getDeclaredMethod("decodeCell", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new VertexiumException("Could not find decodeCell method", (Exception)e);
        }
    }
}

