/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch.score;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.index.query.functionscore.script.ScriptScoreFunctionBuilder;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Direction;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.elasticsearch.BulkRequestWithCount;
import org.neolumin.vertexium.elasticsearch.ElasticSearchSearchIndexBase;
import org.neolumin.vertexium.elasticsearch.IndexInfo;
import org.neolumin.vertexium.elasticsearch.score.EdgeCountScoringStrategyConfiguration;
import org.neolumin.vertexium.elasticsearch.score.ScoringStrategy;
import org.neolumin.vertexium.elasticsearch.utils.GetResponseUtil;
import org.neolumin.vertexium.search.SearchIndex;

public class EdgeCountScoringStrategy
extends ScoringStrategy {
    private final EdgeCountScoringStrategyConfiguration config;

    public EdgeCountScoringStrategy(GraphConfiguration config) {
        super(config);
        this.config = new EdgeCountScoringStrategyConfiguration(config);
    }

    public EdgeCountScoringStrategyConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void addElement(SearchIndex searchIndex, Graph graph, Element element, Authorizations authorizations) {
        Vertex vIn;
        if (!this.getConfig().isUpdateEdgeBoost()) {
            return;
        }
        if (!(element instanceof Edge)) {
            return;
        }
        Vertex vOut = ((Edge)element).getVertex(Direction.OUT, authorizations);
        if (vOut != null) {
            searchIndex.addElement(graph, (Element)vOut, authorizations);
        }
        if ((vIn = ((Edge)element).getVertex(Direction.IN, authorizations)) != null) {
            searchIndex.addElement(graph, (Element)vIn, authorizations);
        }
    }

    @Override
    public int addElement(ElasticSearchSearchIndexBase searchIndex, Graph graph, BulkRequestWithCount bulkRequestWithCount, IndexInfo indexInfo, Element element, Authorizations authorizations) {
        Vertex vIn;
        int totalCount = 0;
        if (!this.getConfig().isUpdateEdgeBoost()) {
            return totalCount;
        }
        if (!(element instanceof Edge)) {
            return totalCount;
        }
        Vertex vOut = ((Edge)element).getVertex(Direction.OUT, authorizations);
        if (vOut != null) {
            searchIndex.addElementToBulkRequest(graph, bulkRequestWithCount.getBulkRequest(), indexInfo, (Element)vOut, authorizations);
            bulkRequestWithCount.incrementCount();
            ++totalCount;
        }
        if ((vIn = ((Edge)element).getVertex(Direction.IN, authorizations)) != null) {
            searchIndex.addElementToBulkRequest(graph, bulkRequestWithCount.getBulkRequest(), indexInfo, (Element)vIn, authorizations);
            bulkRequestWithCount.incrementCount();
            ++totalCount;
        }
        return totalCount;
    }

    @Override
    public void addFieldsToElementType(XContentBuilder builder) throws IOException {
        builder.startObject("__inEdgeCount").field("type", "integer").field("store", "true").endObject().startObject("__outEdgeCount").field("type", "integer").field("store", "true").endObject();
    }

    @Override
    public List<String> getFieldNames() {
        List<String> fieldNames = super.getFieldNames();
        fieldNames.add("__inEdgeCount");
        fieldNames.add("__outEdgeCount");
        return fieldNames;
    }

    @Override
    public QueryBuilder updateQuery(QueryBuilder query) {
        if (!this.getConfig().isUseEdgeBoost()) {
            return query;
        }
        ScriptScoreFunctionBuilder scoreFunction = ScoreFunctionBuilders.scriptFunction((String)this.getConfig().getScoreFormula(), (String)"groovy").param("inEdgeMultiplier", (Object)this.getConfig().getInEdgeBoost()).param("outEdgeMultiplier", (Object)this.getConfig().getOutEdgeBoost());
        return QueryBuilders.functionScoreQuery((QueryBuilder)query, (ScoreFunctionBuilder)scoreFunction);
    }

    @Override
    public boolean addFieldsToVertexDocument(SearchIndex searchIndex, XContentBuilder jsonBuilder, Vertex vertex, GetResponse existingDocument, Authorizations authorizations) throws IOException {
        Long existingOutEdgeCount;
        Long existingInEdgeCount;
        if (existingDocument != null && !this.getConfig().isUpdateEdgeBoost()) {
            return false;
        }
        boolean changed = false;
        int inEdgeCount = vertex.getEdgeCount(Direction.IN, authorizations);
        Long l = existingInEdgeCount = existingDocument == null ? null : GetResponseUtil.getFieldValueLong(existingDocument, "__inEdgeCount");
        if (existingInEdgeCount == null || existingInEdgeCount.intValue() != inEdgeCount) {
            jsonBuilder.field("__inEdgeCount", inEdgeCount);
            changed = true;
        } else {
            jsonBuilder.field("__inEdgeCount", existingInEdgeCount.intValue());
        }
        int outEdgeCount = vertex.getEdgeCount(Direction.OUT, authorizations);
        Long l2 = existingOutEdgeCount = existingDocument == null ? null : GetResponseUtil.getFieldValueLong(existingDocument, "__outEdgeCount");
        if (existingOutEdgeCount == null || existingOutEdgeCount.intValue() != outEdgeCount) {
            jsonBuilder.field("__outEdgeCount", outEdgeCount);
            changed = true;
        } else {
            jsonBuilder.field("__outEdgeCount", existingOutEdgeCount.intValue());
        }
        return changed;
    }

    @Override
    public boolean addFieldsToEdgeDocument(SearchIndex searchIndex, XContentBuilder jsonBuilder, Edge edge, GetResponse existingDocument, Authorizations authorizations) throws IOException {
        return false;
    }
}

