/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch.score;

import org.neolumin.vertexium.GraphConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeCountScoringStrategyConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeCountScoringStrategyConfiguration.class);
    public static final String IN_EDGE_COUNT_FIELD_NAME = "__inEdgeCount";
    public static final String OUT_EDGE_COUNT_FIELD_NAME = "__outEdgeCount";
    public static final String CONFIG_USE_EDGE_BOOST = "useEdgeBoost";
    public static final boolean DEFAULT_USE_EDGE_BOOST = true;
    public static final String CONFIG_UPDATE_EDGE_BOOST = "updateEdgeBoost";
    public static final boolean DEFAULT_UPDATE_EDGE_BOOST = true;
    public static final String CONFIG_IN_EDGE_BOOST = "inEdgeBoost";
    public static final double DEFAULT_IN_EDGE_BOOST = 1.2;
    public static final String CONFIG_OUT_EDGE_BOOST = "outEdgeBoost";
    public static final double DEFAULT_OUT_EDGE_BOOST = 1.1;
    public static final String CONFIG_SCORE_FORMULA = "formula";
    public static final String DEFAULT_SCORE_FORMULA = "_score  * sqrt(     1    + (inEdgeMultiplier * doc['__inEdgeCount'].value)     + (outEdgeMultiplier * doc['__outEdgeCount'].value)    )";
    private final boolean useEdgeBoost;
    private final boolean updateEdgeBoost;
    private final double inEdgeBoost;
    private final double outEdgeBoost;
    private final String scoreFormula;

    public EdgeCountScoringStrategyConfiguration(GraphConfiguration config) {
        this.useEdgeBoost = EdgeCountScoringStrategyConfiguration.getUseEdgeBoost(config);
        this.updateEdgeBoost = EdgeCountScoringStrategyConfiguration.getUpdateEdgeBoost(config);
        this.inEdgeBoost = EdgeCountScoringStrategyConfiguration.getInEdgeBoost(config);
        this.outEdgeBoost = EdgeCountScoringStrategyConfiguration.getOutEdgeBoost(config);
        this.scoreFormula = EdgeCountScoringStrategyConfiguration.getScoreFormula(config);
    }

    public boolean isUseEdgeBoost() {
        return this.useEdgeBoost;
    }

    public boolean isUpdateEdgeBoost() {
        return this.isUseEdgeBoost() && this.updateEdgeBoost;
    }

    public double getInEdgeBoost() {
        return this.inEdgeBoost;
    }

    public double getOutEdgeBoost() {
        return this.outEdgeBoost;
    }

    public String getScoreFormula() {
        return this.scoreFormula;
    }

    private static boolean getUseEdgeBoost(GraphConfiguration config) {
        boolean useEdgeBoost = config.getBoolean("search.useEdgeBoost", true);
        LOGGER.info("Use edge boost: " + useEdgeBoost);
        return useEdgeBoost;
    }

    private static boolean getUpdateEdgeBoost(GraphConfiguration config) {
        boolean updateEdgeBoost = config.getBoolean("search.updateEdgeBoost", true);
        LOGGER.info("Update edge boost: " + updateEdgeBoost);
        return updateEdgeBoost;
    }

    private static double getOutEdgeBoost(GraphConfiguration config) {
        double outEdgeBoost = config.getDouble("search.outEdgeBoost", 1.1);
        LOGGER.info("Out Edge Boost: " + outEdgeBoost);
        return outEdgeBoost;
    }

    private static double getInEdgeBoost(GraphConfiguration config) {
        double inEdgeBoost = config.getDouble("search.inEdgeBoost", 1.2);
        LOGGER.info("In Edge Boost: " + inEdgeBoost);
        return inEdgeBoost;
    }

    private static String getScoreFormula(GraphConfiguration config) {
        String scoreFormula = config.getString("search.formula", DEFAULT_SCORE_FORMULA);
        LOGGER.info("Score formula: " + scoreFormula);
        return scoreFormula;
    }
}

