/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.HasChildQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.elasticsearch.AuthorizationFilterBuilder;
import org.neolumin.vertexium.elasticsearch.ElasticSearchGraphQueryBase;
import org.neolumin.vertexium.elasticsearch.score.ScoringStrategy;
import org.neolumin.vertexium.query.QueryParameters;
import org.neolumin.vertexium.query.QueryStringQueryParameters;
import org.neolumin.vertexium.query.SimilarToTextQueryParameters;

public class ElasticSearchParentChildGraphQuery
extends ElasticSearchGraphQueryBase {
    protected ElasticSearchParentChildGraphQuery(TransportClient client, String[] indicesToQuery, Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, Authorizations authorizations) {
        super(client, indicesToQuery, graph, queryString, propertyDefinitions, scoringStrategy, false, authorizations);
    }

    protected ElasticSearchParentChildGraphQuery(TransportClient client, String[] indicesToQuery, Graph graph, String[] similarToFields, String similarToText, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, Authorizations authorizations) {
        super(client, indicesToQuery, graph, similarToFields, similarToText, propertyDefinitions, scoringStrategy, false, authorizations);
    }

    protected QueryBuilder createQuery(QueryParameters queryParameters, String elementType, List<FilterBuilder> filters) {
        QueryBuilder childQuery;
        TermsFilterBuilder elementTypeFilter = this.createElementTypeFilter(elementType);
        AndFilterBuilder andFilterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{elementTypeFilter, new AuthorizationFilterBuilder(this.getParameters().getAuthorizations().getAuthorizations())});
        AuthorizationFilterBuilder authorizationFilterBuilder = new AuthorizationFilterBuilder(this.getParameters().getAuthorizations().getAuthorizations());
        if (queryParameters instanceof QueryStringQueryParameters) {
            childQuery = this.createQueryStringQuery((QueryStringQueryParameters)queryParameters, elementType, filters, authorizationFilterBuilder);
        } else if (queryParameters instanceof SimilarToTextQueryParameters) {
            childQuery = this.createSimilarToTextQuery((SimilarToTextQueryParameters)queryParameters, elementType, filters, authorizationFilterBuilder);
        } else {
            throw new VertexiumException("Query parameters not supported of type: " + queryParameters.getClass().getName());
        }
        return QueryBuilders.filteredQuery((QueryBuilder)childQuery, (FilterBuilder)andFilterBuilder);
    }

    private QueryBuilder createSimilarToTextQuery(SimilarToTextQueryParameters queryParameters, String elementType, List<FilterBuilder> filters, AuthorizationFilterBuilder authorizationFilterBuilder) {
        BoolQueryBuilder boolChildQuery = QueryBuilders.boolQuery();
        boolChildQuery.must((QueryBuilder)new HasChildQueryBuilder("property", (QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)super.createQuery((QueryParameters)queryParameters, elementType, filters), (FilterBuilder)authorizationFilterBuilder)).scoreType("avg"));
        this.addFiltersToQuery(boolChildQuery, filters, authorizationFilterBuilder);
        return boolChildQuery;
    }

    private QueryBuilder createQueryStringQuery(QueryStringQueryParameters queryParameters, String elementType, List<FilterBuilder> filters, AuthorizationFilterBuilder authorizationFilterBuilder) {
        String queryString = queryParameters.getQueryString();
        if ((queryString == null || queryString.length() <= 0) && filters.size() <= 0) {
            return QueryBuilders.matchAllQuery();
        }
        BoolQueryBuilder boolChildQuery = QueryBuilders.boolQuery();
        if (queryString != null && queryString.length() > 0) {
            boolChildQuery.must((QueryBuilder)new HasChildQueryBuilder("property", (QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)super.createQuery((QueryParameters)queryParameters, elementType, filters), (FilterBuilder)authorizationFilterBuilder)).scoreType("avg"));
        }
        this.addFiltersToQuery(boolChildQuery, filters, authorizationFilterBuilder);
        return boolChildQuery;
    }

    private void addFiltersToQuery(BoolQueryBuilder boolChildQuery, List<FilterBuilder> filters, AuthorizationFilterBuilder authorizationFilterBuilder) {
        for (FilterBuilder filterBuilder : filters) {
            boolChildQuery.must((QueryBuilder)new HasChildQueryBuilder("property", (QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{authorizationFilterBuilder, filterBuilder}))).scoreType("avg"));
        }
    }

    protected void addElementTypeFilter(List<FilterBuilder> filters, String elementType) {
    }

    protected SearchRequestBuilder getSearchRequestBuilder(List<FilterBuilder> filters, QueryBuilder queryBuilder) {
        return this.getClient().prepareSearch(this.getIndicesToQuery()).setTypes(new String[]{"element"}).setQuery(queryBuilder).setFrom((int)this.getParameters().getSkip()).setSize((int)this.getParameters().getLimit());
    }

    protected void addNotFilter(List<FilterBuilder> filters, String key, Object value) {
        filters.add((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.existsFilter((String)key), FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])new Object[]{value}))}));
    }
}

