/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.neolumin.vertexium.Authorizations;
import org.neolumin.vertexium.DateOnly;
import org.neolumin.vertexium.Edge;
import org.neolumin.vertexium.Element;
import org.neolumin.vertexium.Graph;
import org.neolumin.vertexium.GraphConfiguration;
import org.neolumin.vertexium.Property;
import org.neolumin.vertexium.PropertyDefinition;
import org.neolumin.vertexium.SearchIndexSecurityGranularity;
import org.neolumin.vertexium.TextIndexHint;
import org.neolumin.vertexium.Vertex;
import org.neolumin.vertexium.VertexiumException;
import org.neolumin.vertexium.Visibility;
import org.neolumin.vertexium.elasticsearch.BulkRequestWithCount;
import org.neolumin.vertexium.elasticsearch.ElasticSearchParentChildGraphQuery;
import org.neolumin.vertexium.elasticsearch.ElasticSearchSearchIndexBase;
import org.neolumin.vertexium.elasticsearch.IndexInfo;
import org.neolumin.vertexium.elasticsearch.ParentChildIndexInfo;
import org.neolumin.vertexium.elasticsearch.utils.GetResponseUtil;
import org.neolumin.vertexium.property.StreamingPropertyValue;
import org.neolumin.vertexium.query.GraphQuery;
import org.neolumin.vertexium.query.SimilarToGraphQuery;
import org.neolumin.vertexium.search.SearchIndex;
import org.neolumin.vertexium.type.GeoPoint;
import org.neolumin.vertexium.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchParentChildSearchIndex
extends ElasticSearchSearchIndexBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchParentChildSearchIndex.class);
    public static final String PROPERTY_TYPE = "property";
    public static final int BATCH_SIZE = 1000;
    private String[] parentDocumentFields;

    public ElasticSearchParentChildSearchIndex(GraphConfiguration config) {
        super(config);
    }

    protected void ensureMappingsCreated(IndexInfo indexInfo) {
        ParentChildIndexInfo parentChildIndexInfo = (ParentChildIndexInfo)indexInfo;
        super.ensureMappingsCreated(indexInfo);
        if (!parentChildIndexInfo.isPropertyTypeDefined()) {
            try {
                XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().startObject().startObject("_parent").field("type", "element").endObject().startObject("_source").field("enabled", this.getConfig().isStoreSourceData()).endObject().startObject("properties").startObject("__visibility").field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject();
                XContentBuilder mapping = mappingBuilder.endObject().endObject();
                PutMappingResponse putMappingResponse = (PutMappingResponse)this.getClient().admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setIgnoreConflicts(false).setType(PROPERTY_TYPE).setSource(mapping).execute().actionGet();
                LOGGER.debug(putMappingResponse.toString());
                parentChildIndexInfo.setPropertyTypeDefined(true);
            }
            catch (IOException e) {
                throw new VertexiumException("Could not add mappings to index: " + indexInfo.getIndexName(), (Exception)e);
            }
        }
    }

    protected IndexInfo createIndexInfo(String indexName) {
        return new ParentChildIndexInfo(indexName);
    }

    protected void createIndexAddFieldsToElementType(XContentBuilder builder) throws IOException {
        super.createIndexAddFieldsToElementType(builder);
        builder.startObject("__visibility").field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject();
    }

    public void removeElement(Graph graph, Element element, Authorizations authorizations) {
        String indexName = this.getIndexName(element);
        this.deleteChildDocuments(indexName, element);
        this.deleteParentDocument(indexName, element);
    }

    private void deleteChildDocuments(String indexName, Element element) {
        String parentId = element.getId();
        DeleteByQueryResponse response = (DeleteByQueryResponse)this.getClient().prepareDeleteByQuery(new String[]{indexName}).setTypes(new String[]{PROPERTY_TYPE}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_parent", (String)("element#" + parentId))).execute().actionGet();
        if (response.status() != RestStatus.OK) {
            throw new VertexiumException("Could not remove child elements " + element.getId() + " (status: " + response.status() + ")");
        }
        if (LOGGER.isDebugEnabled()) {
            for (IndexDeleteByQueryResponse r : response) {
                LOGGER.debug("deleted child document " + r.toString());
            }
        }
    }

    private void deleteParentDocument(String indexName, Element element) {
        String id = element.getId();
        LOGGER.debug("deleting parent document " + id);
        DeleteResponse deleteResponse = (DeleteResponse)this.getClient().delete((DeleteRequest)this.getClient().prepareDelete(indexName, "element", id).request()).actionGet();
        if (!deleteResponse.isFound()) {
            LOGGER.warn("Could not remove element " + element.getId());
        }
    }

    public void removeProperty(Graph graph, Element element, String propertyKey, String propertyName, Visibility propertyVisibility, Authorizations authorizations) {
        String propertyString = propertyKey + ":" + propertyName + ":" + propertyVisibility.getVisibilityString();
        String indexName = this.getIndexName(element);
        String id = this.getChildDocId(element, propertyKey, propertyName, propertyVisibility);
        DeleteResponse deleteResponse = (DeleteResponse)this.getClient().delete((DeleteRequest)this.getClient().prepareDelete(indexName, PROPERTY_TYPE, id).request()).actionGet();
        if (!deleteResponse.isFound()) {
            LOGGER.warn("Could not remove property " + element.getId() + " " + propertyString);
        }
        LOGGER.debug("deleted property " + element.getId() + " " + propertyString);
    }

    public void addElement(Graph graph, Element element, Authorizations authorizations) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("addElement: " + element.getId());
        }
        if (!this.getConfig().isIndexEdges() && element instanceof Edge) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("skipping edge: " + element.getId());
            }
            return;
        }
        IndexInfo indexInfo = this.addPropertiesToIndex(element, element.getProperties());
        try {
            BulkRequest bulkRequest = new BulkRequest();
            this.addElementToBulkRequest(graph, bulkRequest, indexInfo, element, authorizations);
            if (bulkRequest.numberOfActions() > 0) {
                this.doBulkRequest(bulkRequest);
                if (this.getConfig().isAutoFlush()) {
                    this.flush();
                }
            }
        }
        catch (Exception e) {
            throw new VertexiumException("Could not add element", e);
        }
        this.getConfig().getScoringStrategy().addElement((SearchIndex)this, graph, element, authorizations);
    }

    public void addElements(Graph graph, Iterable<? extends Element> elements, Authorizations authorizations) {
        int totalCount = 0;
        HashMap<IndexInfo, BulkRequestWithCount> bulkRequests = new HashMap<IndexInfo, BulkRequestWithCount>();
        for (Element element : elements) {
            String indexName = this.getIndexName(element);
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
            BulkRequestWithCount bulkRequestWithCount = (BulkRequestWithCount)bulkRequests.get(indexInfo);
            if (bulkRequestWithCount == null) {
                bulkRequestWithCount = new BulkRequestWithCount();
                bulkRequests.put(indexInfo, bulkRequestWithCount);
            }
            if (bulkRequestWithCount.getCount() >= 1000) {
                LOGGER.debug("adding elements... " + totalCount);
                this.doBulkRequest(bulkRequestWithCount.getBulkRequest());
                bulkRequestWithCount.clear();
            }
            this.addElementToBulkRequest(graph, bulkRequestWithCount.getBulkRequest(), indexInfo, element, authorizations);
            bulkRequestWithCount.incrementCount();
            ++totalCount;
            totalCount += this.getConfig().getScoringStrategy().addElement((ElasticSearchSearchIndexBase)this, graph, bulkRequestWithCount, indexInfo, element, authorizations);
        }
        for (BulkRequestWithCount bulkRequestWithCount : bulkRequests.values()) {
            if (bulkRequestWithCount.getCount() <= 0) continue;
            this.doBulkRequest(bulkRequestWithCount.getBulkRequest());
        }
        LOGGER.debug("added " + totalCount + " elements");
        if (this.getConfig().isAutoFlush()) {
            this.flush();
        }
    }

    public void addElementToBulkRequest(Graph graph, BulkRequest bulkRequest, IndexInfo indexInfo, Element element, Authorizations authorizations) {
        try {
            IndexRequest parentDocumentIndexRequest = this.getParentDocumentIndexRequest(indexInfo, element, authorizations);
            if (parentDocumentIndexRequest != null) {
                bulkRequest.add(parentDocumentIndexRequest);
            }
            for (Property property : element.getProperties()) {
                IndexRequest propertyIndexRequest = this.getPropertyDocumentIndexRequest(indexInfo, element, property);
                if (propertyIndexRequest == null) continue;
                bulkRequest.add(propertyIndexRequest);
            }
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not add element to bulk request", (Exception)ex);
        }
    }

    public IndexRequest getPropertyDocumentIndexRequest(Element element, Property property) throws IOException {
        String indexName = this.getIndexName(element);
        IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
        return this.getPropertyDocumentIndexRequest(indexInfo, element, property);
    }

    private IndexRequest getPropertyDocumentIndexRequest(IndexInfo indexInfo, Element element, Property property) throws IOException {
        XContentBuilder jsonBuilder = this.buildJsonContentFromProperty(indexInfo, property);
        if (jsonBuilder == null) {
            return null;
        }
        String id = this.getChildDocId(element, property);
        IndexRequestBuilder builder = this.getClient().prepareIndex(indexInfo.getIndexName(), PROPERTY_TYPE, id);
        builder = builder.setParent(element.getId());
        builder = builder.setSource(jsonBuilder);
        return (IndexRequest)builder.request();
    }

    private String getChildDocId(Element element, Property property) {
        return this.getChildDocId(element, property.getKey(), property.getName(), property.getVisibility());
    }

    private String getChildDocId(Element element, String key, String name, Visibility visibility) {
        return element.getId() + "_" + name + "_" + key;
    }

    public IndexRequest getParentDocumentIndexRequest(Element element, Authorizations authorizations) throws IOException {
        String indexName = this.getIndexName(element);
        IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.getConfig().isStoreSourceData());
        return this.getParentDocumentIndexRequest(indexInfo, element, authorizations);
    }

    private IndexRequest getParentDocumentIndexRequest(IndexInfo indexInfo, Element element, Authorizations authorizations) throws IOException {
        boolean changed = false;
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
        String id = element.getId();
        GetResponse existingParentDocument = this.getParentDocument(indexInfo, element.getId());
        if (existingParentDocument == null) {
            changed = true;
        }
        if (element instanceof Vertex) {
            jsonBuilder.field("__elementType", "vertex");
            if (this.getConfig().getScoringStrategy().addFieldsToVertexDocument((SearchIndex)this, jsonBuilder, (Vertex)element, existingParentDocument, authorizations)) {
                changed = true;
            }
        } else if (element instanceof Edge) {
            jsonBuilder.field("__elementType", "edge");
            if (this.getConfig().getScoringStrategy().addFieldsToEdgeDocument((SearchIndex)this, jsonBuilder, (Edge)element, existingParentDocument, authorizations)) {
                changed = true;
            }
        } else {
            throw new VertexiumException("Unexpected element type " + element.getClass().getName());
        }
        String visibilityString = element.getVisibility().getVisibilityString();
        jsonBuilder.field("__visibility", visibilityString);
        if (existingParentDocument == null || !visibilityString.equals(GetResponseUtil.getFieldValueString((GetResponse)existingParentDocument, (String)"__visibility"))) {
            changed = true;
        }
        if (!changed) {
            return null;
        }
        return new IndexRequest(indexInfo.getIndexName(), "element", id).source(jsonBuilder);
    }

    private GetResponse getParentDocument(IndexInfo indexInfo, String elementId) {
        try {
            GetResponse response = (GetResponse)this.getClient().prepareGet(indexInfo.getIndexName(), "element", elementId).setFields(this.getParentDocumentFields()).execute().get();
            if (!response.isExists()) {
                return null;
            }
            return response;
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not get parent document: " + elementId, ex);
        }
    }

    private String[] getParentDocumentFields() {
        if (this.parentDocumentFields == null) {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add("__elementType");
            fields.add("__visibility");
            fields.addAll(this.getConfig().getScoringStrategy().getFieldNames());
            this.parentDocumentFields = fields.toArray(new String[fields.size()]);
        }
        return this.parentDocumentFields;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XContentBuilder buildJsonContentFromProperty(IndexInfo indexInfo, Property property) throws IOException {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
        Object propertyValue = property.getValue();
        if (propertyValue != null && this.shouldIgnoreType(propertyValue.getClass())) {
            return null;
        }
        if (propertyValue instanceof GeoPoint) {
            GeoPoint geoPoint = (GeoPoint)propertyValue;
            HashMap<String, Double> propertyValueMap = new HashMap<String, Double>();
            propertyValueMap.put("lat", geoPoint.getLatitude());
            propertyValueMap.put("lon", geoPoint.getLongitude());
            jsonBuilder.field(property.getName() + "_geo", propertyValueMap);
            if (geoPoint.getDescription() != null) {
                jsonBuilder.field(property.getName(), geoPoint.getDescription());
            }
        } else if (propertyValue instanceof StreamingPropertyValue) {
            StreamingPropertyValue streamingPropertyValue = (StreamingPropertyValue)propertyValue;
            if (!streamingPropertyValue.isSearchIndex()) {
                return null;
            }
            PropertyDefinition propertyDefinition = (PropertyDefinition)indexInfo.getPropertyDefinitions().get(property.getName());
            if (propertyDefinition != null && !propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                return null;
            }
            Class valueType = streamingPropertyValue.getValueType();
            if (valueType != String.class) throw new VertexiumException("Unhandled StreamingPropertyValue type: " + valueType.getName());
            InputStream in = streamingPropertyValue.getInputStream();
            propertyValue = StreamUtils.toString((InputStream)in);
            jsonBuilder.field(property.getName(), propertyValue);
        } else if (propertyValue instanceof String) {
            PropertyDefinition propertyDefinition = (PropertyDefinition)indexInfo.getPropertyDefinitions().get(property.getName());
            if (propertyDefinition == null || propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                jsonBuilder.field(property.getName() + "_exactMatch", propertyValue);
            }
            if (propertyDefinition == null || propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                jsonBuilder.field(property.getName(), propertyValue);
            }
        } else {
            if (propertyValue instanceof DateOnly) {
                propertyValue = ((DateOnly)propertyValue).getDate();
            }
            jsonBuilder.field(property.getName(), propertyValue);
        }
        jsonBuilder.field("__visibility", property.getVisibility().getVisibilityString());
        return jsonBuilder;
    }

    public GraphQuery queryGraph(Graph graph, String queryString, Authorizations authorizations) {
        return new ElasticSearchParentChildGraphQuery(this.getClient(), this.getConfig().getIndicesToQuery(), graph, queryString, this.getAllPropertyDefinitions(), this.getConfig().getScoringStrategy(), authorizations);
    }

    public SimilarToGraphQuery querySimilarTo(Graph graph, String[] similarToFields, String similarToText, Authorizations authorizations) {
        return new ElasticSearchParentChildGraphQuery(this.getClient(), this.getConfig().getIndicesToQuery(), graph, similarToFields, similarToText, this.getAllPropertyDefinitions(), this.getConfig().getScoringStrategy(), authorizations);
    }

    protected void addPropertyToIndex(IndexInfo indexInfo, String propertyName, Class dataType, boolean analyzed, Double boost) throws IOException {
        if (indexInfo.isPropertyDefined(propertyName)) {
            return;
        }
        if (this.shouldIgnoreType(dataType)) {
            return;
        }
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(PROPERTY_TYPE).startObject("_parent").field("type", "element").endObject().startObject("properties").startObject(propertyName).field("store", this.getConfig().isStoreSourceData());
        this.addTypeToMapping(mapping, propertyName, dataType, analyzed, boost);
        mapping.endObject().endObject().endObject().endObject();
        PutMappingResponse response = (PutMappingResponse)this.getClient().admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setIgnoreConflicts(false).setType(PROPERTY_TYPE).setSource(mapping).execute().actionGet();
        LOGGER.debug(response.toString());
        indexInfo.addPropertyDefinition(propertyName, new PropertyDefinition(propertyName, dataType, TextIndexHint.ALL));
    }

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return SearchIndexSecurityGranularity.PROPERTY;
    }
}

