/*
 * Decompiled with CFR 0.152.
 */
package org.neolumin.vertexium.elasticsearch;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.OpenBitSet;
import org.neolumin.vertexium.inmemory.security.Authorizations;
import org.neolumin.vertexium.inmemory.security.ColumnVisibility;
import org.neolumin.vertexium.inmemory.security.VisibilityEvaluator;
import org.neolumin.vertexium.inmemory.security.VisibilityParseException;

public class AuthorizationsFilter
extends Filter {
    public static String VISIBILITY_FIELD_NAME = "__visibility";
    private final VisibilityEvaluator visibilityEvaluator;
    private static final Map<BytesRef, ColumnVisibility> columnVisibilityCache = new ConcurrentHashMap<BytesRef, ColumnVisibility>();

    public AuthorizationsFilter(Authorizations authorizations) {
        this.visibilityEvaluator = new VisibilityEvaluator(authorizations);
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        BytesRef bytesRef;
        AtomicReader reader = context.reader();
        Fields fields = reader.fields();
        Terms terms = fields.terms(VISIBILITY_FIELD_NAME);
        if (terms == null) {
            return null;
        }
        OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
        TermsEnum iterator = terms.iterator(null);
        while ((bytesRef = iterator.next()) != null) {
            this.makeVisible(iterator, bitSet, acceptDocs, AuthorizationsFilter.isVisible(this.visibilityEvaluator, bytesRef));
        }
        return BitsFilteredDocIdSet.wrap((DocIdSet)bitSet, (Bits)acceptDocs);
    }

    private void makeVisible(TermsEnum iterator, OpenBitSet bitSet, Bits liveDocs, boolean visible) throws IOException {
        int doc;
        DocsEnum docsEnum = iterator.docs(liveDocs, null);
        while ((doc = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
            if (visible) {
                bitSet.set((long)doc);
                continue;
            }
            bitSet.clear((long)doc);
        }
    }

    private static boolean isVisible(VisibilityEvaluator visibilityEvaluator, BytesRef bytesRef) throws IOException {
        ColumnVisibility visibility = AuthorizationsFilter.lookupColumnVisibility(bytesRef);
        if (visibility == null) {
            return true;
        }
        try {
            return visibilityEvaluator.evaluate(visibility);
        }
        catch (VisibilityParseException e) {
            throw new IOException(e);
        }
    }

    private static ColumnVisibility lookupColumnVisibility(BytesRef bytesRef) {
        ColumnVisibility visibility = columnVisibilityCache.get(bytesRef);
        if (visibility != null) {
            return visibility;
        }
        byte[] expression = AuthorizationsFilter.trim(bytesRef);
        if (expression.length == 0) {
            return null;
        }
        visibility = new ColumnVisibility(expression);
        columnVisibilityCache.put(bytesRef, visibility);
        return visibility;
    }

    private static byte[] trim(BytesRef bytesRef) {
        byte[] buf = new byte[bytesRef.length];
        System.arraycopy(bytesRef.bytes, bytesRef.offset, buf, 0, bytesRef.length);
        return buf;
    }
}

